/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.PaymentResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class PaymentResult
implements XdrElement {
    PaymentResultCode code;

    public PaymentResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(PaymentResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, PaymentResult encodedPaymentResult) throws IOException {
        stream.writeInt(encodedPaymentResult.getDiscriminant().getValue());
        switch (encodedPaymentResult.getDiscriminant()) {
            case PAYMENT_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PaymentResult.encode(stream, this);
    }

    public static PaymentResult decode(XdrDataInputStream stream) throws IOException {
        PaymentResult decodedPaymentResult = new PaymentResult();
        PaymentResultCode discriminant = PaymentResultCode.decode(stream);
        decodedPaymentResult.setDiscriminant(discriminant);
        switch (decodedPaymentResult.getDiscriminant()) {
            case PAYMENT_SUCCESS: {
                break;
            }
        }
        return decodedPaymentResult;
    }

    public int hashCode() {
        return Objects.hashCode(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PaymentResult)) {
            return false;
        }
        PaymentResult other = (PaymentResult)object;
        return Objects.equal(this.code, other.code);
    }

    public static final class Builder {
        private PaymentResultCode discriminant;

        public Builder discriminant(PaymentResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public PaymentResult build() {
            PaymentResult val = new PaymentResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

