/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum OperationType implements XdrElement
{
    CREATE_ACCOUNT(0),
    PAYMENT(1),
    PATH_PAYMENT_STRICT_RECEIVE(2),
    MANAGE_SELL_OFFER(3),
    CREATE_PASSIVE_SELL_OFFER(4),
    SET_OPTIONS(5),
    CHANGE_TRUST(6),
    ALLOW_TRUST(7),
    ACCOUNT_MERGE(8),
    INFLATION(9),
    MANAGE_DATA(10),
    BUMP_SEQUENCE(11),
    MANAGE_BUY_OFFER(12),
    PATH_PAYMENT_STRICT_SEND(13),
    CREATE_CLAIMABLE_BALANCE(14),
    CLAIM_CLAIMABLE_BALANCE(15),
    BEGIN_SPONSORING_FUTURE_RESERVES(16),
    END_SPONSORING_FUTURE_RESERVES(17),
    REVOKE_SPONSORSHIP(18),
    CLAWBACK(19),
    CLAWBACK_CLAIMABLE_BALANCE(20),
    SET_TRUST_LINE_FLAGS(21),
    LIQUIDITY_POOL_DEPOSIT(22),
    LIQUIDITY_POOL_WITHDRAW(23);

    private int mValue;

    private OperationType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static OperationType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CREATE_ACCOUNT;
            }
            case 1: {
                return PAYMENT;
            }
            case 2: {
                return PATH_PAYMENT_STRICT_RECEIVE;
            }
            case 3: {
                return MANAGE_SELL_OFFER;
            }
            case 4: {
                return CREATE_PASSIVE_SELL_OFFER;
            }
            case 5: {
                return SET_OPTIONS;
            }
            case 6: {
                return CHANGE_TRUST;
            }
            case 7: {
                return ALLOW_TRUST;
            }
            case 8: {
                return ACCOUNT_MERGE;
            }
            case 9: {
                return INFLATION;
            }
            case 10: {
                return MANAGE_DATA;
            }
            case 11: {
                return BUMP_SEQUENCE;
            }
            case 12: {
                return MANAGE_BUY_OFFER;
            }
            case 13: {
                return PATH_PAYMENT_STRICT_SEND;
            }
            case 14: {
                return CREATE_CLAIMABLE_BALANCE;
            }
            case 15: {
                return CLAIM_CLAIMABLE_BALANCE;
            }
            case 16: {
                return BEGIN_SPONSORING_FUTURE_RESERVES;
            }
            case 17: {
                return END_SPONSORING_FUTURE_RESERVES;
            }
            case 18: {
                return REVOKE_SPONSORSHIP;
            }
            case 19: {
                return CLAWBACK;
            }
            case 20: {
                return CLAWBACK_CLAIMABLE_BALANCE;
            }
            case 21: {
                return SET_TRUST_LINE_FLAGS;
            }
            case 22: {
                return LIQUIDITY_POOL_DEPOSIT;
            }
            case 23: {
                return LIQUIDITY_POOL_WITHDRAW;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, OperationType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OperationType.encode(stream, this);
    }
}

