/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountMergeResult;
import org.stellar.sdk.xdr.AllowTrustResult;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesResult;
import org.stellar.sdk.xdr.BumpSequenceResult;
import org.stellar.sdk.xdr.ChangeTrustResult;
import org.stellar.sdk.xdr.ClaimClaimableBalanceResult;
import org.stellar.sdk.xdr.ClawbackClaimableBalanceResult;
import org.stellar.sdk.xdr.ClawbackResult;
import org.stellar.sdk.xdr.CreateAccountResult;
import org.stellar.sdk.xdr.CreateClaimableBalanceResult;
import org.stellar.sdk.xdr.EndSponsoringFutureReservesResult;
import org.stellar.sdk.xdr.InflationResult;
import org.stellar.sdk.xdr.LiquidityPoolDepositResult;
import org.stellar.sdk.xdr.LiquidityPoolWithdrawResult;
import org.stellar.sdk.xdr.ManageBuyOfferResult;
import org.stellar.sdk.xdr.ManageDataResult;
import org.stellar.sdk.xdr.ManageSellOfferResult;
import org.stellar.sdk.xdr.OperationResultCode;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveResult;
import org.stellar.sdk.xdr.PathPaymentStrictSendResult;
import org.stellar.sdk.xdr.PaymentResult;
import org.stellar.sdk.xdr.RevokeSponsorshipResult;
import org.stellar.sdk.xdr.SetOptionsResult;
import org.stellar.sdk.xdr.SetTrustLineFlagsResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class OperationResult
implements XdrElement {
    OperationResultCode code;
    private OperationResultTr tr;

    public OperationResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(OperationResultCode value) {
        this.code = value;
    }

    public OperationResultTr getTr() {
        return this.tr;
    }

    public void setTr(OperationResultTr value) {
        this.tr = value;
    }

    public static void encode(XdrDataOutputStream stream, OperationResult encodedOperationResult) throws IOException {
        stream.writeInt(encodedOperationResult.getDiscriminant().getValue());
        switch (encodedOperationResult.getDiscriminant()) {
            case opINNER: {
                OperationResultTr.encode(stream, encodedOperationResult.tr);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OperationResult.encode(stream, this);
    }

    public static OperationResult decode(XdrDataInputStream stream) throws IOException {
        OperationResult decodedOperationResult = new OperationResult();
        OperationResultCode discriminant = OperationResultCode.decode(stream);
        decodedOperationResult.setDiscriminant(discriminant);
        switch (decodedOperationResult.getDiscriminant()) {
            case opINNER: {
                decodedOperationResult.tr = OperationResultTr.decode(stream);
                break;
            }
        }
        return decodedOperationResult;
    }

    public int hashCode() {
        return Objects.hashCode(this.tr, this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OperationResult)) {
            return false;
        }
        OperationResult other = (OperationResult)object;
        return Objects.equal(this.tr, other.tr) && Objects.equal(this.code, other.code);
    }

    public static class OperationResultTr {
        OperationType type;
        private CreateAccountResult createAccountResult;
        private PaymentResult paymentResult;
        private PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
        private ManageSellOfferResult manageSellOfferResult;
        private ManageSellOfferResult createPassiveSellOfferResult;
        private SetOptionsResult setOptionsResult;
        private ChangeTrustResult changeTrustResult;
        private AllowTrustResult allowTrustResult;
        private AccountMergeResult accountMergeResult;
        private InflationResult inflationResult;
        private ManageDataResult manageDataResult;
        private BumpSequenceResult bumpSeqResult;
        private ManageBuyOfferResult manageBuyOfferResult;
        private PathPaymentStrictSendResult pathPaymentStrictSendResult;
        private CreateClaimableBalanceResult createClaimableBalanceResult;
        private ClaimClaimableBalanceResult claimClaimableBalanceResult;
        private BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
        private EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
        private RevokeSponsorshipResult revokeSponsorshipResult;
        private ClawbackResult clawbackResult;
        private ClawbackClaimableBalanceResult clawbackClaimableBalanceResult;
        private SetTrustLineFlagsResult setTrustLineFlagsResult;
        private LiquidityPoolDepositResult liquidityPoolDepositResult;
        private LiquidityPoolWithdrawResult liquidityPoolWithdrawResult;

        public OperationType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(OperationType value) {
            this.type = value;
        }

        public CreateAccountResult getCreateAccountResult() {
            return this.createAccountResult;
        }

        public void setCreateAccountResult(CreateAccountResult value) {
            this.createAccountResult = value;
        }

        public PaymentResult getPaymentResult() {
            return this.paymentResult;
        }

        public void setPaymentResult(PaymentResult value) {
            this.paymentResult = value;
        }

        public PathPaymentStrictReceiveResult getPathPaymentStrictReceiveResult() {
            return this.pathPaymentStrictReceiveResult;
        }

        public void setPathPaymentStrictReceiveResult(PathPaymentStrictReceiveResult value) {
            this.pathPaymentStrictReceiveResult = value;
        }

        public ManageSellOfferResult getManageSellOfferResult() {
            return this.manageSellOfferResult;
        }

        public void setManageSellOfferResult(ManageSellOfferResult value) {
            this.manageSellOfferResult = value;
        }

        public ManageSellOfferResult getCreatePassiveSellOfferResult() {
            return this.createPassiveSellOfferResult;
        }

        public void setCreatePassiveSellOfferResult(ManageSellOfferResult value) {
            this.createPassiveSellOfferResult = value;
        }

        public SetOptionsResult getSetOptionsResult() {
            return this.setOptionsResult;
        }

        public void setSetOptionsResult(SetOptionsResult value) {
            this.setOptionsResult = value;
        }

        public ChangeTrustResult getChangeTrustResult() {
            return this.changeTrustResult;
        }

        public void setChangeTrustResult(ChangeTrustResult value) {
            this.changeTrustResult = value;
        }

        public AllowTrustResult getAllowTrustResult() {
            return this.allowTrustResult;
        }

        public void setAllowTrustResult(AllowTrustResult value) {
            this.allowTrustResult = value;
        }

        public AccountMergeResult getAccountMergeResult() {
            return this.accountMergeResult;
        }

        public void setAccountMergeResult(AccountMergeResult value) {
            this.accountMergeResult = value;
        }

        public InflationResult getInflationResult() {
            return this.inflationResult;
        }

        public void setInflationResult(InflationResult value) {
            this.inflationResult = value;
        }

        public ManageDataResult getManageDataResult() {
            return this.manageDataResult;
        }

        public void setManageDataResult(ManageDataResult value) {
            this.manageDataResult = value;
        }

        public BumpSequenceResult getBumpSeqResult() {
            return this.bumpSeqResult;
        }

        public void setBumpSeqResult(BumpSequenceResult value) {
            this.bumpSeqResult = value;
        }

        public ManageBuyOfferResult getManageBuyOfferResult() {
            return this.manageBuyOfferResult;
        }

        public void setManageBuyOfferResult(ManageBuyOfferResult value) {
            this.manageBuyOfferResult = value;
        }

        public PathPaymentStrictSendResult getPathPaymentStrictSendResult() {
            return this.pathPaymentStrictSendResult;
        }

        public void setPathPaymentStrictSendResult(PathPaymentStrictSendResult value) {
            this.pathPaymentStrictSendResult = value;
        }

        public CreateClaimableBalanceResult getCreateClaimableBalanceResult() {
            return this.createClaimableBalanceResult;
        }

        public void setCreateClaimableBalanceResult(CreateClaimableBalanceResult value) {
            this.createClaimableBalanceResult = value;
        }

        public ClaimClaimableBalanceResult getClaimClaimableBalanceResult() {
            return this.claimClaimableBalanceResult;
        }

        public void setClaimClaimableBalanceResult(ClaimClaimableBalanceResult value) {
            this.claimClaimableBalanceResult = value;
        }

        public BeginSponsoringFutureReservesResult getBeginSponsoringFutureReservesResult() {
            return this.beginSponsoringFutureReservesResult;
        }

        public void setBeginSponsoringFutureReservesResult(BeginSponsoringFutureReservesResult value) {
            this.beginSponsoringFutureReservesResult = value;
        }

        public EndSponsoringFutureReservesResult getEndSponsoringFutureReservesResult() {
            return this.endSponsoringFutureReservesResult;
        }

        public void setEndSponsoringFutureReservesResult(EndSponsoringFutureReservesResult value) {
            this.endSponsoringFutureReservesResult = value;
        }

        public RevokeSponsorshipResult getRevokeSponsorshipResult() {
            return this.revokeSponsorshipResult;
        }

        public void setRevokeSponsorshipResult(RevokeSponsorshipResult value) {
            this.revokeSponsorshipResult = value;
        }

        public ClawbackResult getClawbackResult() {
            return this.clawbackResult;
        }

        public void setClawbackResult(ClawbackResult value) {
            this.clawbackResult = value;
        }

        public ClawbackClaimableBalanceResult getClawbackClaimableBalanceResult() {
            return this.clawbackClaimableBalanceResult;
        }

        public void setClawbackClaimableBalanceResult(ClawbackClaimableBalanceResult value) {
            this.clawbackClaimableBalanceResult = value;
        }

        public SetTrustLineFlagsResult getSetTrustLineFlagsResult() {
            return this.setTrustLineFlagsResult;
        }

        public void setSetTrustLineFlagsResult(SetTrustLineFlagsResult value) {
            this.setTrustLineFlagsResult = value;
        }

        public LiquidityPoolDepositResult getLiquidityPoolDepositResult() {
            return this.liquidityPoolDepositResult;
        }

        public void setLiquidityPoolDepositResult(LiquidityPoolDepositResult value) {
            this.liquidityPoolDepositResult = value;
        }

        public LiquidityPoolWithdrawResult getLiquidityPoolWithdrawResult() {
            return this.liquidityPoolWithdrawResult;
        }

        public void setLiquidityPoolWithdrawResult(LiquidityPoolWithdrawResult value) {
            this.liquidityPoolWithdrawResult = value;
        }

        public static void encode(XdrDataOutputStream stream, OperationResultTr encodedOperationResultTr) throws IOException {
            stream.writeInt(encodedOperationResultTr.getDiscriminant().getValue());
            switch (encodedOperationResultTr.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    CreateAccountResult.encode(stream, encodedOperationResultTr.createAccountResult);
                    break;
                }
                case PAYMENT: {
                    PaymentResult.encode(stream, encodedOperationResultTr.paymentResult);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    PathPaymentStrictReceiveResult.encode(stream, encodedOperationResultTr.pathPaymentStrictReceiveResult);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    ManageSellOfferResult.encode(stream, encodedOperationResultTr.manageSellOfferResult);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    ManageSellOfferResult.encode(stream, encodedOperationResultTr.createPassiveSellOfferResult);
                    break;
                }
                case SET_OPTIONS: {
                    SetOptionsResult.encode(stream, encodedOperationResultTr.setOptionsResult);
                    break;
                }
                case CHANGE_TRUST: {
                    ChangeTrustResult.encode(stream, encodedOperationResultTr.changeTrustResult);
                    break;
                }
                case ALLOW_TRUST: {
                    AllowTrustResult.encode(stream, encodedOperationResultTr.allowTrustResult);
                    break;
                }
                case ACCOUNT_MERGE: {
                    AccountMergeResult.encode(stream, encodedOperationResultTr.accountMergeResult);
                    break;
                }
                case INFLATION: {
                    InflationResult.encode(stream, encodedOperationResultTr.inflationResult);
                    break;
                }
                case MANAGE_DATA: {
                    ManageDataResult.encode(stream, encodedOperationResultTr.manageDataResult);
                    break;
                }
                case BUMP_SEQUENCE: {
                    BumpSequenceResult.encode(stream, encodedOperationResultTr.bumpSeqResult);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    ManageBuyOfferResult.encode(stream, encodedOperationResultTr.manageBuyOfferResult);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    PathPaymentStrictSendResult.encode(stream, encodedOperationResultTr.pathPaymentStrictSendResult);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    CreateClaimableBalanceResult.encode(stream, encodedOperationResultTr.createClaimableBalanceResult);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    ClaimClaimableBalanceResult.encode(stream, encodedOperationResultTr.claimClaimableBalanceResult);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    BeginSponsoringFutureReservesResult.encode(stream, encodedOperationResultTr.beginSponsoringFutureReservesResult);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    EndSponsoringFutureReservesResult.encode(stream, encodedOperationResultTr.endSponsoringFutureReservesResult);
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    RevokeSponsorshipResult.encode(stream, encodedOperationResultTr.revokeSponsorshipResult);
                    break;
                }
                case CLAWBACK: {
                    ClawbackResult.encode(stream, encodedOperationResultTr.clawbackResult);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    ClawbackClaimableBalanceResult.encode(stream, encodedOperationResultTr.clawbackClaimableBalanceResult);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    SetTrustLineFlagsResult.encode(stream, encodedOperationResultTr.setTrustLineFlagsResult);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    LiquidityPoolDepositResult.encode(stream, encodedOperationResultTr.liquidityPoolDepositResult);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    LiquidityPoolWithdrawResult.encode(stream, encodedOperationResultTr.liquidityPoolWithdrawResult);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OperationResultTr.encode(stream, this);
        }

        public static OperationResultTr decode(XdrDataInputStream stream) throws IOException {
            OperationResultTr decodedOperationResultTr = new OperationResultTr();
            OperationType discriminant = OperationType.decode(stream);
            decodedOperationResultTr.setDiscriminant(discriminant);
            switch (decodedOperationResultTr.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    decodedOperationResultTr.createAccountResult = CreateAccountResult.decode(stream);
                    break;
                }
                case PAYMENT: {
                    decodedOperationResultTr.paymentResult = PaymentResult.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    decodedOperationResultTr.pathPaymentStrictReceiveResult = PathPaymentStrictReceiveResult.decode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    decodedOperationResultTr.manageSellOfferResult = ManageSellOfferResult.decode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    decodedOperationResultTr.createPassiveSellOfferResult = ManageSellOfferResult.decode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    decodedOperationResultTr.setOptionsResult = SetOptionsResult.decode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    decodedOperationResultTr.changeTrustResult = ChangeTrustResult.decode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    decodedOperationResultTr.allowTrustResult = AllowTrustResult.decode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    decodedOperationResultTr.accountMergeResult = AccountMergeResult.decode(stream);
                    break;
                }
                case INFLATION: {
                    decodedOperationResultTr.inflationResult = InflationResult.decode(stream);
                    break;
                }
                case MANAGE_DATA: {
                    decodedOperationResultTr.manageDataResult = ManageDataResult.decode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    decodedOperationResultTr.bumpSeqResult = BumpSequenceResult.decode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    decodedOperationResultTr.manageBuyOfferResult = ManageBuyOfferResult.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    decodedOperationResultTr.pathPaymentStrictSendResult = PathPaymentStrictSendResult.decode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.createClaimableBalanceResult = CreateClaimableBalanceResult.decode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.claimClaimableBalanceResult = ClaimClaimableBalanceResult.decode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationResultTr.beginSponsoringFutureReservesResult = BeginSponsoringFutureReservesResult.decode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationResultTr.endSponsoringFutureReservesResult = EndSponsoringFutureReservesResult.decode(stream);
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    decodedOperationResultTr.revokeSponsorshipResult = RevokeSponsorshipResult.decode(stream);
                    break;
                }
                case CLAWBACK: {
                    decodedOperationResultTr.clawbackResult = ClawbackResult.decode(stream);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.clawbackClaimableBalanceResult = ClawbackClaimableBalanceResult.decode(stream);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    decodedOperationResultTr.setTrustLineFlagsResult = SetTrustLineFlagsResult.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    decodedOperationResultTr.liquidityPoolDepositResult = LiquidityPoolDepositResult.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    decodedOperationResultTr.liquidityPoolWithdrawResult = LiquidityPoolWithdrawResult.decode(stream);
                }
            }
            return decodedOperationResultTr;
        }

        public int hashCode() {
            return Objects.hashCode(this.createAccountResult, this.paymentResult, this.pathPaymentStrictReceiveResult, this.manageSellOfferResult, this.createPassiveSellOfferResult, this.setOptionsResult, this.changeTrustResult, this.allowTrustResult, this.accountMergeResult, this.inflationResult, this.manageDataResult, this.bumpSeqResult, this.manageBuyOfferResult, this.pathPaymentStrictSendResult, this.createClaimableBalanceResult, this.claimClaimableBalanceResult, this.beginSponsoringFutureReservesResult, this.endSponsoringFutureReservesResult, this.revokeSponsorshipResult, this.clawbackResult, this.clawbackClaimableBalanceResult, this.setTrustLineFlagsResult, this.liquidityPoolDepositResult, this.liquidityPoolWithdrawResult, this.type);
        }

        public boolean equals(Object object) {
            if (!(object instanceof OperationResultTr)) {
                return false;
            }
            OperationResultTr other = (OperationResultTr)object;
            return Objects.equal(this.createAccountResult, other.createAccountResult) && Objects.equal(this.paymentResult, other.paymentResult) && Objects.equal(this.pathPaymentStrictReceiveResult, other.pathPaymentStrictReceiveResult) && Objects.equal(this.manageSellOfferResult, other.manageSellOfferResult) && Objects.equal(this.createPassiveSellOfferResult, other.createPassiveSellOfferResult) && Objects.equal(this.setOptionsResult, other.setOptionsResult) && Objects.equal(this.changeTrustResult, other.changeTrustResult) && Objects.equal(this.allowTrustResult, other.allowTrustResult) && Objects.equal(this.accountMergeResult, other.accountMergeResult) && Objects.equal(this.inflationResult, other.inflationResult) && Objects.equal(this.manageDataResult, other.manageDataResult) && Objects.equal(this.bumpSeqResult, other.bumpSeqResult) && Objects.equal(this.manageBuyOfferResult, other.manageBuyOfferResult) && Objects.equal(this.pathPaymentStrictSendResult, other.pathPaymentStrictSendResult) && Objects.equal(this.createClaimableBalanceResult, other.createClaimableBalanceResult) && Objects.equal(this.claimClaimableBalanceResult, other.claimClaimableBalanceResult) && Objects.equal(this.beginSponsoringFutureReservesResult, other.beginSponsoringFutureReservesResult) && Objects.equal(this.endSponsoringFutureReservesResult, other.endSponsoringFutureReservesResult) && Objects.equal(this.revokeSponsorshipResult, other.revokeSponsorshipResult) && Objects.equal(this.clawbackResult, other.clawbackResult) && Objects.equal(this.clawbackClaimableBalanceResult, other.clawbackClaimableBalanceResult) && Objects.equal(this.setTrustLineFlagsResult, other.setTrustLineFlagsResult) && Objects.equal(this.liquidityPoolDepositResult, other.liquidityPoolDepositResult) && Objects.equal(this.liquidityPoolWithdrawResult, other.liquidityPoolWithdrawResult) && Objects.equal(this.type, other.type);
        }

        public static final class Builder {
            private OperationType discriminant;
            private CreateAccountResult createAccountResult;
            private PaymentResult paymentResult;
            private PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
            private ManageSellOfferResult manageSellOfferResult;
            private ManageSellOfferResult createPassiveSellOfferResult;
            private SetOptionsResult setOptionsResult;
            private ChangeTrustResult changeTrustResult;
            private AllowTrustResult allowTrustResult;
            private AccountMergeResult accountMergeResult;
            private InflationResult inflationResult;
            private ManageDataResult manageDataResult;
            private BumpSequenceResult bumpSeqResult;
            private ManageBuyOfferResult manageBuyOfferResult;
            private PathPaymentStrictSendResult pathPaymentStrictSendResult;
            private CreateClaimableBalanceResult createClaimableBalanceResult;
            private ClaimClaimableBalanceResult claimClaimableBalanceResult;
            private BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
            private EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
            private RevokeSponsorshipResult revokeSponsorshipResult;
            private ClawbackResult clawbackResult;
            private ClawbackClaimableBalanceResult clawbackClaimableBalanceResult;
            private SetTrustLineFlagsResult setTrustLineFlagsResult;
            private LiquidityPoolDepositResult liquidityPoolDepositResult;
            private LiquidityPoolWithdrawResult liquidityPoolWithdrawResult;

            public Builder discriminant(OperationType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder createAccountResult(CreateAccountResult createAccountResult) {
                this.createAccountResult = createAccountResult;
                return this;
            }

            public Builder paymentResult(PaymentResult paymentResult) {
                this.paymentResult = paymentResult;
                return this;
            }

            public Builder pathPaymentStrictReceiveResult(PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult) {
                this.pathPaymentStrictReceiveResult = pathPaymentStrictReceiveResult;
                return this;
            }

            public Builder manageSellOfferResult(ManageSellOfferResult manageSellOfferResult) {
                this.manageSellOfferResult = manageSellOfferResult;
                return this;
            }

            public Builder createPassiveSellOfferResult(ManageSellOfferResult createPassiveSellOfferResult) {
                this.createPassiveSellOfferResult = createPassiveSellOfferResult;
                return this;
            }

            public Builder setOptionsResult(SetOptionsResult setOptionsResult) {
                this.setOptionsResult = setOptionsResult;
                return this;
            }

            public Builder changeTrustResult(ChangeTrustResult changeTrustResult) {
                this.changeTrustResult = changeTrustResult;
                return this;
            }

            public Builder allowTrustResult(AllowTrustResult allowTrustResult) {
                this.allowTrustResult = allowTrustResult;
                return this;
            }

            public Builder accountMergeResult(AccountMergeResult accountMergeResult) {
                this.accountMergeResult = accountMergeResult;
                return this;
            }

            public Builder inflationResult(InflationResult inflationResult) {
                this.inflationResult = inflationResult;
                return this;
            }

            public Builder manageDataResult(ManageDataResult manageDataResult) {
                this.manageDataResult = manageDataResult;
                return this;
            }

            public Builder bumpSeqResult(BumpSequenceResult bumpSeqResult) {
                this.bumpSeqResult = bumpSeqResult;
                return this;
            }

            public Builder manageBuyOfferResult(ManageBuyOfferResult manageBuyOfferResult) {
                this.manageBuyOfferResult = manageBuyOfferResult;
                return this;
            }

            public Builder pathPaymentStrictSendResult(PathPaymentStrictSendResult pathPaymentStrictSendResult) {
                this.pathPaymentStrictSendResult = pathPaymentStrictSendResult;
                return this;
            }

            public Builder createClaimableBalanceResult(CreateClaimableBalanceResult createClaimableBalanceResult) {
                this.createClaimableBalanceResult = createClaimableBalanceResult;
                return this;
            }

            public Builder claimClaimableBalanceResult(ClaimClaimableBalanceResult claimClaimableBalanceResult) {
                this.claimClaimableBalanceResult = claimClaimableBalanceResult;
                return this;
            }

            public Builder beginSponsoringFutureReservesResult(BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult) {
                this.beginSponsoringFutureReservesResult = beginSponsoringFutureReservesResult;
                return this;
            }

            public Builder endSponsoringFutureReservesResult(EndSponsoringFutureReservesResult endSponsoringFutureReservesResult) {
                this.endSponsoringFutureReservesResult = endSponsoringFutureReservesResult;
                return this;
            }

            public Builder revokeSponsorshipResult(RevokeSponsorshipResult revokeSponsorshipResult) {
                this.revokeSponsorshipResult = revokeSponsorshipResult;
                return this;
            }

            public Builder clawbackResult(ClawbackResult clawbackResult) {
                this.clawbackResult = clawbackResult;
                return this;
            }

            public Builder clawbackClaimableBalanceResult(ClawbackClaimableBalanceResult clawbackClaimableBalanceResult) {
                this.clawbackClaimableBalanceResult = clawbackClaimableBalanceResult;
                return this;
            }

            public Builder setTrustLineFlagsResult(SetTrustLineFlagsResult setTrustLineFlagsResult) {
                this.setTrustLineFlagsResult = setTrustLineFlagsResult;
                return this;
            }

            public Builder liquidityPoolDepositResult(LiquidityPoolDepositResult liquidityPoolDepositResult) {
                this.liquidityPoolDepositResult = liquidityPoolDepositResult;
                return this;
            }

            public Builder liquidityPoolWithdrawResult(LiquidityPoolWithdrawResult liquidityPoolWithdrawResult) {
                this.liquidityPoolWithdrawResult = liquidityPoolWithdrawResult;
                return this;
            }

            public OperationResultTr build() {
                OperationResultTr val = new OperationResultTr();
                val.setDiscriminant(this.discriminant);
                val.setCreateAccountResult(this.createAccountResult);
                val.setPaymentResult(this.paymentResult);
                val.setPathPaymentStrictReceiveResult(this.pathPaymentStrictReceiveResult);
                val.setManageSellOfferResult(this.manageSellOfferResult);
                val.setCreatePassiveSellOfferResult(this.createPassiveSellOfferResult);
                val.setSetOptionsResult(this.setOptionsResult);
                val.setChangeTrustResult(this.changeTrustResult);
                val.setAllowTrustResult(this.allowTrustResult);
                val.setAccountMergeResult(this.accountMergeResult);
                val.setInflationResult(this.inflationResult);
                val.setManageDataResult(this.manageDataResult);
                val.setBumpSeqResult(this.bumpSeqResult);
                val.setManageBuyOfferResult(this.manageBuyOfferResult);
                val.setPathPaymentStrictSendResult(this.pathPaymentStrictSendResult);
                val.setCreateClaimableBalanceResult(this.createClaimableBalanceResult);
                val.setClaimClaimableBalanceResult(this.claimClaimableBalanceResult);
                val.setBeginSponsoringFutureReservesResult(this.beginSponsoringFutureReservesResult);
                val.setEndSponsoringFutureReservesResult(this.endSponsoringFutureReservesResult);
                val.setRevokeSponsorshipResult(this.revokeSponsorshipResult);
                val.setClawbackResult(this.clawbackResult);
                val.setClawbackClaimableBalanceResult(this.clawbackClaimableBalanceResult);
                val.setSetTrustLineFlagsResult(this.setTrustLineFlagsResult);
                val.setLiquidityPoolDepositResult(this.liquidityPoolDepositResult);
                val.setLiquidityPoolWithdrawResult(this.liquidityPoolWithdrawResult);
                return val;
            }
        }
    }

    public static final class Builder {
        private OperationResultCode discriminant;
        private OperationResultTr tr;

        public Builder discriminant(OperationResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder tr(OperationResultTr tr) {
            this.tr = tr;
            return this;
        }

        public OperationResult build() {
            OperationResult val = new OperationResult();
            val.setDiscriminant(this.discriminant);
            val.setTr(this.tr);
            return val;
        }
    }
}

