/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AllowTrustOp;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesOp;
import org.stellar.sdk.xdr.BumpSequenceOp;
import org.stellar.sdk.xdr.ChangeTrustOp;
import org.stellar.sdk.xdr.ClaimClaimableBalanceOp;
import org.stellar.sdk.xdr.ClawbackClaimableBalanceOp;
import org.stellar.sdk.xdr.ClawbackOp;
import org.stellar.sdk.xdr.CreateAccountOp;
import org.stellar.sdk.xdr.CreateClaimableBalanceOp;
import org.stellar.sdk.xdr.CreatePassiveSellOfferOp;
import org.stellar.sdk.xdr.LiquidityPoolDepositOp;
import org.stellar.sdk.xdr.LiquidityPoolWithdrawOp;
import org.stellar.sdk.xdr.ManageBuyOfferOp;
import org.stellar.sdk.xdr.ManageDataOp;
import org.stellar.sdk.xdr.ManageSellOfferOp;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveOp;
import org.stellar.sdk.xdr.PathPaymentStrictSendOp;
import org.stellar.sdk.xdr.PaymentOp;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.SetOptionsOp;
import org.stellar.sdk.xdr.SetTrustLineFlagsOp;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class Operation
implements XdrElement {
    private MuxedAccount sourceAccount;
    private OperationBody body;

    public MuxedAccount getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(MuxedAccount value) {
        this.sourceAccount = value;
    }

    public OperationBody getBody() {
        return this.body;
    }

    public void setBody(OperationBody value) {
        this.body = value;
    }

    public static void encode(XdrDataOutputStream stream, Operation encodedOperation) throws IOException {
        if (encodedOperation.sourceAccount != null) {
            stream.writeInt(1);
            MuxedAccount.encode(stream, encodedOperation.sourceAccount);
        } else {
            stream.writeInt(0);
        }
        OperationBody.encode(stream, encodedOperation.body);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Operation.encode(stream, this);
    }

    public static Operation decode(XdrDataInputStream stream) throws IOException {
        Operation decodedOperation = new Operation();
        int sourceAccountPresent = stream.readInt();
        if (sourceAccountPresent != 0) {
            decodedOperation.sourceAccount = MuxedAccount.decode(stream);
        }
        decodedOperation.body = OperationBody.decode(stream);
        return decodedOperation;
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceAccount, this.body);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)object;
        return Objects.equal(this.sourceAccount, other.sourceAccount) && Objects.equal(this.body, other.body);
    }

    public static class OperationBody {
        OperationType type;
        private CreateAccountOp createAccountOp;
        private PaymentOp paymentOp;
        private PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
        private ManageSellOfferOp manageSellOfferOp;
        private CreatePassiveSellOfferOp createPassiveSellOfferOp;
        private SetOptionsOp setOptionsOp;
        private ChangeTrustOp changeTrustOp;
        private AllowTrustOp allowTrustOp;
        private MuxedAccount destination;
        private ManageDataOp manageDataOp;
        private BumpSequenceOp bumpSequenceOp;
        private ManageBuyOfferOp manageBuyOfferOp;
        private PathPaymentStrictSendOp pathPaymentStrictSendOp;
        private CreateClaimableBalanceOp createClaimableBalanceOp;
        private ClaimClaimableBalanceOp claimClaimableBalanceOp;
        private BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
        private RevokeSponsorshipOp revokeSponsorshipOp;
        private ClawbackOp clawbackOp;
        private ClawbackClaimableBalanceOp clawbackClaimableBalanceOp;
        private SetTrustLineFlagsOp setTrustLineFlagsOp;
        private LiquidityPoolDepositOp liquidityPoolDepositOp;
        private LiquidityPoolWithdrawOp liquidityPoolWithdrawOp;

        public OperationType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(OperationType value) {
            this.type = value;
        }

        public CreateAccountOp getCreateAccountOp() {
            return this.createAccountOp;
        }

        public void setCreateAccountOp(CreateAccountOp value) {
            this.createAccountOp = value;
        }

        public PaymentOp getPaymentOp() {
            return this.paymentOp;
        }

        public void setPaymentOp(PaymentOp value) {
            this.paymentOp = value;
        }

        public PathPaymentStrictReceiveOp getPathPaymentStrictReceiveOp() {
            return this.pathPaymentStrictReceiveOp;
        }

        public void setPathPaymentStrictReceiveOp(PathPaymentStrictReceiveOp value) {
            this.pathPaymentStrictReceiveOp = value;
        }

        public ManageSellOfferOp getManageSellOfferOp() {
            return this.manageSellOfferOp;
        }

        public void setManageSellOfferOp(ManageSellOfferOp value) {
            this.manageSellOfferOp = value;
        }

        public CreatePassiveSellOfferOp getCreatePassiveSellOfferOp() {
            return this.createPassiveSellOfferOp;
        }

        public void setCreatePassiveSellOfferOp(CreatePassiveSellOfferOp value) {
            this.createPassiveSellOfferOp = value;
        }

        public SetOptionsOp getSetOptionsOp() {
            return this.setOptionsOp;
        }

        public void setSetOptionsOp(SetOptionsOp value) {
            this.setOptionsOp = value;
        }

        public ChangeTrustOp getChangeTrustOp() {
            return this.changeTrustOp;
        }

        public void setChangeTrustOp(ChangeTrustOp value) {
            this.changeTrustOp = value;
        }

        public AllowTrustOp getAllowTrustOp() {
            return this.allowTrustOp;
        }

        public void setAllowTrustOp(AllowTrustOp value) {
            this.allowTrustOp = value;
        }

        public MuxedAccount getDestination() {
            return this.destination;
        }

        public void setDestination(MuxedAccount value) {
            this.destination = value;
        }

        public ManageDataOp getManageDataOp() {
            return this.manageDataOp;
        }

        public void setManageDataOp(ManageDataOp value) {
            this.manageDataOp = value;
        }

        public BumpSequenceOp getBumpSequenceOp() {
            return this.bumpSequenceOp;
        }

        public void setBumpSequenceOp(BumpSequenceOp value) {
            this.bumpSequenceOp = value;
        }

        public ManageBuyOfferOp getManageBuyOfferOp() {
            return this.manageBuyOfferOp;
        }

        public void setManageBuyOfferOp(ManageBuyOfferOp value) {
            this.manageBuyOfferOp = value;
        }

        public PathPaymentStrictSendOp getPathPaymentStrictSendOp() {
            return this.pathPaymentStrictSendOp;
        }

        public void setPathPaymentStrictSendOp(PathPaymentStrictSendOp value) {
            this.pathPaymentStrictSendOp = value;
        }

        public CreateClaimableBalanceOp getCreateClaimableBalanceOp() {
            return this.createClaimableBalanceOp;
        }

        public void setCreateClaimableBalanceOp(CreateClaimableBalanceOp value) {
            this.createClaimableBalanceOp = value;
        }

        public ClaimClaimableBalanceOp getClaimClaimableBalanceOp() {
            return this.claimClaimableBalanceOp;
        }

        public void setClaimClaimableBalanceOp(ClaimClaimableBalanceOp value) {
            this.claimClaimableBalanceOp = value;
        }

        public BeginSponsoringFutureReservesOp getBeginSponsoringFutureReservesOp() {
            return this.beginSponsoringFutureReservesOp;
        }

        public void setBeginSponsoringFutureReservesOp(BeginSponsoringFutureReservesOp value) {
            this.beginSponsoringFutureReservesOp = value;
        }

        public RevokeSponsorshipOp getRevokeSponsorshipOp() {
            return this.revokeSponsorshipOp;
        }

        public void setRevokeSponsorshipOp(RevokeSponsorshipOp value) {
            this.revokeSponsorshipOp = value;
        }

        public ClawbackOp getClawbackOp() {
            return this.clawbackOp;
        }

        public void setClawbackOp(ClawbackOp value) {
            this.clawbackOp = value;
        }

        public ClawbackClaimableBalanceOp getClawbackClaimableBalanceOp() {
            return this.clawbackClaimableBalanceOp;
        }

        public void setClawbackClaimableBalanceOp(ClawbackClaimableBalanceOp value) {
            this.clawbackClaimableBalanceOp = value;
        }

        public SetTrustLineFlagsOp getSetTrustLineFlagsOp() {
            return this.setTrustLineFlagsOp;
        }

        public void setSetTrustLineFlagsOp(SetTrustLineFlagsOp value) {
            this.setTrustLineFlagsOp = value;
        }

        public LiquidityPoolDepositOp getLiquidityPoolDepositOp() {
            return this.liquidityPoolDepositOp;
        }

        public void setLiquidityPoolDepositOp(LiquidityPoolDepositOp value) {
            this.liquidityPoolDepositOp = value;
        }

        public LiquidityPoolWithdrawOp getLiquidityPoolWithdrawOp() {
            return this.liquidityPoolWithdrawOp;
        }

        public void setLiquidityPoolWithdrawOp(LiquidityPoolWithdrawOp value) {
            this.liquidityPoolWithdrawOp = value;
        }

        public static void encode(XdrDataOutputStream stream, OperationBody encodedOperationBody) throws IOException {
            stream.writeInt(encodedOperationBody.getDiscriminant().getValue());
            switch (encodedOperationBody.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    CreateAccountOp.encode(stream, encodedOperationBody.createAccountOp);
                    break;
                }
                case PAYMENT: {
                    PaymentOp.encode(stream, encodedOperationBody.paymentOp);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    PathPaymentStrictReceiveOp.encode(stream, encodedOperationBody.pathPaymentStrictReceiveOp);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    ManageSellOfferOp.encode(stream, encodedOperationBody.manageSellOfferOp);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    CreatePassiveSellOfferOp.encode(stream, encodedOperationBody.createPassiveSellOfferOp);
                    break;
                }
                case SET_OPTIONS: {
                    SetOptionsOp.encode(stream, encodedOperationBody.setOptionsOp);
                    break;
                }
                case CHANGE_TRUST: {
                    ChangeTrustOp.encode(stream, encodedOperationBody.changeTrustOp);
                    break;
                }
                case ALLOW_TRUST: {
                    AllowTrustOp.encode(stream, encodedOperationBody.allowTrustOp);
                    break;
                }
                case ACCOUNT_MERGE: {
                    MuxedAccount.encode(stream, encodedOperationBody.destination);
                    break;
                }
                case INFLATION: {
                    break;
                }
                case MANAGE_DATA: {
                    ManageDataOp.encode(stream, encodedOperationBody.manageDataOp);
                    break;
                }
                case BUMP_SEQUENCE: {
                    BumpSequenceOp.encode(stream, encodedOperationBody.bumpSequenceOp);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    ManageBuyOfferOp.encode(stream, encodedOperationBody.manageBuyOfferOp);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    PathPaymentStrictSendOp.encode(stream, encodedOperationBody.pathPaymentStrictSendOp);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    CreateClaimableBalanceOp.encode(stream, encodedOperationBody.createClaimableBalanceOp);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    ClaimClaimableBalanceOp.encode(stream, encodedOperationBody.claimClaimableBalanceOp);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    BeginSponsoringFutureReservesOp.encode(stream, encodedOperationBody.beginSponsoringFutureReservesOp);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    RevokeSponsorshipOp.encode(stream, encodedOperationBody.revokeSponsorshipOp);
                    break;
                }
                case CLAWBACK: {
                    ClawbackOp.encode(stream, encodedOperationBody.clawbackOp);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    ClawbackClaimableBalanceOp.encode(stream, encodedOperationBody.clawbackClaimableBalanceOp);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    SetTrustLineFlagsOp.encode(stream, encodedOperationBody.setTrustLineFlagsOp);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    LiquidityPoolDepositOp.encode(stream, encodedOperationBody.liquidityPoolDepositOp);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    LiquidityPoolWithdrawOp.encode(stream, encodedOperationBody.liquidityPoolWithdrawOp);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OperationBody.encode(stream, this);
        }

        public static OperationBody decode(XdrDataInputStream stream) throws IOException {
            OperationBody decodedOperationBody = new OperationBody();
            OperationType discriminant = OperationType.decode(stream);
            decodedOperationBody.setDiscriminant(discriminant);
            switch (decodedOperationBody.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    decodedOperationBody.createAccountOp = CreateAccountOp.decode(stream);
                    break;
                }
                case PAYMENT: {
                    decodedOperationBody.paymentOp = PaymentOp.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    decodedOperationBody.pathPaymentStrictReceiveOp = PathPaymentStrictReceiveOp.decode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    decodedOperationBody.manageSellOfferOp = ManageSellOfferOp.decode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    decodedOperationBody.createPassiveSellOfferOp = CreatePassiveSellOfferOp.decode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    decodedOperationBody.setOptionsOp = SetOptionsOp.decode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    decodedOperationBody.changeTrustOp = ChangeTrustOp.decode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    decodedOperationBody.allowTrustOp = AllowTrustOp.decode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    decodedOperationBody.destination = MuxedAccount.decode(stream);
                    break;
                }
                case INFLATION: {
                    break;
                }
                case MANAGE_DATA: {
                    decodedOperationBody.manageDataOp = ManageDataOp.decode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    decodedOperationBody.bumpSequenceOp = BumpSequenceOp.decode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    decodedOperationBody.manageBuyOfferOp = ManageBuyOfferOp.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    decodedOperationBody.pathPaymentStrictSendOp = PathPaymentStrictSendOp.decode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    decodedOperationBody.createClaimableBalanceOp = CreateClaimableBalanceOp.decode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    decodedOperationBody.claimClaimableBalanceOp = ClaimClaimableBalanceOp.decode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationBody.beginSponsoringFutureReservesOp = BeginSponsoringFutureReservesOp.decode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    decodedOperationBody.revokeSponsorshipOp = RevokeSponsorshipOp.decode(stream);
                    break;
                }
                case CLAWBACK: {
                    decodedOperationBody.clawbackOp = ClawbackOp.decode(stream);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    decodedOperationBody.clawbackClaimableBalanceOp = ClawbackClaimableBalanceOp.decode(stream);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    decodedOperationBody.setTrustLineFlagsOp = SetTrustLineFlagsOp.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    decodedOperationBody.liquidityPoolDepositOp = LiquidityPoolDepositOp.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    decodedOperationBody.liquidityPoolWithdrawOp = LiquidityPoolWithdrawOp.decode(stream);
                }
            }
            return decodedOperationBody;
        }

        public int hashCode() {
            return Objects.hashCode(this.createAccountOp, this.paymentOp, this.pathPaymentStrictReceiveOp, this.manageSellOfferOp, this.createPassiveSellOfferOp, this.setOptionsOp, this.changeTrustOp, this.allowTrustOp, this.destination, this.manageDataOp, this.bumpSequenceOp, this.manageBuyOfferOp, this.pathPaymentStrictSendOp, this.createClaimableBalanceOp, this.claimClaimableBalanceOp, this.beginSponsoringFutureReservesOp, this.revokeSponsorshipOp, this.clawbackOp, this.clawbackClaimableBalanceOp, this.setTrustLineFlagsOp, this.liquidityPoolDepositOp, this.liquidityPoolWithdrawOp, this.type);
        }

        public boolean equals(Object object) {
            if (!(object instanceof OperationBody)) {
                return false;
            }
            OperationBody other = (OperationBody)object;
            return Objects.equal(this.createAccountOp, other.createAccountOp) && Objects.equal(this.paymentOp, other.paymentOp) && Objects.equal(this.pathPaymentStrictReceiveOp, other.pathPaymentStrictReceiveOp) && Objects.equal(this.manageSellOfferOp, other.manageSellOfferOp) && Objects.equal(this.createPassiveSellOfferOp, other.createPassiveSellOfferOp) && Objects.equal(this.setOptionsOp, other.setOptionsOp) && Objects.equal(this.changeTrustOp, other.changeTrustOp) && Objects.equal(this.allowTrustOp, other.allowTrustOp) && Objects.equal(this.destination, other.destination) && Objects.equal(this.manageDataOp, other.manageDataOp) && Objects.equal(this.bumpSequenceOp, other.bumpSequenceOp) && Objects.equal(this.manageBuyOfferOp, other.manageBuyOfferOp) && Objects.equal(this.pathPaymentStrictSendOp, other.pathPaymentStrictSendOp) && Objects.equal(this.createClaimableBalanceOp, other.createClaimableBalanceOp) && Objects.equal(this.claimClaimableBalanceOp, other.claimClaimableBalanceOp) && Objects.equal(this.beginSponsoringFutureReservesOp, other.beginSponsoringFutureReservesOp) && Objects.equal(this.revokeSponsorshipOp, other.revokeSponsorshipOp) && Objects.equal(this.clawbackOp, other.clawbackOp) && Objects.equal(this.clawbackClaimableBalanceOp, other.clawbackClaimableBalanceOp) && Objects.equal(this.setTrustLineFlagsOp, other.setTrustLineFlagsOp) && Objects.equal(this.liquidityPoolDepositOp, other.liquidityPoolDepositOp) && Objects.equal(this.liquidityPoolWithdrawOp, other.liquidityPoolWithdrawOp) && Objects.equal(this.type, other.type);
        }

        public static final class Builder {
            private OperationType discriminant;
            private CreateAccountOp createAccountOp;
            private PaymentOp paymentOp;
            private PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
            private ManageSellOfferOp manageSellOfferOp;
            private CreatePassiveSellOfferOp createPassiveSellOfferOp;
            private SetOptionsOp setOptionsOp;
            private ChangeTrustOp changeTrustOp;
            private AllowTrustOp allowTrustOp;
            private MuxedAccount destination;
            private ManageDataOp manageDataOp;
            private BumpSequenceOp bumpSequenceOp;
            private ManageBuyOfferOp manageBuyOfferOp;
            private PathPaymentStrictSendOp pathPaymentStrictSendOp;
            private CreateClaimableBalanceOp createClaimableBalanceOp;
            private ClaimClaimableBalanceOp claimClaimableBalanceOp;
            private BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
            private RevokeSponsorshipOp revokeSponsorshipOp;
            private ClawbackOp clawbackOp;
            private ClawbackClaimableBalanceOp clawbackClaimableBalanceOp;
            private SetTrustLineFlagsOp setTrustLineFlagsOp;
            private LiquidityPoolDepositOp liquidityPoolDepositOp;
            private LiquidityPoolWithdrawOp liquidityPoolWithdrawOp;

            public Builder discriminant(OperationType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder createAccountOp(CreateAccountOp createAccountOp) {
                this.createAccountOp = createAccountOp;
                return this;
            }

            public Builder paymentOp(PaymentOp paymentOp) {
                this.paymentOp = paymentOp;
                return this;
            }

            public Builder pathPaymentStrictReceiveOp(PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp) {
                this.pathPaymentStrictReceiveOp = pathPaymentStrictReceiveOp;
                return this;
            }

            public Builder manageSellOfferOp(ManageSellOfferOp manageSellOfferOp) {
                this.manageSellOfferOp = manageSellOfferOp;
                return this;
            }

            public Builder createPassiveSellOfferOp(CreatePassiveSellOfferOp createPassiveSellOfferOp) {
                this.createPassiveSellOfferOp = createPassiveSellOfferOp;
                return this;
            }

            public Builder setOptionsOp(SetOptionsOp setOptionsOp) {
                this.setOptionsOp = setOptionsOp;
                return this;
            }

            public Builder changeTrustOp(ChangeTrustOp changeTrustOp) {
                this.changeTrustOp = changeTrustOp;
                return this;
            }

            public Builder allowTrustOp(AllowTrustOp allowTrustOp) {
                this.allowTrustOp = allowTrustOp;
                return this;
            }

            public Builder destination(MuxedAccount destination) {
                this.destination = destination;
                return this;
            }

            public Builder manageDataOp(ManageDataOp manageDataOp) {
                this.manageDataOp = manageDataOp;
                return this;
            }

            public Builder bumpSequenceOp(BumpSequenceOp bumpSequenceOp) {
                this.bumpSequenceOp = bumpSequenceOp;
                return this;
            }

            public Builder manageBuyOfferOp(ManageBuyOfferOp manageBuyOfferOp) {
                this.manageBuyOfferOp = manageBuyOfferOp;
                return this;
            }

            public Builder pathPaymentStrictSendOp(PathPaymentStrictSendOp pathPaymentStrictSendOp) {
                this.pathPaymentStrictSendOp = pathPaymentStrictSendOp;
                return this;
            }

            public Builder createClaimableBalanceOp(CreateClaimableBalanceOp createClaimableBalanceOp) {
                this.createClaimableBalanceOp = createClaimableBalanceOp;
                return this;
            }

            public Builder claimClaimableBalanceOp(ClaimClaimableBalanceOp claimClaimableBalanceOp) {
                this.claimClaimableBalanceOp = claimClaimableBalanceOp;
                return this;
            }

            public Builder beginSponsoringFutureReservesOp(BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp) {
                this.beginSponsoringFutureReservesOp = beginSponsoringFutureReservesOp;
                return this;
            }

            public Builder revokeSponsorshipOp(RevokeSponsorshipOp revokeSponsorshipOp) {
                this.revokeSponsorshipOp = revokeSponsorshipOp;
                return this;
            }

            public Builder clawbackOp(ClawbackOp clawbackOp) {
                this.clawbackOp = clawbackOp;
                return this;
            }

            public Builder clawbackClaimableBalanceOp(ClawbackClaimableBalanceOp clawbackClaimableBalanceOp) {
                this.clawbackClaimableBalanceOp = clawbackClaimableBalanceOp;
                return this;
            }

            public Builder setTrustLineFlagsOp(SetTrustLineFlagsOp setTrustLineFlagsOp) {
                this.setTrustLineFlagsOp = setTrustLineFlagsOp;
                return this;
            }

            public Builder liquidityPoolDepositOp(LiquidityPoolDepositOp liquidityPoolDepositOp) {
                this.liquidityPoolDepositOp = liquidityPoolDepositOp;
                return this;
            }

            public Builder liquidityPoolWithdrawOp(LiquidityPoolWithdrawOp liquidityPoolWithdrawOp) {
                this.liquidityPoolWithdrawOp = liquidityPoolWithdrawOp;
                return this;
            }

            public OperationBody build() {
                OperationBody val = new OperationBody();
                val.setDiscriminant(this.discriminant);
                val.setCreateAccountOp(this.createAccountOp);
                val.setPaymentOp(this.paymentOp);
                val.setPathPaymentStrictReceiveOp(this.pathPaymentStrictReceiveOp);
                val.setManageSellOfferOp(this.manageSellOfferOp);
                val.setCreatePassiveSellOfferOp(this.createPassiveSellOfferOp);
                val.setSetOptionsOp(this.setOptionsOp);
                val.setChangeTrustOp(this.changeTrustOp);
                val.setAllowTrustOp(this.allowTrustOp);
                val.setDestination(this.destination);
                val.setManageDataOp(this.manageDataOp);
                val.setBumpSequenceOp(this.bumpSequenceOp);
                val.setManageBuyOfferOp(this.manageBuyOfferOp);
                val.setPathPaymentStrictSendOp(this.pathPaymentStrictSendOp);
                val.setCreateClaimableBalanceOp(this.createClaimableBalanceOp);
                val.setClaimClaimableBalanceOp(this.claimClaimableBalanceOp);
                val.setBeginSponsoringFutureReservesOp(this.beginSponsoringFutureReservesOp);
                val.setRevokeSponsorshipOp(this.revokeSponsorshipOp);
                val.setClawbackOp(this.clawbackOp);
                val.setClawbackClaimableBalanceOp(this.clawbackClaimableBalanceOp);
                val.setSetTrustLineFlagsOp(this.setTrustLineFlagsOp);
                val.setLiquidityPoolDepositOp(this.liquidityPoolDepositOp);
                val.setLiquidityPoolWithdrawOp(this.liquidityPoolWithdrawOp);
                return val;
            }
        }
    }

    public static final class Builder {
        private MuxedAccount sourceAccount;
        private OperationBody body;

        public Builder sourceAccount(MuxedAccount sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public Builder body(OperationBody body) {
            this.body = body;
            return this;
        }

        public Operation build() {
            Operation val = new Operation();
            val.setSourceAccount(this.sourceAccount);
            val.setBody(this.body);
            return val;
        }
    }
}

