/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Price;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class ManageBuyOfferOp
implements XdrElement {
    private Asset selling;
    private Asset buying;
    private Int64 buyAmount;
    private Price price;
    private Int64 offerID;

    public Asset getSelling() {
        return this.selling;
    }

    public void setSelling(Asset value) {
        this.selling = value;
    }

    public Asset getBuying() {
        return this.buying;
    }

    public void setBuying(Asset value) {
        this.buying = value;
    }

    public Int64 getBuyAmount() {
        return this.buyAmount;
    }

    public void setBuyAmount(Int64 value) {
        this.buyAmount = value;
    }

    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price value) {
        this.price = value;
    }

    public Int64 getOfferID() {
        return this.offerID;
    }

    public void setOfferID(Int64 value) {
        this.offerID = value;
    }

    public static void encode(XdrDataOutputStream stream, ManageBuyOfferOp encodedManageBuyOfferOp) throws IOException {
        Asset.encode(stream, encodedManageBuyOfferOp.selling);
        Asset.encode(stream, encodedManageBuyOfferOp.buying);
        Int64.encode(stream, encodedManageBuyOfferOp.buyAmount);
        Price.encode(stream, encodedManageBuyOfferOp.price);
        Int64.encode(stream, encodedManageBuyOfferOp.offerID);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ManageBuyOfferOp.encode(stream, this);
    }

    public static ManageBuyOfferOp decode(XdrDataInputStream stream) throws IOException {
        ManageBuyOfferOp decodedManageBuyOfferOp = new ManageBuyOfferOp();
        decodedManageBuyOfferOp.selling = Asset.decode(stream);
        decodedManageBuyOfferOp.buying = Asset.decode(stream);
        decodedManageBuyOfferOp.buyAmount = Int64.decode(stream);
        decodedManageBuyOfferOp.price = Price.decode(stream);
        decodedManageBuyOfferOp.offerID = Int64.decode(stream);
        return decodedManageBuyOfferOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.selling, this.buying, this.buyAmount, this.price, this.offerID);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManageBuyOfferOp)) {
            return false;
        }
        ManageBuyOfferOp other = (ManageBuyOfferOp)object;
        return Objects.equal(this.selling, other.selling) && Objects.equal(this.buying, other.buying) && Objects.equal(this.buyAmount, other.buyAmount) && Objects.equal(this.price, other.price) && Objects.equal(this.offerID, other.offerID);
    }

    public static final class Builder {
        private Asset selling;
        private Asset buying;
        private Int64 buyAmount;
        private Price price;
        private Int64 offerID;

        public Builder selling(Asset selling) {
            this.selling = selling;
            return this;
        }

        public Builder buying(Asset buying) {
            this.buying = buying;
            return this;
        }

        public Builder buyAmount(Int64 buyAmount) {
            this.buyAmount = buyAmount;
            return this;
        }

        public Builder price(Price price) {
            this.price = price;
            return this;
        }

        public Builder offerID(Int64 offerID) {
            this.offerID = offerID;
            return this;
        }

        public ManageBuyOfferOp build() {
            ManageBuyOfferOp val = new ManageBuyOfferOp();
            val.setSelling(this.selling);
            val.setBuying(this.buying);
            val.setBuyAmount(this.buyAmount);
            val.setPrice(this.price);
            val.setOfferID(this.offerID);
            return val;
        }
    }
}

