/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LiquidityPoolWithdrawResultCode implements XdrElement
{
    LIQUIDITY_POOL_WITHDRAW_SUCCESS(0),
    LIQUIDITY_POOL_WITHDRAW_MALFORMED(-1),
    LIQUIDITY_POOL_WITHDRAW_NO_TRUST(-2),
    LIQUIDITY_POOL_WITHDRAW_UNDERFUNDED(-3),
    LIQUIDITY_POOL_WITHDRAW_LINE_FULL(-4),
    LIQUIDITY_POOL_WITHDRAW_UNDER_MINIMUM(-5);

    private int mValue;

    private LiquidityPoolWithdrawResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static LiquidityPoolWithdrawResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return LIQUIDITY_POOL_WITHDRAW_SUCCESS;
            }
            case -1: {
                return LIQUIDITY_POOL_WITHDRAW_MALFORMED;
            }
            case -2: {
                return LIQUIDITY_POOL_WITHDRAW_NO_TRUST;
            }
            case -3: {
                return LIQUIDITY_POOL_WITHDRAW_UNDERFUNDED;
            }
            case -4: {
                return LIQUIDITY_POOL_WITHDRAW_LINE_FULL;
            }
            case -5: {
                return LIQUIDITY_POOL_WITHDRAW_UNDER_MINIMUM;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, LiquidityPoolWithdrawResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LiquidityPoolWithdrawResultCode.encode(stream, this);
    }
}

