/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LiquidityPoolParameters
implements XdrElement {
    LiquidityPoolType type;
    private LiquidityPoolConstantProductParameters constantProduct;

    public LiquidityPoolType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(LiquidityPoolType value) {
        this.type = value;
    }

    public LiquidityPoolConstantProductParameters getConstantProduct() {
        return this.constantProduct;
    }

    public void setConstantProduct(LiquidityPoolConstantProductParameters value) {
        this.constantProduct = value;
    }

    public static void encode(XdrDataOutputStream stream, LiquidityPoolParameters encodedLiquidityPoolParameters) throws IOException {
        stream.writeInt(encodedLiquidityPoolParameters.getDiscriminant().getValue());
        switch (encodedLiquidityPoolParameters.getDiscriminant()) {
            case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                LiquidityPoolConstantProductParameters.encode(stream, encodedLiquidityPoolParameters.constantProduct);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LiquidityPoolParameters.encode(stream, this);
    }

    public static LiquidityPoolParameters decode(XdrDataInputStream stream) throws IOException {
        LiquidityPoolParameters decodedLiquidityPoolParameters = new LiquidityPoolParameters();
        LiquidityPoolType discriminant = LiquidityPoolType.decode(stream);
        decodedLiquidityPoolParameters.setDiscriminant(discriminant);
        switch (decodedLiquidityPoolParameters.getDiscriminant()) {
            case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                decodedLiquidityPoolParameters.constantProduct = LiquidityPoolConstantProductParameters.decode(stream);
            }
        }
        return decodedLiquidityPoolParameters;
    }

    public int hashCode() {
        return Objects.hashCode(this.constantProduct, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LiquidityPoolParameters)) {
            return false;
        }
        LiquidityPoolParameters other = (LiquidityPoolParameters)object;
        return Objects.equal(this.constantProduct, other.constantProduct) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private LiquidityPoolType discriminant;
        private LiquidityPoolConstantProductParameters constantProduct;

        public Builder discriminant(LiquidityPoolType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder constantProduct(LiquidityPoolConstantProductParameters constantProduct) {
            this.constantProduct = constantProduct;
            return this;
        }

        public LiquidityPoolParameters build() {
            LiquidityPoolParameters val = new LiquidityPoolParameters();
            val.setDiscriminant(this.discriminant);
            val.setConstantProduct(this.constantProduct);
            return val;
        }
    }
}

