/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class Liabilities
implements XdrElement {
    private Int64 buying;
    private Int64 selling;

    public Int64 getBuying() {
        return this.buying;
    }

    public void setBuying(Int64 value) {
        this.buying = value;
    }

    public Int64 getSelling() {
        return this.selling;
    }

    public void setSelling(Int64 value) {
        this.selling = value;
    }

    public static void encode(XdrDataOutputStream stream, Liabilities encodedLiabilities) throws IOException {
        Int64.encode(stream, encodedLiabilities.buying);
        Int64.encode(stream, encodedLiabilities.selling);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Liabilities.encode(stream, this);
    }

    public static Liabilities decode(XdrDataInputStream stream) throws IOException {
        Liabilities decodedLiabilities = new Liabilities();
        decodedLiabilities.buying = Int64.decode(stream);
        decodedLiabilities.selling = Int64.decode(stream);
        return decodedLiabilities;
    }

    public int hashCode() {
        return Objects.hashCode(this.buying, this.selling);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Liabilities)) {
            return false;
        }
        Liabilities other = (Liabilities)object;
        return Objects.equal(this.buying, other.buying) && Objects.equal(this.selling, other.selling);
    }

    public static final class Builder {
        private Int64 buying;
        private Int64 selling;

        public Builder buying(Int64 buying) {
            this.buying = buying;
            return this;
        }

        public Builder selling(Int64 selling) {
            this.selling = selling;
            return this;
        }

        public Liabilities build() {
            Liabilities val = new Liabilities();
            val.setBuying(this.buying);
            val.setSelling(this.selling);
            return val;
        }
    }
}

