/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerUpgradeType implements XdrElement
{
    LEDGER_UPGRADE_VERSION(1),
    LEDGER_UPGRADE_BASE_FEE(2),
    LEDGER_UPGRADE_MAX_TX_SET_SIZE(3),
    LEDGER_UPGRADE_BASE_RESERVE(4),
    LEDGER_UPGRADE_FLAGS(5);

    private int mValue;

    private LedgerUpgradeType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static LedgerUpgradeType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return LEDGER_UPGRADE_VERSION;
            }
            case 2: {
                return LEDGER_UPGRADE_BASE_FEE;
            }
            case 3: {
                return LEDGER_UPGRADE_MAX_TX_SET_SIZE;
            }
            case 4: {
                return LEDGER_UPGRADE_BASE_RESERVE;
            }
            case 5: {
                return LEDGER_UPGRADE_FLAGS;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, LedgerUpgradeType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerUpgradeType.encode(stream, this);
    }
}

