/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerEntryType implements XdrElement
{
    ACCOUNT(0),
    TRUSTLINE(1),
    OFFER(2),
    DATA(3),
    CLAIMABLE_BALANCE(4),
    LIQUIDITY_POOL(5);

    private int mValue;

    private LedgerEntryType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static LedgerEntryType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ACCOUNT;
            }
            case 1: {
                return TRUSTLINE;
            }
            case 2: {
                return OFFER;
            }
            case 3: {
                return DATA;
            }
            case 4: {
                return CLAIMABLE_BALANCE;
            }
            case 5: {
                return LIQUIDITY_POOL;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, LedgerEntryType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerEntryType.encode(stream, this);
    }
}

