/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerEntryChangeType implements XdrElement
{
    LEDGER_ENTRY_CREATED(0),
    LEDGER_ENTRY_UPDATED(1),
    LEDGER_ENTRY_REMOVED(2),
    LEDGER_ENTRY_STATE(3);

    private int mValue;

    private LedgerEntryChangeType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static LedgerEntryChangeType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return LEDGER_ENTRY_CREATED;
            }
            case 1: {
                return LEDGER_ENTRY_UPDATED;
            }
            case 2: {
                return LEDGER_ENTRY_REMOVED;
            }
            case 3: {
                return LEDGER_ENTRY_STATE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, LedgerEntryChangeType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerEntryChangeType.encode(stream, this);
    }
}

