/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Curve25519Secret
implements XdrElement {
    private byte[] key;

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] value) {
        this.key = value;
    }

    public static void encode(XdrDataOutputStream stream, Curve25519Secret encodedCurve25519Secret) throws IOException {
        int keysize = encodedCurve25519Secret.key.length;
        stream.write(encodedCurve25519Secret.getKey(), 0, keysize);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Curve25519Secret.encode(stream, this);
    }

    public static Curve25519Secret decode(XdrDataInputStream stream) throws IOException {
        Curve25519Secret decodedCurve25519Secret = new Curve25519Secret();
        int keysize = 32;
        decodedCurve25519Secret.key = new byte[keysize];
        stream.read(decodedCurve25519Secret.key, 0, keysize);
        return decodedCurve25519Secret;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Curve25519Secret)) {
            return false;
        }
        Curve25519Secret other = (Curve25519Secret)object;
        return Arrays.equals(this.key, other.key);
    }

    public static final class Builder {
        private byte[] key;

        public Builder key(byte[] key) {
            this.key = key;
            return this;
        }

        public Curve25519Secret build() {
            Curve25519Secret val = new Curve25519Secret();
            val.setKey(this.key);
            return val;
        }
    }
}

