/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class ClawbackOp
implements XdrElement {
    private Asset asset;
    private MuxedAccount from;
    private Int64 amount;

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public MuxedAccount getFrom() {
        return this.from;
    }

    public void setFrom(MuxedAccount value) {
        this.from = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public static void encode(XdrDataOutputStream stream, ClawbackOp encodedClawbackOp) throws IOException {
        Asset.encode(stream, encodedClawbackOp.asset);
        MuxedAccount.encode(stream, encodedClawbackOp.from);
        Int64.encode(stream, encodedClawbackOp.amount);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClawbackOp.encode(stream, this);
    }

    public static ClawbackOp decode(XdrDataInputStream stream) throws IOException {
        ClawbackOp decodedClawbackOp = new ClawbackOp();
        decodedClawbackOp.asset = Asset.decode(stream);
        decodedClawbackOp.from = MuxedAccount.decode(stream);
        decodedClawbackOp.amount = Int64.decode(stream);
        return decodedClawbackOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.asset, this.from, this.amount);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClawbackOp)) {
            return false;
        }
        ClawbackOp other = (ClawbackOp)object;
        return Objects.equal(this.asset, other.asset) && Objects.equal(this.from, other.from) && Objects.equal(this.amount, other.amount);
    }

    public static final class Builder {
        private Asset asset;
        private MuxedAccount from;
        private Int64 amount;

        public Builder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        public Builder from(MuxedAccount from) {
            this.from = from;
            return this;
        }

        public Builder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        public ClawbackOp build() {
            ClawbackOp val = new ClawbackOp();
            val.setAsset(this.asset);
            val.setFrom(this.from);
            val.setAmount(this.amount);
            return val;
        }
    }
}

