/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class AssetCode
implements XdrElement {
    AssetType type;
    private AssetCode4 assetCode4;
    private AssetCode12 assetCode12;

    public AssetType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(AssetType value) {
        this.type = value;
    }

    public AssetCode4 getAssetCode4() {
        return this.assetCode4;
    }

    public void setAssetCode4(AssetCode4 value) {
        this.assetCode4 = value;
    }

    public AssetCode12 getAssetCode12() {
        return this.assetCode12;
    }

    public void setAssetCode12(AssetCode12 value) {
        this.assetCode12 = value;
    }

    public static void encode(XdrDataOutputStream stream, AssetCode encodedAssetCode) throws IOException {
        stream.writeInt(encodedAssetCode.getDiscriminant().getValue());
        switch (encodedAssetCode.getDiscriminant()) {
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                AssetCode4.encode(stream, encodedAssetCode.assetCode4);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                AssetCode12.encode(stream, encodedAssetCode.assetCode12);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AssetCode.encode(stream, this);
    }

    public static AssetCode decode(XdrDataInputStream stream) throws IOException {
        AssetCode decodedAssetCode = new AssetCode();
        AssetType discriminant = AssetType.decode(stream);
        decodedAssetCode.setDiscriminant(discriminant);
        switch (decodedAssetCode.getDiscriminant()) {
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                decodedAssetCode.assetCode4 = AssetCode4.decode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                decodedAssetCode.assetCode12 = AssetCode12.decode(stream);
            }
        }
        return decodedAssetCode;
    }

    public int hashCode() {
        return Objects.hashCode(this.assetCode4, this.assetCode12, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AssetCode)) {
            return false;
        }
        AssetCode other = (AssetCode)object;
        return Objects.equal(this.assetCode4, other.assetCode4) && Objects.equal(this.assetCode12, other.assetCode12) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private AssetType discriminant;
        private AssetCode4 assetCode4;
        private AssetCode12 assetCode12;

        public Builder discriminant(AssetType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder assetCode4(AssetCode4 assetCode4) {
            this.assetCode4 = assetCode4;
            return this;
        }

        public Builder assetCode12(AssetCode12 assetCode12) {
            this.assetCode12 = assetCode12;
            return this;
        }

        public AssetCode build() {
            AssetCode val = new AssetCode();
            val.setDiscriminant(this.discriminant);
            val.setAssetCode4(this.assetCode4);
            val.setAssetCode12(this.assetCode12);
            return val;
        }
    }
}

