/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountMergeResultCode;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class AccountMergeResult
implements XdrElement {
    AccountMergeResultCode code;
    private Int64 sourceAccountBalance;

    public AccountMergeResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(AccountMergeResultCode value) {
        this.code = value;
    }

    public Int64 getSourceAccountBalance() {
        return this.sourceAccountBalance;
    }

    public void setSourceAccountBalance(Int64 value) {
        this.sourceAccountBalance = value;
    }

    public static void encode(XdrDataOutputStream stream, AccountMergeResult encodedAccountMergeResult) throws IOException {
        stream.writeInt(encodedAccountMergeResult.getDiscriminant().getValue());
        switch (encodedAccountMergeResult.getDiscriminant()) {
            case ACCOUNT_MERGE_SUCCESS: {
                Int64.encode(stream, encodedAccountMergeResult.sourceAccountBalance);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountMergeResult.encode(stream, this);
    }

    public static AccountMergeResult decode(XdrDataInputStream stream) throws IOException {
        AccountMergeResult decodedAccountMergeResult = new AccountMergeResult();
        AccountMergeResultCode discriminant = AccountMergeResultCode.decode(stream);
        decodedAccountMergeResult.setDiscriminant(discriminant);
        switch (decodedAccountMergeResult.getDiscriminant()) {
            case ACCOUNT_MERGE_SUCCESS: {
                decodedAccountMergeResult.sourceAccountBalance = Int64.decode(stream);
                break;
            }
        }
        return decodedAccountMergeResult;
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceAccountBalance, this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountMergeResult)) {
            return false;
        }
        AccountMergeResult other = (AccountMergeResult)object;
        return Objects.equal(this.sourceAccountBalance, other.sourceAccountBalance) && Objects.equal(this.code, other.code);
    }

    public static final class Builder {
        private AccountMergeResultCode discriminant;
        private Int64 sourceAccountBalance;

        public Builder discriminant(AccountMergeResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder sourceAccountBalance(Int64 sourceAccountBalance) {
            this.sourceAccountBalance = sourceAccountBalance;
            return this;
        }

        public AccountMergeResult build() {
            AccountMergeResult val = new AccountMergeResult();
            val.setDiscriminant(this.discriminant);
            val.setSourceAccountBalance(this.sourceAccountBalance);
            return val;
        }
    }
}

