/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.gson.annotations.SerializedName;

public class PaymentOperationResponse
extends OperationResponse {
    @SerializedName(value="amount")
    protected final String amount;
    @SerializedName(value="asset_type")
    protected final String assetType;
    @SerializedName(value="asset_code")
    protected final String assetCode;
    @SerializedName(value="asset_issuer")
    protected final String assetIssuer;
    @SerializedName(value="from")
    protected final String from;
    @SerializedName(value="to")
    protected final String to;

    PaymentOperationResponse(String amount, String assetType, String assetCode, String assetIssuer, String from, String to) {
        this.amount = amount;
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.from = from;
        this.to = to;
    }

    public String getAmount() {
        return this.amount;
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }
}

