/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.effects;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.effects.EffectResponse;
import shadow.com.google.common.base.Optional;
import shadow.com.google.gson.annotations.SerializedName;

public class TradeEffectResponse
extends EffectResponse {
    @SerializedName(value="seller")
    private String seller;
    @SerializedName(value="seller_muxed")
    private String sellerMuxed;
    @SerializedName(value="seller_muxed_id")
    private Long sellerMuxedId;
    @SerializedName(value="offer_id")
    private Long offerId;
    @SerializedName(value="sold_amount")
    private String soldAmount;
    @SerializedName(value="sold_asset_type")
    private String soldAssetType;
    @SerializedName(value="sold_asset_code")
    private String soldAssetCode;
    @SerializedName(value="sold_asset_issuer")
    private String soldAssetIssuer;
    @SerializedName(value="bought_amount")
    private String boughtAmount;
    @SerializedName(value="bought_asset_type")
    private String boughtAssetType;
    @SerializedName(value="bought_asset_code")
    private String boughtAssetCode;
    @SerializedName(value="bought_asset_issuer")
    private String boughtAssetIssuer;

    public Optional<MuxedAccount> getSellerMuxed() {
        if (this.sellerMuxed == null || this.sellerMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.sellerMuxed, this.seller, this.sellerMuxedId));
    }

    public String getSeller() {
        return this.seller;
    }

    public Long getOfferId() {
        return this.offerId;
    }

    public String getSoldAmount() {
        return this.soldAmount;
    }

    public String getBoughtAmount() {
        return this.boughtAmount;
    }

    public Asset getSoldAsset() {
        if (this.soldAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.soldAssetCode, this.soldAssetIssuer);
    }

    public Asset getBoughtAsset() {
        if (this.boughtAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.boughtAssetCode, this.boughtAssetIssuer);
    }
}

