/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.util.ArrayList;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;
import shadow.com.google.gson.annotations.SerializedName;

public class PathResponse
extends Response {
    @SerializedName(value="destination_amount")
    private final String destinationAmount;
    @SerializedName(value="destination_asset_type")
    private final String destinationAssetType;
    @SerializedName(value="destination_asset_code")
    private final String destinationAssetCode;
    @SerializedName(value="destination_asset_issuer")
    private final String destinationAssetIssuer;
    @SerializedName(value="source_amount")
    private final String sourceAmount;
    @SerializedName(value="source_asset_type")
    private final String sourceAssetType;
    @SerializedName(value="source_asset_code")
    private final String sourceAssetCode;
    @SerializedName(value="source_asset_issuer")
    private final String sourceAssetIssuer;
    @SerializedName(value="path")
    private final ArrayList<Asset> path;
    @SerializedName(value="_links")
    private final Links links;

    PathResponse(String destinationAmount, String destinationAssetType, String destinationAssetCode, String destinationAssetIssuer, String sourceAmount, String sourceAssetType, String sourceAssetCode, String sourceAssetIssuer, ArrayList<Asset> path, Links links) {
        this.destinationAmount = destinationAmount;
        this.destinationAssetType = destinationAssetType;
        this.destinationAssetCode = destinationAssetCode;
        this.destinationAssetIssuer = destinationAssetIssuer;
        this.sourceAmount = sourceAmount;
        this.sourceAssetType = sourceAssetType;
        this.sourceAssetCode = sourceAssetCode;
        this.sourceAssetIssuer = sourceAssetIssuer;
        this.path = path;
        this.links = links;
    }

    public String getDestinationAmount() {
        return this.destinationAmount;
    }

    public String getSourceAmount() {
        return this.sourceAmount;
    }

    public ArrayList<Asset> getPath() {
        return this.path;
    }

    public Asset getDestinationAsset() {
        if (this.destinationAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.destinationAssetCode, this.destinationAssetIssuer);
    }

    public Asset getSourceAsset() {
        if (this.sourceAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.sourceAssetCode, this.sourceAssetIssuer);
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="self")
        private final Link self;

        Links(Link self) {
            this.self = self;
        }

        public Link getSelf() {
            return this.self;
        }
    }
}

