/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.responses.TypedResponse;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.annotations.SerializedName;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;

public class Page<T>
extends Response
implements TypedResponse<Page<T>> {
    @SerializedName(value="records")
    private ArrayList<T> records;
    @SerializedName(value="links")
    private Links links;
    private TypeToken<Page<T>> type;

    Page() {
    }

    public ArrayList<T> getRecords() {
        return this.records;
    }

    public Links getLinks() {
        return this.links;
    }

    public Page<T> getNextPage(OkHttpClient httpClient) throws URISyntaxException, IOException {
        if (this.getLinks().getNext() == null) {
            return null;
        }
        TypeToken<Page<T>> type = Preconditions.checkNotNull(this.type, "type cannot be null, is it being correctly set after the creation of this " + this.getClass().getSimpleName() + "?");
        ResponseHandler<Page<T>> responseHandler = new ResponseHandler<Page<T>>(type);
        String url = this.getLinks().getNext().getHref();
        Request request = new Request.Builder().get().url(url).build();
        shadow.okhttp3.Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    @Override
    public void setType(TypeToken<Page<T>> type) {
        this.type = type;
    }

    public static class Links {
        @SerializedName(value="next")
        private final Link next;
        @SerializedName(value="prev")
        private final Link prev;
        @SerializedName(value="self")
        private final Link self;

        Links(Link next, Link prev, Link self) {
            this.next = next;
            this.prev = prev;
            this.self = self;
        }

        public Link getNext() {
            return this.next;
        }

        public Link getPrev() {
            return this.prev;
        }

        public Link getSelf() {
            return this.self;
        }
    }
}

