/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.lang.reflect.Type;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import shadow.com.google.gson.JsonDeserializationContext;
import shadow.com.google.gson.JsonDeserializer;
import shadow.com.google.gson.JsonElement;
import shadow.com.google.gson.JsonParseException;

class AssetDeserializer
implements JsonDeserializer<Asset> {
    AssetDeserializer() {
    }

    @Override
    public Asset deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return Asset.create(json.getAsString());
        }
        String type = json.getAsJsonObject().get("asset_type").getAsString();
        if (type.equals("native")) {
            return new AssetTypeNative();
        }
        String code = json.getAsJsonObject().get("asset_code").getAsString();
        String issuer = json.getAsJsonObject().get("asset_issuer").getAsString();
        return Asset.createNonNativeAsset(code, issuer);
    }
}

