/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.TradeResponse;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class TradesRequestBuilder
extends RequestBuilder {
    private static final String TRADE_TYPE_PARAMETER_NAME = "trade_type";

    public TradesRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "trades");
    }

    public TradesRequestBuilder baseAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("base_asset_type", asset.getType());
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("base_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("base_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public TradesRequestBuilder counterAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("counter_asset_type", asset.getType());
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("counter_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("counter_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public TradesRequestBuilder forAccount(String account) {
        account = Preconditions.checkNotNull(account, "account cannot be null");
        this.setSegments("accounts", account, "trades");
        return this;
    }

    public TradesRequestBuilder forLiquidityPool(LiquidityPoolID liquidityPoolID) {
        return this.forLiquidityPool(String.valueOf(liquidityPoolID));
    }

    public TradesRequestBuilder forLiquidityPool(String liquidityPoolID) {
        this.setSegments("liquidity_pools", String.valueOf(liquidityPoolID), "trades");
        return this;
    }

    public TradesRequestBuilder forTradeType(String tradeType) {
        tradeType = Preconditions.checkNotNull(tradeType, "tradeType cannot be null");
        this.uriBuilder.setQueryParameter(TRADE_TYPE_PARAMETER_NAME, tradeType);
        return this;
    }

    public static Page<TradeResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<TradeResponse>> type = new TypeToken<Page<TradeResponse>>(){};
        ResponseHandler<Page<TradeResponse>> responseHandler = new ResponseHandler<Page<TradeResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public Page<TradeResponse> execute() throws IOException, TooManyRequestsException {
        return TradesRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    public TradesRequestBuilder offerId(String offerId) {
        this.uriBuilder.setQueryParameter("offer_id", offerId);
        return this;
    }

    @Override
    public TradesRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public TradesRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    public SSEStream<TradeResponse> stream(EventListener<TradeResponse> listener) {
        return SSEStream.create(this.httpClient, this, TradeResponse.class, listener);
    }
}

