/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.AssetTypeNative;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.Lists;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;

public abstract class RequestBuilder {
    protected HttpUrl.Builder uriBuilder;
    protected OkHttpClient httpClient;
    private ArrayList<String> segments;
    private boolean segmentsAdded;

    RequestBuilder(OkHttpClient httpClient, HttpUrl serverURI, String defaultSegment) {
        this.httpClient = httpClient;
        this.uriBuilder = serverURI.newBuilder();
        this.segments = new ArrayList();
        if (defaultSegment != null) {
            this.setSegments(defaultSegment);
        }
        this.segmentsAdded = false;
    }

    protected RequestBuilder setSegments(String ... segments) {
        if (this.segmentsAdded) {
            throw new RuntimeException("URL segments have been already added.");
        }
        this.segmentsAdded = true;
        this.segments.clear();
        this.segments.addAll(Arrays.asList(segments));
        return this;
    }

    public RequestBuilder cursor(String cursor) {
        this.uriBuilder.setQueryParameter("cursor", cursor);
        return this;
    }

    public RequestBuilder limit(int number) {
        this.uriBuilder.setQueryParameter("limit", String.valueOf(number));
        return this;
    }

    public RequestBuilder order(Order direction) {
        this.uriBuilder.setQueryParameter("order", direction.getValue());
        return this;
    }

    public RequestBuilder setAssetsParameter(String name, List<Asset> assets) {
        ArrayList<String> assetStrings = Lists.newArrayList();
        for (Asset asset : assets) {
            assetStrings.add(this.encodeAsset(asset));
        }
        this.uriBuilder.setQueryParameter(name, Joiner.on(",").join(assetStrings));
        return this;
    }

    public RequestBuilder setAssetParameter(String name, Asset asset) {
        this.uriBuilder.setQueryParameter(name, this.encodeAsset(asset));
        return this;
    }

    private String encodeAsset(Asset asset) {
        if (asset instanceof AssetTypeNative) {
            return "native";
        }
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAsset = (AssetTypeCreditAlphaNum)asset;
            return creditAsset.getCode() + ":" + creditAsset.getIssuer();
        }
        throw new RuntimeException("unsupported asset " + asset.getType());
    }

    HttpUrl buildUri() {
        if (this.segments.size() > 0) {
            for (String segment : this.segments) {
                this.uriBuilder.addPathSegment(segment);
            }
        }
        return this.uriBuilder.build();
    }

    public static enum Order {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private Order(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

