/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import java.util.Set;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.Sets;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class OperationsRequestBuilder
extends RequestBuilder {
    protected Set<String> toJoin = Sets.newHashSet();

    public OperationsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "operations");
    }

    public OperationResponse operation(HttpUrl uri) throws IOException {
        TypeToken<OperationResponse> type = new TypeToken<OperationResponse>(){};
        ResponseHandler<OperationResponse> responseHandler = new ResponseHandler<OperationResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = this.httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public OperationResponse operation(long operationId) throws IOException {
        this.setSegments("operations", String.valueOf(operationId));
        return this.operation(this.buildUri());
    }

    public OperationsRequestBuilder forAccount(String account) {
        account = Preconditions.checkNotNull(account, "account cannot be null");
        this.setSegments("accounts", account, "operations");
        return this;
    }

    public OperationsRequestBuilder forClaimableBalance(String claimableBalance) {
        claimableBalance = Preconditions.checkNotNull(claimableBalance, "claimableBalance cannot be null");
        this.setSegments("claimable_balances", claimableBalance, "operations");
        return this;
    }

    public OperationsRequestBuilder forLedger(long ledgerSeq) {
        this.setSegments("ledgers", String.valueOf(ledgerSeq), "operations");
        return this;
    }

    public OperationsRequestBuilder forTransaction(String transactionId) {
        transactionId = Preconditions.checkNotNull(transactionId, "transactionId cannot be null");
        this.setSegments("transactions", transactionId, "operations");
        return this;
    }

    public OperationsRequestBuilder forLiquidityPool(LiquidityPoolID liquidityPoolID) {
        return this.forLiquidityPool(String.valueOf(liquidityPoolID));
    }

    public OperationsRequestBuilder forLiquidityPool(String liquidityPoolID) {
        this.setSegments("liquidity_pools", liquidityPoolID, "operations");
        return this;
    }

    public OperationsRequestBuilder includeFailed(boolean value) {
        this.uriBuilder.setQueryParameter("include_failed", String.valueOf(value));
        return this;
    }

    public OperationsRequestBuilder includeTransactions(boolean include) {
        this.updateToJoin("transactions", include);
        return this;
    }

    protected void updateToJoin(String value, boolean include) {
        if (include) {
            this.toJoin.add(value);
        } else {
            this.toJoin.remove(value);
        }
        if (this.toJoin.isEmpty()) {
            this.uriBuilder.removeAllQueryParameters("join");
        } else {
            this.uriBuilder.setQueryParameter("join", Joiner.on(",").join(this.toJoin));
        }
    }

    public static Page<OperationResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<OperationResponse>> type = new TypeToken<Page<OperationResponse>>(){};
        ResponseHandler<Page<OperationResponse>> responseHandler = new ResponseHandler<Page<OperationResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public SSEStream<OperationResponse> stream(EventListener<OperationResponse> listener) {
        return SSEStream.create(this.httpClient, this, OperationResponse.class, listener);
    }

    public Page<OperationResponse> execute() throws IOException, TooManyRequestsException {
        return OperationsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public OperationsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public OperationsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public OperationsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

