/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.LiquidityPoolResponse;
import org.stellar.sdk.responses.Page;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class LiquidityPoolsRequestBuilder
extends RequestBuilder {
    private static final String RESERVES_PARAMETER_NAME = "reserves";

    public LiquidityPoolsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "liquidity_pools");
    }

    public LiquidityPoolResponse liquidityPool(HttpUrl uri) throws IOException {
        TypeToken<LiquidityPoolResponse> type = new TypeToken<LiquidityPoolResponse>(){};
        ResponseHandler<LiquidityPoolResponse> responseHandler = new ResponseHandler<LiquidityPoolResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = this.httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public LiquidityPoolResponse liquidityPool(String liquidityPoolID) throws IOException {
        this.setSegments("liquidity_pools", liquidityPoolID);
        return this.liquidityPool(this.buildUri());
    }

    public LiquidityPoolResponse liquidityPool(LiquidityPoolID liquidityPoolID) throws IOException {
        return this.liquidityPool(liquidityPoolID.toString());
    }

    public LiquidityPoolsRequestBuilder forReserves(String ... reserves) {
        this.uriBuilder.setQueryParameter(RESERVES_PARAMETER_NAME, String.join((CharSequence)",", reserves));
        return this;
    }

    public static Page<LiquidityPoolResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<LiquidityPoolResponse>> type = new TypeToken<Page<LiquidityPoolResponse>>(){};
        ResponseHandler<Page<LiquidityPoolResponse>> responseHandler = new ResponseHandler<Page<LiquidityPoolResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public SSEStream<LiquidityPoolResponse> stream(EventListener<LiquidityPoolResponse> listener) {
        return SSEStream.create(this.httpClient, this, LiquidityPoolResponse.class, listener);
    }

    public Page<LiquidityPoolResponse> execute() throws IOException, TooManyRequestsException {
        return LiquidityPoolsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public LiquidityPoolsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public LiquidityPoolsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public LiquidityPoolsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

