/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum12;
import org.stellar.sdk.AssetTypeCreditAlphaNum4;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.ChangeTrustAsset;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.LiquidityPoolShareChangeTrustAsset;
import org.stellar.sdk.LiquidityPoolShareTrustLineAsset;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import shadow.com.google.common.base.Preconditions;

public abstract class TrustLineAsset
implements Comparable<TrustLineAsset> {
    TrustLineAsset() {
    }

    public static TrustLineAsset create(String canonicalForm) {
        return new Wrapper(Asset.create(canonicalForm));
    }

    public static TrustLineAsset create(String type, String code, String issuer) {
        return new Wrapper(Asset.create(type, code, issuer));
    }

    public static TrustLineAsset create(Asset asset) {
        return new Wrapper(asset);
    }

    public static TrustLineAsset create(LiquidityPoolParameters params) {
        return new LiquidityPoolShareTrustLineAsset(params);
    }

    public static TrustLineAsset create(LiquidityPoolID id) {
        return new LiquidityPoolShareTrustLineAsset(id);
    }

    public static TrustLineAsset create(ChangeTrustAsset.Wrapper wrapper) {
        return new Wrapper(wrapper.getAsset());
    }

    public static TrustLineAsset create(LiquidityPoolShareChangeTrustAsset share) {
        return new LiquidityPoolShareTrustLineAsset(share.getLiquidityPoolParams());
    }

    public static TrustLineAsset createNonNativeAsset(String code, String issuer) {
        return TrustLineAsset.create(Asset.createNonNativeAsset(code, issuer));
    }

    public static TrustLineAsset fromXdr(org.stellar.sdk.xdr.TrustLineAsset xdr) {
        switch (xdr.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                return TrustLineAsset.create(new AssetTypeNative());
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                String assetCode4 = Util.paddedByteArrayToString(xdr.getAlphaNum4().getAssetCode().getAssetCode4());
                String accountId = StrKey.encodeStellarAccountId(xdr.getAlphaNum4().getIssuer());
                return TrustLineAsset.create(new AssetTypeCreditAlphaNum4(assetCode4, accountId));
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                String assetCode12 = Util.paddedByteArrayToString(xdr.getAlphaNum12().getAssetCode().getAssetCode12());
                String accountId = StrKey.encodeStellarAccountId(xdr.getAlphaNum12().getIssuer());
                return TrustLineAsset.create(new AssetTypeCreditAlphaNum12(assetCode12, accountId));
            }
            case ASSET_TYPE_POOL_SHARE: {
                return new LiquidityPoolShareTrustLineAsset(LiquidityPoolID.fromXdr(xdr.getLiquidityPoolID()));
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + xdr.getDiscriminant());
    }

    public abstract String getType();

    public abstract boolean equals(Object var1);

    @Override
    public abstract int compareTo(TrustLineAsset var1);

    public abstract org.stellar.sdk.xdr.TrustLineAsset toXdr();

    public static final class Wrapper
    extends TrustLineAsset {
        private Asset asset;

        public Wrapper(Asset baseAsset) {
            Preconditions.checkNotNull(baseAsset, "asset cannot be null");
            this.asset = baseAsset;
        }

        public Asset getAsset() {
            return this.asset;
        }

        @Override
        public String getType() {
            return this.asset.getType();
        }

        @Override
        public final boolean equals(Object object) {
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            Wrapper o = (Wrapper)object;
            return this.getAsset().equals(o.getAsset());
        }

        @Override
        public int compareTo(TrustLineAsset other) {
            if (other.getType() == "pool_share") {
                return -1;
            }
            return this.getAsset().compareTo(((Wrapper)other).getAsset());
        }

        @Override
        public org.stellar.sdk.xdr.TrustLineAsset toXdr() {
            org.stellar.sdk.xdr.TrustLineAsset xdr = new org.stellar.sdk.xdr.TrustLineAsset();
            org.stellar.sdk.xdr.Asset assetXdr = this.asset.toXdr();
            xdr.setDiscriminant(assetXdr.getDiscriminant());
            xdr.setAlphaNum4(assetXdr.getAlphaNum4());
            xdr.setAlphaNum12(assetXdr.getAlphaNum12());
            return xdr;
        }
    }
}

