/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.CreateClaimableBalanceOperation;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Network;
import org.stellar.sdk.NoNetworkSelectedException;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ClaimableBalanceIDType;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationID;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;
import org.stellar.sdk.xdr.TransactionV0;
import org.stellar.sdk.xdr.TransactionV0Envelope;
import org.stellar.sdk.xdr.TransactionV1Envelope;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class Transaction
extends AbstractTransaction {
    private final long mFee;
    private final String mSourceAccount;
    private final long mSequenceNumber;
    private final org.stellar.sdk.Operation[] mOperations;
    private final Memo mMemo;
    private final TimeBounds mTimeBounds;
    private EnvelopeType envelopeType = EnvelopeType.ENVELOPE_TYPE_TX;

    Transaction(AccountConverter accountConverter, String sourceAccount, long fee, long sequenceNumber, org.stellar.sdk.Operation[] operations, Memo memo, TimeBounds timeBounds, Network network) {
        super(accountConverter, network);
        this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
        this.mSequenceNumber = Preconditions.checkNotNull(sequenceNumber, "sequenceNumber cannot be null");
        this.mOperations = Preconditions.checkNotNull(operations, "operations cannot be null");
        Preconditions.checkArgument(operations.length > 0, "At least one operation required");
        this.mFee = fee;
        this.mMemo = memo != null ? memo : Memo.none();
        this.mTimeBounds = timeBounds;
    }

    void setEnvelopeType(EnvelopeType envelopeType) {
        this.envelopeType = envelopeType;
    }

    @Override
    public byte[] signatureBase() {
        TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction = new TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction();
        taggedTransaction.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
        taggedTransaction.setTx(this.toV1Xdr(this.accountConverter));
        return Transaction.getTransactionSignatureBase(taggedTransaction, this.mNetwork);
    }

    public String getSourceAccount() {
        return this.mSourceAccount;
    }

    public long getSequenceNumber() {
        return this.mSequenceNumber;
    }

    public Memo getMemo() {
        return this.mMemo;
    }

    public TimeBounds getTimeBounds() {
        return this.mTimeBounds;
    }

    public long getFee() {
        return this.mFee;
    }

    public org.stellar.sdk.Operation[] getOperations() {
        return this.mOperations;
    }

    public String getClaimableBalanceId(int index) throws IOException {
        if (index < 0 || index >= this.mOperations.length) {
            throw new IllegalArgumentException("index: " + index + " is outside the bounds of the operations within this transaction");
        }
        if (!(this.mOperations[index] instanceof CreateClaimableBalanceOperation)) {
            throw new IllegalArgumentException("operation at index " + index + " is not of type CreateClaimableBalanceOperation: " + this.mOperations[index].getClass());
        }
        OperationID id = new OperationID();
        id.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_OP_ID);
        OperationID.OperationIDId body = new OperationID.OperationIDId();
        body.setOpNum(new Uint32(index));
        body.setSeqNum(new SequenceNumber(new Int64(this.getSequenceNumber())));
        body.setSourceAccount(StrKey.muxedAccountToAccountId(AccountConverter.disableMuxed().encode(this.getSourceAccount())));
        id.setId(body);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        id.encode(new XdrDataOutputStream(outputStream));
        ClaimableBalanceID result = new ClaimableBalanceID();
        result.setDiscriminant(ClaimableBalanceIDType.CLAIMABLE_BALANCE_ID_TYPE_V0);
        result.setV0(new Hash(Util.hash(outputStream.toByteArray())));
        outputStream.reset();
        result.encode(new XdrDataOutputStream(outputStream));
        return Util.bytesToHex(outputStream.toByteArray()).toLowerCase();
    }

    private TransactionV0 toXdr() {
        Uint32 fee = new Uint32();
        fee.setUint32((int)this.mFee);
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.mSequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        Operation[] operations = new Operation[this.mOperations.length];
        for (int i = 0; i < this.mOperations.length; ++i) {
            operations[i] = this.mOperations[i].toXdr(AccountConverter.disableMuxed());
        }
        TransactionV0.TransactionV0Ext ext = new TransactionV0.TransactionV0Ext();
        ext.setDiscriminant(0);
        TransactionV0 transaction = new TransactionV0();
        transaction.setFee(fee);
        transaction.setSeqNum(sequenceNumber);
        transaction.setSourceAccountEd25519(StrKey.encodeToXDRAccountId(this.mSourceAccount).getAccountID().getEd25519());
        transaction.setOperations(operations);
        transaction.setMemo(this.mMemo.toXdr());
        transaction.setTimeBounds(this.mTimeBounds == null ? null : this.mTimeBounds.toXdr());
        transaction.setExt(ext);
        return transaction;
    }

    private org.stellar.sdk.xdr.Transaction toV1Xdr(AccountConverter accountConverter) {
        Uint32 fee = new Uint32();
        fee.setUint32((int)this.mFee);
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.mSequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        Operation[] operations = new Operation[this.mOperations.length];
        for (int i = 0; i < this.mOperations.length; ++i) {
            operations[i] = this.mOperations[i].toXdr(accountConverter);
        }
        Transaction.TransactionExt ext = new Transaction.TransactionExt();
        ext.setDiscriminant(0);
        org.stellar.sdk.xdr.Transaction v1Tx = new org.stellar.sdk.xdr.Transaction();
        v1Tx.setFee(fee);
        v1Tx.setSeqNum(sequenceNumber);
        v1Tx.setSourceAccount(accountConverter.encode(this.mSourceAccount));
        v1Tx.setOperations(operations);
        v1Tx.setMemo(this.mMemo.toXdr());
        v1Tx.setTimeBounds(this.mTimeBounds == null ? null : this.mTimeBounds.toXdr());
        v1Tx.setExt(ext);
        return v1Tx;
    }

    public static Transaction fromV0EnvelopeXdr(AccountConverter accountConverter, TransactionV0Envelope envelope, Network network) {
        int mFee = envelope.getTx().getFee().getUint32();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        TimeBounds mTimeBounds = TimeBounds.fromXdr(envelope.getTx().getTimeBounds());
        org.stellar.sdk.Operation[] mOperations = new org.stellar.sdk.Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = org.stellar.sdk.Operation.fromXdr(accountConverter, envelope.getTx().getOperations()[i]);
        }
        Transaction transaction = new Transaction(accountConverter, StrKey.encodeStellarAccountId(envelope.getTx().getSourceAccountEd25519().getUint256()), mFee, mSequenceNumber, mOperations, mMemo, mTimeBounds, network);
        transaction.setEnvelopeType(EnvelopeType.ENVELOPE_TYPE_TX_V0);
        transaction.mSignatures.addAll(Arrays.asList(envelope.getSignatures()));
        return transaction;
    }

    public static Transaction fromV0EnvelopeXdr(TransactionV0Envelope envelope, Network network) {
        return Transaction.fromV0EnvelopeXdr(AccountConverter.disableMuxed(), envelope, network);
    }

    public static Transaction fromV1EnvelopeXdr(AccountConverter accountConverter, TransactionV1Envelope envelope, Network network) {
        int mFee = envelope.getTx().getFee().getUint32();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        TimeBounds mTimeBounds = TimeBounds.fromXdr(envelope.getTx().getTimeBounds());
        org.stellar.sdk.Operation[] mOperations = new org.stellar.sdk.Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = org.stellar.sdk.Operation.fromXdr(accountConverter, envelope.getTx().getOperations()[i]);
        }
        Transaction transaction = new Transaction(accountConverter, accountConverter.decode(envelope.getTx().getSourceAccount()), mFee, mSequenceNumber, mOperations, mMemo, mTimeBounds, network);
        transaction.mSignatures.addAll(Arrays.asList(envelope.getSignatures()));
        return transaction;
    }

    public static Transaction fromV1EnvelopeXdr(TransactionV1Envelope envelope, Network network) {
        return Transaction.fromV1EnvelopeXdr(AccountConverter.disableMuxed(), envelope, network);
    }

    @Override
    public TransactionEnvelope toEnvelopeXdr() {
        TransactionEnvelope xdr = new TransactionEnvelope();
        DecoratedSignature[] signatures = new DecoratedSignature[this.mSignatures.size()];
        signatures = this.mSignatures.toArray(signatures);
        if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX) {
            TransactionV1Envelope v1Envelope = new TransactionV1Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
            v1Envelope.setTx(this.toV1Xdr(this.accountConverter));
            v1Envelope.setSignatures(signatures);
            xdr.setV1(v1Envelope);
        } else if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX_V0) {
            TransactionV0Envelope v0Envelope = new TransactionV0Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_V0);
            v0Envelope.setTx(this.toXdr());
            v0Envelope.setSignatures(signatures);
            xdr.setV0(v0Envelope);
        } else {
            throw new RuntimeException("invalid envelope type: " + this.envelopeType);
        }
        return xdr;
    }

    public int hashCode() {
        return Objects.hashCode(this.envelopeType, this.mFee, this.mSourceAccount, this.mSequenceNumber, Arrays.hashCode(this.mOperations), this.mMemo, this.mTimeBounds, this.mSignatures, this.mNetwork);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)object;
        return Objects.equal(this.envelopeType, other.envelopeType) && Objects.equal(this.mFee, other.mFee) && Objects.equal(this.mSourceAccount, other.mSourceAccount) && Objects.equal(this.mSequenceNumber, other.mSequenceNumber) && Arrays.equals(this.mOperations, other.mOperations) && Objects.equal(this.mMemo, other.mMemo) && Objects.equal(this.mTimeBounds, other.mTimeBounds) && Objects.equal(this.mNetwork, other.mNetwork) && Objects.equal(this.mSignatures, other.mSignatures);
    }

    public static class Builder {
        private final TransactionBuilderAccount mSourceAccount;
        private final AccountConverter mAccountConverter;
        private Memo mMemo;
        private TimeBounds mTimeBounds;
        List<org.stellar.sdk.Operation> mOperations;
        private boolean timeoutSet;
        private Integer mBaseFee;
        private Network mNetwork;
        public static final long TIMEOUT_INFINITE = 0L;

        public Builder(AccountConverter accountConverter, TransactionBuilderAccount sourceAccount, Network network) {
            this.mAccountConverter = Preconditions.checkNotNull(accountConverter, "accountConverter cannot be null");
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            this.mOperations = Collections.synchronizedList(new ArrayList());
            this.mNetwork = Preconditions.checkNotNull(network, "Network cannot be null");
        }

        public Builder(TransactionBuilderAccount sourceAccount, Network network) {
            this(AccountConverter.disableMuxed(), sourceAccount, network);
        }

        public int getOperationsCount() {
            return this.mOperations.size();
        }

        public Builder addOperation(org.stellar.sdk.Operation operation) {
            Preconditions.checkNotNull(operation, "operation cannot be null");
            this.mOperations.add(operation);
            return this;
        }

        public Builder addMemo(Memo memo) {
            if (this.mMemo != null) {
                throw new RuntimeException("Memo has been already added.");
            }
            Preconditions.checkNotNull(memo, "memo cannot be null");
            this.mMemo = memo;
            return this;
        }

        public Builder addTimeBounds(TimeBounds timeBounds) {
            if (this.mTimeBounds != null) {
                throw new RuntimeException("TimeBounds has been already added.");
            }
            Preconditions.checkNotNull(timeBounds, "timeBounds cannot be null");
            this.mTimeBounds = timeBounds;
            return this;
        }

        public Builder setTimeout(long timeout) {
            if (this.mTimeBounds != null && this.mTimeBounds.getMaxTime() > 0L) {
                throw new RuntimeException("TimeBounds.max_time has been already set - setting timeout would overwrite it.");
            }
            if (timeout < 0L) {
                throw new RuntimeException("timeout cannot be negative");
            }
            this.timeoutSet = true;
            if (timeout > 0L) {
                long timeoutTimestamp = System.currentTimeMillis() / 1000L + timeout;
                this.mTimeBounds = this.mTimeBounds == null ? new TimeBounds(0L, timeoutTimestamp) : new TimeBounds(this.mTimeBounds.getMinTime(), timeoutTimestamp);
            }
            return this;
        }

        public Builder setBaseFee(int baseFee) {
            if (baseFee < 100) {
                throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
            }
            this.mBaseFee = baseFee;
            return this;
        }

        public Transaction build() {
            if ((this.mTimeBounds == null || this.mTimeBounds != null && this.mTimeBounds.getMaxTime() == 0L) && !this.timeoutSet) {
                throw new RuntimeException("TimeBounds has to be set or you must call setTimeout(TIMEOUT_INFINITE).");
            }
            if (this.mBaseFee == null) {
                throw new RuntimeException("mBaseFee has to be set. you must call setBaseFee().");
            }
            if (this.mNetwork == null) {
                throw new NoNetworkSelectedException();
            }
            org.stellar.sdk.Operation[] operations = new org.stellar.sdk.Operation[this.mOperations.size()];
            operations = this.mOperations.toArray(operations);
            Transaction transaction = new Transaction(this.mAccountConverter, this.mSourceAccount.getAccountId(), operations.length * this.mBaseFee, this.mSourceAccount.getIncrementedSequenceNumber(), operations, this.mMemo, this.mTimeBounds, this.mNetwork);
            this.mSourceAccount.incrementSequenceNumber();
            return transaction;
        }
    }
}

