/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.EnumSet;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SetTrustLineFlagsOp;
import org.stellar.sdk.xdr.TrustLineFlags;
import org.stellar.sdk.xdr.Uint32;
import shadow.com.google.common.base.Objects;

public class SetTrustlineFlagsOperation
extends Operation {
    private final String trustor;
    private final AssetTypeCreditAlphaNum asset;
    private final EnumSet<TrustLineFlags> clearFlags;
    private final EnumSet<TrustLineFlags> setFlags;

    private SetTrustlineFlagsOperation(String trustor, AssetTypeCreditAlphaNum asset, EnumSet<TrustLineFlags> clearFlags, EnumSet<TrustLineFlags> setFlags) {
        this.trustor = trustor;
        this.asset = asset;
        this.clearFlags = clearFlags;
        this.setFlags = setFlags;
    }

    public String getTrustor() {
        return this.trustor;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public EnumSet<TrustLineFlags> getSetFlags() {
        return this.setFlags;
    }

    public EnumSet<TrustLineFlags> getClearFlags() {
        return this.clearFlags;
    }

    private static Uint32 bitwiseOr(EnumSet<TrustLineFlags> set) {
        int v = 0;
        for (TrustLineFlags f : set) {
            v |= f.getValue();
        }
        Uint32 combined = new Uint32();
        combined.setUint32(v);
        return combined;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        SetTrustLineFlagsOp op = new SetTrustLineFlagsOp();
        op.setTrustor(StrKey.encodeToXDRAccountId(this.trustor));
        op.setAsset(this.asset.toXdr());
        op.setClearFlags(SetTrustlineFlagsOperation.bitwiseOr(this.clearFlags));
        op.setSetFlags(SetTrustlineFlagsOperation.bitwiseOr(this.setFlags));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.SET_TRUST_LINE_FLAGS);
        body.setSetTrustLineFlagsOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.trustor, this.asset, this.clearFlags, this.setFlags);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SetTrustlineFlagsOperation)) {
            return false;
        }
        SetTrustlineFlagsOperation other = (SetTrustlineFlagsOperation)object;
        return Objects.equal(this.trustor, other.trustor) && Objects.equal(this.asset, other.asset) && Objects.equal(this.clearFlags, other.clearFlags) && Objects.equal(this.setFlags, other.setFlags) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String trustor;
        private final AssetTypeCreditAlphaNum asset;
        private final EnumSet<TrustLineFlags> clearFlags;
        private final EnumSet<TrustLineFlags> setFlags;
        private String mSourceAccount;

        Builder(SetTrustLineFlagsOp op) {
            this.trustor = StrKey.encodeStellarAccountId(op.getTrustor());
            this.asset = Util.assertNonNativeAsset(Asset.fromXdr(op.getAsset()));
            this.clearFlags = Builder.flagSetFromInt(op.getClearFlags().getUint32());
            this.setFlags = Builder.flagSetFromInt(op.getSetFlags().getUint32());
        }

        private static EnumSet<TrustLineFlags> flagSetFromInt(int x) {
            EnumSet<TrustLineFlags> set = EnumSet.noneOf(TrustLineFlags.class);
            for (TrustLineFlags flag : TrustLineFlags.values()) {
                if ((flag.getValue() & x) == 0) continue;
                set.add(flag);
            }
            return set;
        }

        public Builder(String trustor, Asset asset, EnumSet<TrustLineFlags> clearFlags, EnumSet<TrustLineFlags> setFlags) {
            this.trustor = trustor;
            this.asset = Util.assertNonNativeAsset(asset);
            this.clearFlags = clearFlags;
            this.setFlags = setFlags;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = sourceAccount;
            return this;
        }

        public SetTrustlineFlagsOperation build() {
            SetTrustlineFlagsOperation operation = new SetTrustlineFlagsOperation(this.trustor, this.asset, this.clearFlags, this.setFlags);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

