/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class RevokeClaimableBalanceSponsorshipOperation
extends Operation {
    private final String balanceId;

    private RevokeClaimableBalanceSponsorshipOperation(String balanceId) {
        this.balanceId = balanceId;
    }

    public String getBalanceId() {
        return this.balanceId;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.CLAIMABLE_BALANCE);
        LedgerKey.LedgerKeyClaimableBalance claimableBalance = new LedgerKey.LedgerKeyClaimableBalance();
        claimableBalance.setBalanceID(Util.claimableBalanceIdToXDR(this.balanceId));
        key.setClaimableBalance(claimableBalance);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.balanceId, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof RevokeClaimableBalanceSponsorshipOperation)) {
            return false;
        }
        RevokeClaimableBalanceSponsorshipOperation other = (RevokeClaimableBalanceSponsorshipOperation)object;
        return Objects.equal(this.balanceId, other.balanceId) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String balanceId;
        private String mSourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.balanceId = Util.xdrToClaimableBalanceId(op.getLedgerKey().getClaimableBalance().getBalanceID());
        }

        public Builder(String balanceId) {
            this.balanceId = balanceId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public RevokeClaimableBalanceSponsorshipOperation build() {
            RevokeClaimableBalanceSponsorshipOperation operation = new RevokeClaimableBalanceSponsorshipOperation(this.balanceId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

