/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import org.stellar.sdk.Memo;
import org.stellar.sdk.MemoTooLongException;
import org.stellar.sdk.Util;
import shadow.com.google.common.io.BaseEncoding;

abstract class MemoHashAbstract
extends Memo {
    protected byte[] bytes;

    public MemoHashAbstract(byte[] bytes) {
        if (bytes.length < 32) {
            bytes = Util.paddedByteArray(bytes, 32);
        } else if (bytes.length > 32) {
            throw new MemoTooLongException("MEMO_HASH can contain 32 bytes at max.");
        }
        this.bytes = bytes;
    }

    public MemoHashAbstract(String hexString) {
        this(BaseEncoding.base16().lowerCase().decode(hexString.toLowerCase()));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getHexValue() {
        return BaseEncoding.base16().lowerCase().encode(this.bytes);
    }

    public String getTrimmedHexValue() {
        return this.getHexValue().split("00")[0];
    }

    @Override
    abstract org.stellar.sdk.xdr.Memo toXdr();

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoHashAbstract that = (MemoHashAbstract)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public String toString() {
        return this.bytes == null ? "" : Util.paddedByteArrayToString(this.bytes);
    }
}

