/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.AssetAmount;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.LiquidityPoolWithdrawOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class LiquidityPoolWithdrawOperation
extends Operation {
    private final LiquidityPoolID liquidityPoolID;
    private final String amount;
    private final String minAmountA;
    private final String minAmountB;

    public LiquidityPoolWithdrawOperation(LiquidityPoolID liquidityPoolID, String amount, String minAmountA, String minAmountB) {
        this.liquidityPoolID = Preconditions.checkNotNull(liquidityPoolID, "liquidityPoolID cannot be null");
        this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
        this.minAmountA = Preconditions.checkNotNull(minAmountA, "minAmountA cannot be null");
        this.minAmountB = Preconditions.checkNotNull(minAmountB, "minAmountB cannot be null");
    }

    public LiquidityPoolWithdrawOperation(LiquidityPoolWithdrawOp op) {
        this.liquidityPoolID = LiquidityPoolID.fromXdr(op.getLiquidityPoolID());
        this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        this.minAmountA = Operation.fromXdrAmount(op.getMinAmountA().getInt64());
        this.minAmountB = Operation.fromXdrAmount(op.getMinAmountB().getInt64());
    }

    public LiquidityPoolWithdrawOperation(AssetAmount a, AssetAmount b, String amount) {
        this.liquidityPoolID = new LiquidityPoolID(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT, a.getAsset(), b.getAsset(), LiquidityPoolParameters.Fee);
        this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
        this.minAmountA = a.getAmount();
        this.minAmountB = b.getAmount();
    }

    public LiquidityPoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getMinAmountA() {
        return this.minAmountA;
    }

    public String getMinAmountB() {
        return this.minAmountB;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        LiquidityPoolWithdrawOp op = new LiquidityPoolWithdrawOp();
        op.setLiquidityPoolID(this.getLiquidityPoolID().toXdr());
        op.setAmount(new Int64(Operation.toXdrAmount(this.getAmount())));
        op.setMinAmountA(new Int64(Operation.toXdrAmount(this.getMinAmountA())));
        op.setMinAmountB(new Int64(Operation.toXdrAmount(this.getMinAmountB())));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.LIQUIDITY_POOL_WITHDRAW);
        body.setLiquidityPoolWithdrawOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.liquidityPoolID, this.amount, this.minAmountA, this.minAmountB);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LiquidityPoolWithdrawOperation)) {
            return false;
        }
        LiquidityPoolWithdrawOperation o = (LiquidityPoolWithdrawOperation)object;
        return Objects.equal(this.getLiquidityPoolID(), o.getLiquidityPoolID()) && Objects.equal(this.getAmount(), o.getAmount()) && Objects.equal(this.getMinAmountA(), o.getMinAmountA()) && Objects.equal(this.getMinAmountB(), o.getMinAmountB());
    }
}

