/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.AssetAmount;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Price;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolDepositOp;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class LiquidityPoolDepositOperation
extends Operation {
    private final LiquidityPoolID liquidityPoolID;
    private final String maxAmountA;
    private final String maxAmountB;
    private final Price minPrice;
    private final Price maxPrice;

    public LiquidityPoolDepositOperation(LiquidityPoolID liquidityPoolID, String maxAmountA, String maxAmountB, Price minPrice, Price maxPrice) {
        this.liquidityPoolID = Preconditions.checkNotNull(liquidityPoolID, "liquidityPoolID cannot be null");
        this.maxAmountA = Preconditions.checkNotNull(maxAmountA, "amountA cannot be null");
        this.maxAmountB = Preconditions.checkNotNull(maxAmountB, "amountB cannot be null");
        this.minPrice = Preconditions.checkNotNull(minPrice, "minPrice cannot be null");
        this.maxPrice = Preconditions.checkNotNull(maxPrice, "maxPrice cannot be null");
    }

    public LiquidityPoolDepositOperation(LiquidityPoolDepositOp op) {
        this.liquidityPoolID = LiquidityPoolID.fromXdr(op.getLiquidityPoolID());
        this.maxAmountA = Operation.fromXdrAmount(op.getMaxAmountA().getInt64());
        this.maxAmountB = Operation.fromXdrAmount(op.getMaxAmountB().getInt64());
        this.minPrice = Price.fromXdr(op.getMinPrice());
        this.maxPrice = Price.fromXdr(op.getMaxPrice());
    }

    public LiquidityPoolDepositOperation(AssetAmount a, AssetAmount b, Price minPrice, Price maxPrice) {
        if (a.getAsset().compareTo(b.getAsset()) >= 0) {
            throw new RuntimeException("AssetA must be < AssetB");
        }
        this.liquidityPoolID = new LiquidityPoolID(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT, a.getAsset(), b.getAsset(), LiquidityPoolParameters.Fee);
        this.maxAmountA = a.getAmount();
        this.maxAmountB = b.getAmount();
        this.minPrice = Preconditions.checkNotNull(minPrice, "minPrice cannot be null");
        this.maxPrice = Preconditions.checkNotNull(maxPrice, "maxPrice cannot be null");
    }

    public LiquidityPoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    public String getMaxAmountA() {
        return this.maxAmountA;
    }

    public String getMaxAmountB() {
        return this.maxAmountB;
    }

    public Price getMinPrice() {
        return this.minPrice;
    }

    public Price getMaxPrice() {
        return this.maxPrice;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        LiquidityPoolDepositOp op = new LiquidityPoolDepositOp();
        op.setLiquidityPoolID(this.getLiquidityPoolID().toXdr());
        op.setMaxAmountA(new Int64(Operation.toXdrAmount(this.getMaxAmountA())));
        op.setMaxAmountB(new Int64(Operation.toXdrAmount(this.getMaxAmountB())));
        op.setMinPrice(this.getMinPrice().toXdr());
        op.setMaxPrice(this.getMaxPrice().toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.LIQUIDITY_POOL_DEPOSIT);
        body.setLiquidityPoolDepositOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.liquidityPoolID, this.maxAmountA, this.maxAmountB, this.minPrice, this.maxPrice);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LiquidityPoolDepositOperation)) {
            return false;
        }
        LiquidityPoolDepositOperation o = (LiquidityPoolDepositOperation)object;
        return Objects.equal(this.getLiquidityPoolID(), o.getLiquidityPoolID()) && Objects.equal(this.getMaxAmountA(), o.getMaxAmountA()) && Objects.equal(this.getMaxAmountB(), o.getMaxAmountB()) && Objects.equal(this.getMinPrice(), o.getMinPrice()) && Objects.equal(this.getMaxPrice(), o.getMaxPrice());
    }
}

