/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.List;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Predicate;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.ClaimantType;
import org.stellar.sdk.xdr.CreateClaimableBalanceOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.Lists;

public class CreateClaimableBalanceOperation
extends Operation {
    private final String amount;
    private final Asset asset;
    private final List<org.stellar.sdk.Claimant> claimants;

    private CreateClaimableBalanceOperation(String amount, Asset asset, List<org.stellar.sdk.Claimant> claimants) {
        this.asset = Preconditions.checkNotNull(asset, "asset cannot be null");
        this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
        this.claimants = Preconditions.checkNotNull(claimants, "claimants cannot be null");
        if (this.claimants.isEmpty()) {
            throw new IllegalArgumentException("claimants cannot be empty");
        }
    }

    public Asset getAsset() {
        return this.asset;
    }

    public String getAmount() {
        return this.amount;
    }

    public List<org.stellar.sdk.Claimant> getClaimants() {
        return this.claimants;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        CreateClaimableBalanceOp op = new CreateClaimableBalanceOp();
        op.setAsset(this.asset.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        Claimant[] xdrClaimants = new Claimant[this.claimants.size()];
        for (int i = 0; i < this.claimants.size(); ++i) {
            Claimant.ClaimantV0 v0 = new Claimant.ClaimantV0();
            v0.setDestination(StrKey.encodeToXDRAccountId(this.claimants.get(i).getDestination()));
            v0.setPredicate(this.claimants.get(i).getPredicate().toXdr());
            xdrClaimants[i] = new Claimant();
            xdrClaimants[i].setDiscriminant(ClaimantType.CLAIMANT_TYPE_V0);
            xdrClaimants[i].setV0(v0);
        }
        op.setClaimants(xdrClaimants);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_CLAIMABLE_BALANCE);
        body.setCreateClaimableBalanceOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.amount, this.asset, this.claimants, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CreateClaimableBalanceOperation)) {
            return false;
        }
        CreateClaimableBalanceOperation other = (CreateClaimableBalanceOperation)object;
        return Objects.equal(this.amount, other.amount) && Objects.equal(this.asset, other.asset) && Objects.equal(this.claimants, other.claimants) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String amount;
        private final Asset asset;
        private final List<org.stellar.sdk.Claimant> claimants;
        private String mSourceAccount;

        Builder(CreateClaimableBalanceOp op) {
            this.asset = Asset.fromXdr(op.getAsset());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
            this.claimants = Lists.newArrayList();
            for (Claimant c : op.getClaimants()) {
                this.claimants.add(new org.stellar.sdk.Claimant(StrKey.encodeStellarAccountId(c.getV0().getDestination()), Predicate.fromXdr(c.getV0().getPredicate())));
            }
        }

        public Builder(String amount, Asset asset, List<org.stellar.sdk.Claimant> claimants) {
            this.amount = amount;
            this.asset = asset;
            this.claimants = claimants;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public CreateClaimableBalanceOperation build() {
            CreateClaimableBalanceOperation operation = new CreateClaimableBalanceOperation(this.amount, this.asset, this.claimants);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

