/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ClawbackOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class ClawbackOperation
extends Operation {
    private final String mFrom;
    private final AssetTypeCreditAlphaNum mAsset;
    private final String mAmount;

    private ClawbackOperation(String from, AssetTypeCreditAlphaNum asset, String amount) {
        this.mFrom = Preconditions.checkNotNull(from, "from cannot be null");
        this.mAsset = Preconditions.checkNotNull(asset, "asset cannot be null");
        this.mAmount = Preconditions.checkNotNull(amount, "amount cannot be null");
    }

    public String getFrom() {
        return this.mFrom;
    }

    public String getAmount() {
        return this.mAmount;
    }

    public Asset getAsset() {
        return this.mAsset;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ClawbackOp op = new ClawbackOp();
        op.setFrom(accountConverter.encode(this.mFrom));
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.mAmount));
        op.setAmount(amount);
        op.setAsset(this.mAsset.toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAWBACK);
        body.setClawbackOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.mFrom, this.mAsset, this.mAmount);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClawbackOperation)) {
            return false;
        }
        ClawbackOperation other = (ClawbackOperation)object;
        return Objects.equal(this.mFrom, other.mFrom) && Objects.equal(this.mAsset, other.mAsset) && Objects.equal(this.mAmount, other.mAmount) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String from;
        private final AssetTypeCreditAlphaNum asset;
        private final String amount;
        private String mSourceAccount;

        Builder(AccountConverter accountConverter, ClawbackOp op) {
            this.from = accountConverter.decode(op.getFrom());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
            this.asset = Util.assertNonNativeAsset(Asset.fromXdr(op.getAsset()));
        }

        public Builder(String from, Asset asset, String amount) {
            this.from = from;
            this.asset = Util.assertNonNativeAsset(asset);
            this.amount = amount;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = sourceAccount;
            return this;
        }

        public ClawbackOperation build() {
            ClawbackOperation operation = new ClawbackOperation(this.from, this.asset, this.amount);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

