/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ClawbackClaimableBalanceOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class ClawbackClaimableBalanceOperation
extends Operation {
    private final String balanceId;

    private ClawbackClaimableBalanceOperation(String balanceId) {
        this.balanceId = Preconditions.checkNotNull(balanceId, "balanceId cannot be null");
    }

    public String getBalanceId() {
        return this.balanceId;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ClawbackClaimableBalanceOp op = new ClawbackClaimableBalanceOp();
        op.setBalanceID(Util.claimableBalanceIdToXDR(this.balanceId));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAWBACK_CLAIMABLE_BALANCE);
        body.setClawbackClaimableBalanceOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.balanceId);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClawbackClaimableBalanceOperation)) {
            return false;
        }
        ClawbackClaimableBalanceOperation other = (ClawbackClaimableBalanceOperation)object;
        return Objects.equal(this.balanceId, other.balanceId);
    }

    public static class Builder {
        private final String balanceId;
        private String mSourceAccount;

        Builder(ClawbackClaimableBalanceOp op) {
            this.balanceId = Util.xdrToClaimableBalanceId(op.getBalanceID());
        }

        public Builder(String balanceId) {
            this.balanceId = balanceId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = sourceAccount;
            return this;
        }

        public ClawbackClaimableBalanceOperation build() {
            ClawbackClaimableBalanceOperation operation = new ClawbackClaimableBalanceOperation(this.balanceId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

