/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ClaimClaimableBalanceOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class ClaimClaimableBalanceOperation
extends Operation {
    private final String balanceId;

    private ClaimClaimableBalanceOperation(String balanceId) {
        this.balanceId = Preconditions.checkNotNull(balanceId, "balanceId cannot be null");
    }

    public String getBalanceId() {
        return this.balanceId;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ClaimClaimableBalanceOp op = new ClaimClaimableBalanceOp();
        op.setBalanceID(Util.claimableBalanceIdToXDR(this.balanceId));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAIM_CLAIMABLE_BALANCE);
        body.setClaimClaimableBalanceOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.balanceId, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimClaimableBalanceOperation)) {
            return false;
        }
        ClaimClaimableBalanceOperation other = (ClaimClaimableBalanceOperation)object;
        return Objects.equal(this.balanceId, other.balanceId) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String balanceId;
        private String mSourceAccount;

        Builder(ClaimClaimableBalanceOp op) {
            this.balanceId = Util.xdrToClaimableBalanceId(op.getBalanceID());
        }

        public Builder(String balanceId) {
            this.balanceId = balanceId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public ClaimClaimableBalanceOperation build() {
            ClaimClaimableBalanceOperation operation = new ClaimClaimableBalanceOperation(this.balanceId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

