/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum12;
import org.stellar.sdk.AssetTypeCreditAlphaNum4;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.LiquidityPoolShareChangeTrustAsset;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TrustLineAsset;
import org.stellar.sdk.Util;
import shadow.com.google.common.base.Preconditions;

public abstract class ChangeTrustAsset
implements Comparable<ChangeTrustAsset> {
    ChangeTrustAsset() {
    }

    public static ChangeTrustAsset create(String canonicalForm) {
        return new Wrapper(Asset.create(canonicalForm));
    }

    public static ChangeTrustAsset create(String type, String code, String issuer) {
        return new Wrapper(Asset.create(type, code, issuer));
    }

    public static ChangeTrustAsset create(Asset asset) {
        return new Wrapper(asset);
    }

    public static ChangeTrustAsset create(LiquidityPoolParameters params) {
        return new LiquidityPoolShareChangeTrustAsset(params);
    }

    public static ChangeTrustAsset create(TrustLineAsset.Wrapper wrapper) {
        return new Wrapper(wrapper.getAsset());
    }

    public static ChangeTrustAsset createNonNativeAsset(String code, String issuer) {
        return ChangeTrustAsset.create(Asset.createNonNativeAsset(code, issuer));
    }

    public static ChangeTrustAsset fromXdr(org.stellar.sdk.xdr.ChangeTrustAsset xdr) {
        switch (xdr.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                return ChangeTrustAsset.create(new AssetTypeNative());
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                String assetCode4 = Util.paddedByteArrayToString(xdr.getAlphaNum4().getAssetCode().getAssetCode4());
                String accountId = StrKey.encodeStellarAccountId(xdr.getAlphaNum4().getIssuer());
                return ChangeTrustAsset.create(new AssetTypeCreditAlphaNum4(assetCode4, accountId));
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                String assetCode12 = Util.paddedByteArrayToString(xdr.getAlphaNum12().getAssetCode().getAssetCode12());
                String accountId = StrKey.encodeStellarAccountId(xdr.getAlphaNum12().getIssuer());
                return ChangeTrustAsset.create(new AssetTypeCreditAlphaNum12(assetCode12, accountId));
            }
            case ASSET_TYPE_POOL_SHARE: {
                return new LiquidityPoolShareChangeTrustAsset(LiquidityPoolParameters.fromXdr(xdr.getLiquidityPool()));
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + xdr.getDiscriminant());
    }

    public abstract String getType();

    public abstract boolean equals(Object var1);

    @Override
    public abstract int compareTo(ChangeTrustAsset var1);

    public abstract org.stellar.sdk.xdr.ChangeTrustAsset toXdr();

    public static final class Wrapper
    extends ChangeTrustAsset {
        private Asset asset;

        public Wrapper(Asset baseAsset) {
            Preconditions.checkNotNull(baseAsset, "asset cannot be null");
            this.asset = baseAsset;
        }

        public Asset getAsset() {
            return this.asset;
        }

        @Override
        public String getType() {
            return this.asset.getType();
        }

        @Override
        public final boolean equals(Object object) {
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            Wrapper o = (Wrapper)object;
            return this.getAsset().equals(o.getAsset());
        }

        @Override
        public int compareTo(ChangeTrustAsset other) {
            if (other.getType() == "pool_share") {
                return -1;
            }
            return this.getAsset().compareTo(((Wrapper)other).getAsset());
        }

        @Override
        public org.stellar.sdk.xdr.ChangeTrustAsset toXdr() {
            org.stellar.sdk.xdr.ChangeTrustAsset xdr = new org.stellar.sdk.xdr.ChangeTrustAsset();
            org.stellar.sdk.xdr.Asset assetXdr = this.asset.toXdr();
            xdr.setDiscriminant(assetXdr.getDiscriminant());
            xdr.setAlphaNum4(assetXdr.getAlphaNum4());
            xdr.setAlphaNum12(assetXdr.getAlphaNum12());
            return xdr;
        }
    }
}

