/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.BumpSequenceOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SequenceNumber;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class BumpSequenceOperation
extends Operation {
    private final long bumpTo;

    private BumpSequenceOperation(long bumpTo) {
        this.bumpTo = bumpTo;
    }

    public long getBumpTo() {
        return this.bumpTo;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        BumpSequenceOp op = new BumpSequenceOp();
        Int64 bumpTo = new Int64();
        bumpTo.setInt64(this.bumpTo);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(bumpTo);
        op.setBumpTo(sequenceNumber);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.BUMP_SEQUENCE);
        body.setBumpSequenceOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.bumpTo, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof BumpSequenceOperation)) {
            return false;
        }
        BumpSequenceOperation other = (BumpSequenceOperation)object;
        return Objects.equal(this.bumpTo, other.bumpTo) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final long bumpTo;
        private String mSourceAccount;

        Builder(BumpSequenceOp op) {
            this.bumpTo = op.getBumpTo().getSequenceNumber().getInt64();
        }

        public Builder(long bumpTo) {
            this.bumpTo = bumpTo;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public BumpSequenceOperation build() {
            BumpSequenceOperation operation = new BumpSequenceOperation(this.bumpTo);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

