/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetCodeLengthInvalidException;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.AlphaNum12;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetType;

public final class AssetTypeCreditAlphaNum12
extends AssetTypeCreditAlphaNum {
    public AssetTypeCreditAlphaNum12(String code, String issuer) {
        super(code, issuer);
        if (code.length() < 5 || code.length() > 12) {
            throw new AssetCodeLengthInvalidException();
        }
    }

    @Override
    public String getType() {
        return "credit_alphanum12";
    }

    @Override
    public org.stellar.sdk.xdr.Asset toXdr() {
        org.stellar.sdk.xdr.Asset xdr = new org.stellar.sdk.xdr.Asset();
        xdr.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM12);
        AlphaNum12 credit = new AlphaNum12();
        AssetCode12 assetCode12 = new AssetCode12();
        assetCode12.setAssetCode12(Util.paddedByteArray(this.mCode, 12));
        credit.setAssetCode(assetCode12);
        credit.setIssuer(StrKey.encodeToXDRAccountId(this.mIssuer));
        xdr.setAlphaNum12(credit);
        return xdr;
    }

    @Override
    public int compareTo(Asset other) {
        if (other.getType() != "credit_alphanum12") {
            return 1;
        }
        AssetTypeCreditAlphaNum o = (AssetTypeCreditAlphaNum)other;
        if (this.getCode() != o.getCode()) {
            return this.getCode().compareTo(o.getCode());
        }
        return this.getIssuer().compareTo(o.getIssuer());
    }
}

