// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;


import java.io.IOException;

import com.google.common.base.Objects;
import java.util.Arrays;

// === xdr source ============================================================

//  struct AccountEntry
//  {
//      AccountID accountID;      // master public key for this account
//      int64 balance;            // in stroops
//      SequenceNumber seqNum;    // last sequence number used for this account
//      uint32 numSubEntries;     // number of sub-entries this account has
//                                // drives the reserve
//      AccountID* inflationDest; // Account to vote for during inflation
//      uint32 flags;             // see AccountFlags
//  
//      string32 homeDomain; // can be used for reverse federation and memo lookup
//  
//      // fields used for signatures
//      // thresholds stores unsigned bytes: [weight of master|low|medium|high]
//      Thresholds thresholds;
//  
//      Signer signers<MAX_SIGNERS>; // possible signers for this account
//  
//      // reserved for future use
//      union switch (int v)
//      {
//      case 0:
//          void;
//      case 1:
//          AccountEntryExtensionV1 v1;
//      }
//      ext;
//  };

//  ===========================================================================
public class AccountEntry implements XdrElement {
  public AccountEntry () {}
  private AccountID accountID;
  public AccountID getAccountID() {
    return this.accountID;
  }
  public void setAccountID(AccountID value) {
    this.accountID = value;
  }
  private Int64 balance;
  public Int64 getBalance() {
    return this.balance;
  }
  public void setBalance(Int64 value) {
    this.balance = value;
  }
  private SequenceNumber seqNum;
  public SequenceNumber getSeqNum() {
    return this.seqNum;
  }
  public void setSeqNum(SequenceNumber value) {
    this.seqNum = value;
  }
  private Uint32 numSubEntries;
  public Uint32 getNumSubEntries() {
    return this.numSubEntries;
  }
  public void setNumSubEntries(Uint32 value) {
    this.numSubEntries = value;
  }
  private AccountID inflationDest;
  public AccountID getInflationDest() {
    return this.inflationDest;
  }
  public void setInflationDest(AccountID value) {
    this.inflationDest = value;
  }
  private Uint32 flags;
  public Uint32 getFlags() {
    return this.flags;
  }
  public void setFlags(Uint32 value) {
    this.flags = value;
  }
  private String32 homeDomain;
  public String32 getHomeDomain() {
    return this.homeDomain;
  }
  public void setHomeDomain(String32 value) {
    this.homeDomain = value;
  }
  private Thresholds thresholds;
  public Thresholds getThresholds() {
    return this.thresholds;
  }
  public void setThresholds(Thresholds value) {
    this.thresholds = value;
  }
  private Signer[] signers;
  public Signer[] getSigners() {
    return this.signers;
  }
  public void setSigners(Signer[] value) {
    this.signers = value;
  }
  private AccountEntryExt ext;
  public AccountEntryExt getExt() {
    return this.ext;
  }
  public void setExt(AccountEntryExt value) {
    this.ext = value;
  }
  public static void encode(XdrDataOutputStream stream, AccountEntry encodedAccountEntry) throws IOException{
    AccountID.encode(stream, encodedAccountEntry.accountID);
    Int64.encode(stream, encodedAccountEntry.balance);
    SequenceNumber.encode(stream, encodedAccountEntry.seqNum);
    Uint32.encode(stream, encodedAccountEntry.numSubEntries);
    if (encodedAccountEntry.inflationDest != null) {
    stream.writeInt(1);
    AccountID.encode(stream, encodedAccountEntry.inflationDest);
    } else {
    stream.writeInt(0);
    }
    Uint32.encode(stream, encodedAccountEntry.flags);
    String32.encode(stream, encodedAccountEntry.homeDomain);
    Thresholds.encode(stream, encodedAccountEntry.thresholds);
    int signerssize = encodedAccountEntry.getSigners().length;
    stream.writeInt(signerssize);
    for (int i = 0; i < signerssize; i++) {
      Signer.encode(stream, encodedAccountEntry.signers[i]);
    }
    AccountEntryExt.encode(stream, encodedAccountEntry.ext);
  }
  public void encode(XdrDataOutputStream stream) throws IOException {
    encode(stream, this);
  }
  public static AccountEntry decode(XdrDataInputStream stream) throws IOException {
    AccountEntry decodedAccountEntry = new AccountEntry();
    decodedAccountEntry.accountID = AccountID.decode(stream);
    decodedAccountEntry.balance = Int64.decode(stream);
    decodedAccountEntry.seqNum = SequenceNumber.decode(stream);
    decodedAccountEntry.numSubEntries = Uint32.decode(stream);
    int inflationDestPresent = stream.readInt();
    if (inflationDestPresent != 0) {
    decodedAccountEntry.inflationDest = AccountID.decode(stream);
    }
    decodedAccountEntry.flags = Uint32.decode(stream);
    decodedAccountEntry.homeDomain = String32.decode(stream);
    decodedAccountEntry.thresholds = Thresholds.decode(stream);
    int signerssize = stream.readInt();
    decodedAccountEntry.signers = new Signer[signerssize];
    for (int i = 0; i < signerssize; i++) {
      decodedAccountEntry.signers[i] = Signer.decode(stream);
    }
    decodedAccountEntry.ext = AccountEntryExt.decode(stream);
    return decodedAccountEntry;
  }
  @Override
  public int hashCode() {
    return Objects.hashCode(this.accountID, this.balance, this.seqNum, this.numSubEntries, this.inflationDest, this.flags, this.homeDomain, this.thresholds, Arrays.hashCode(this.signers), this.ext);
  }
  @Override
  public boolean equals(Object object) {
    if (!(object instanceof AccountEntry)) {
      return false;
    }

    AccountEntry other = (AccountEntry) object;
    return Objects.equal(this.accountID, other.accountID) && Objects.equal(this.balance, other.balance) && Objects.equal(this.seqNum, other.seqNum) && Objects.equal(this.numSubEntries, other.numSubEntries) && Objects.equal(this.inflationDest, other.inflationDest) && Objects.equal(this.flags, other.flags) && Objects.equal(this.homeDomain, other.homeDomain) && Objects.equal(this.thresholds, other.thresholds) && Arrays.equals(this.signers, other.signers) && Objects.equal(this.ext, other.ext);
  }

  public static final class Builder {
    private AccountID accountID;
    private Int64 balance;
    private SequenceNumber seqNum;
    private Uint32 numSubEntries;
    private AccountID inflationDest;
    private Uint32 flags;
    private String32 homeDomain;
    private Thresholds thresholds;
    private Signer[] signers;
    private AccountEntryExt ext;

    public Builder accountID(AccountID accountID) {
      this.accountID = accountID;
      return this;
    }

    public Builder balance(Int64 balance) {
      this.balance = balance;
      return this;
    }

    public Builder seqNum(SequenceNumber seqNum) {
      this.seqNum = seqNum;
      return this;
    }

    public Builder numSubEntries(Uint32 numSubEntries) {
      this.numSubEntries = numSubEntries;
      return this;
    }

    public Builder inflationDest(AccountID inflationDest) {
      this.inflationDest = inflationDest;
      return this;
    }

    public Builder flags(Uint32 flags) {
      this.flags = flags;
      return this;
    }

    public Builder homeDomain(String32 homeDomain) {
      this.homeDomain = homeDomain;
      return this;
    }

    public Builder thresholds(Thresholds thresholds) {
      this.thresholds = thresholds;
      return this;
    }

    public Builder signers(Signer[] signers) {
      this.signers = signers;
      return this;
    }

    public Builder ext(AccountEntryExt ext) {
      this.ext = ext;
      return this;
    }

    public AccountEntry build() {
      AccountEntry val = new AccountEntry();
      val.setAccountID(accountID);
      val.setBalance(balance);
      val.setSeqNum(seqNum);
      val.setNumSubEntries(numSubEntries);
      val.setInflationDest(inflationDest);
      val.setFlags(flags);
      val.setHomeDomain(homeDomain);
      val.setThresholds(thresholds);
      val.setSigners(signers);
      val.setExt(ext);
      return val;
    }
  }

  public static class AccountEntryExt {
    public AccountEntryExt () {}
    Integer v;
    public Integer getDiscriminant() {
      return this.v;
    }
    public void setDiscriminant(Integer value) {
      this.v = value;
    }
    private AccountEntryExtensionV1 v1;
    public AccountEntryExtensionV1 getV1() {
      return this.v1;
    }
    public void setV1(AccountEntryExtensionV1 value) {
      this.v1 = value;
    }

    public static final class Builder {
      private Integer discriminant;
      private AccountEntryExtensionV1 v1;

      public Builder discriminant(Integer discriminant) {
        this.discriminant = discriminant;
        return this;
      }

      public Builder v1(AccountEntryExtensionV1 v1) {
        this.v1 = v1;
        return this;
      }

      public AccountEntryExt build() {
        AccountEntryExt val = new AccountEntryExt();
        val.setDiscriminant(discriminant);
        val.setV1(v1);
        return val;
      }
    }

    public static void encode(XdrDataOutputStream stream, AccountEntryExt encodedAccountEntryExt) throws IOException {
    //Xdrgen::AST::Typespecs::Int
    //Integer
    stream.writeInt(encodedAccountEntryExt.getDiscriminant().intValue());
    switch (encodedAccountEntryExt.getDiscriminant()) {
    case 0:
    break;
    case 1:
    AccountEntryExtensionV1.encode(stream, encodedAccountEntryExt.v1);
    break;
    }
    }
    public void encode(XdrDataOutputStream stream) throws IOException {
      encode(stream, this);
    }
    public static AccountEntryExt decode(XdrDataInputStream stream) throws IOException {
    AccountEntryExt decodedAccountEntryExt = new AccountEntryExt();
    Integer discriminant = stream.readInt();
    decodedAccountEntryExt.setDiscriminant(discriminant);
    switch (decodedAccountEntryExt.getDiscriminant()) {
    case 0:
    break;
    case 1:
    decodedAccountEntryExt.v1 = AccountEntryExtensionV1.decode(stream);
    break;
    }
      return decodedAccountEntryExt;
    }
    @Override
    public int hashCode() {
      return Objects.hashCode(this.v1, this.v);
    }
    @Override
    public boolean equals(Object object) {
      if (!(object instanceof AccountEntryExt)) {
        return false;
      }

      AccountEntryExt other = (AccountEntryExt) object;
      return Objects.equal(this.v1, other.v1) && Objects.equal(this.v, other.v);
    }

  }
}
