package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.AssetResponse;

import java.io.IOException;

public class AssetsRequestBuilder extends RequestBuilder {
    public AssetsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "assets");
    }

    public AssetsRequestBuilder assetCode(String assetCode) {
        uriBuilder.setQueryParameter("asset_code", assetCode);
        return this;
    }

    public AssetsRequestBuilder assetIssuer(String assetIssuer) {
        uriBuilder.setQueryParameter("asset_issuer", assetIssuer);
        return this;
    }

    public static Page<AssetResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken type = new TypeToken<Page<AssetResponse>>() {};
        ResponseHandler<Page<AssetResponse>> responseHandler = new ResponseHandler<Page<AssetResponse>>(type);

        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();

        return responseHandler.handleResponse(response);
    }

    public Page<AssetResponse> execute() throws IOException, TooManyRequestsException {
        return this.execute(this.httpClient, this.buildUri());
    }
}
