/*
 * Decompiled with CFR 0.152.
 */
package stonehorse.candy;

import java.util.Arrays;
import java.util.Objects;

public class Tuples {
    private Tuples() {
    }

    public static <T> T1<T> of(T t) {
        return new Box(t);
    }

    public static <F, S> T2<F, S> of(F first, S second) {
        return new Pair(first, second);
    }

    public static <F, S, T> T3<F, S, T> of(F first, S second, T third) {
        return new Triplet(first, second, third);
    }

    public static <V1, V2, V3, V4> T4<V1, V2, V3, V4> of(V1 first, V2 second, V3 third, V4 fourth) {
        return new Quartet<V1, V2, V3, V4>(first, second, third, fourth);
    }

    public static <V1, V2, V3, V4, V5> T5<V1, V2, V3, V4, V5> of(V1 first, V2 second, V3 third, V4 fourth, V5 fifth) {
        return new Quintet<V1, V2, V3, V4, V5>(first, second, third, fourth, fifth);
    }

    public static <T> T first(T1<T> t) {
        return t._1();
    }

    public static <T> T second(T2<?, T> t) {
        return t._2();
    }

    public static <T> T third(T3<?, ?, T> t) {
        return t._3();
    }

    public static <T> T fourth(T4<?, ?, ?, T> t) {
        return t._4();
    }

    public static <T> T fifth(T5<?, ?, ?, ?, T> t) {
        return t._5();
    }

    private static class Quintet<V1, V2, V3, V4, V5>
    implements T5<V1, V2, V3, V4, V5> {
        private final V1 first;
        private final V2 second;
        private final V3 third;
        private final V4 fourth;
        private final V5 fifth;

        Quintet(V1 first, V2 second, V3 third, V4 fourth, V5 fifth) {
            this.first = first;
            this.second = second;
            this.third = third;
            this.fourth = fourth;
            this.fifth = fifth;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second, this.third, this.fourth, this.fifth);
        }

        private static boolean not(boolean b) {
            return !b;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (Quintet.not(obj instanceof Quintet)) {
                return false;
            }
            Quintet other = (Quintet)obj;
            return Arrays.asList(this.first, this.second, this.third, this.fourth, this.fifth).equals(Arrays.asList(other.first, other.second, other.third, other.fourth, other.fifth));
        }

        public String toString() {
            return "[" + this.first + ", " + this.second + ", " + this.third + ", " + this.fourth + ", " + this.fifth + "]";
        }

        @Override
        public V5 _5() {
            return this.fifth;
        }

        @Override
        public V4 _4() {
            return this.fourth;
        }

        @Override
        public V1 _1() {
            return this.first;
        }

        @Override
        public T5<V1, V2, V3, V4, V5> _1(V1 v) {
            return new Quintet<V1, V2, V3, V4, V5>(v, this.second, this.third, this.fourth, this.fifth);
        }

        @Override
        public V3 _3() {
            return this.third;
        }

        @Override
        public V2 _2() {
            return this.second;
        }

        @Override
        public T5<V1, V2, V3, V4, V5> _2(V2 v) {
            return new Quintet<V1, V2, V3, V4, V5>(this.first, v, this.third, this.fourth, this.fifth);
        }

        @Override
        public T5<V1, V2, V3, V4, V5> _3(V3 v) {
            return new Quintet<V1, V2, V3, V4, V5>(this.first, this.second, v, this.fourth, this.fifth);
        }

        @Override
        public T5<V1, V2, V3, V4, V5> _4(V4 v) {
            return new Quintet<V1, V2, V3, V4, V5>(this.first, this.second, this.third, v, this.fifth);
        }

        @Override
        public T5<V1, V2, V3, V4, V5> _5(V5 v) {
            return new Quintet<V1, V2, V3, V4, V5>(this.first, this.second, this.third, this.fourth, v);
        }

        @Override
        public T4<V2, V3, V4, V5> skip() {
            return new Quartet<V2, V3, V4, V5>(this.second, this.third, this.fourth, this.fifth);
        }

        @Override
        public <X> T5<X, V2, V3, V4, V5> with_1(X x) {
            return new Quintet<X, V2, V3, V4, V5>(x, this.second, this.third, this.fourth, this.fifth);
        }

        @Override
        public <X> T5<V1, X, V3, V4, V5> with_2(X x) {
            return new Quintet<V1, X, V3, V4, V5>(this.first, x, this.third, this.fourth, this.fifth);
        }

        @Override
        public <X> T5<V1, V2, X, V4, V5> with_3(X x) {
            return new Quintet<V1, V2, X, V4, V5>(this.first, this.second, x, this.fourth, this.fifth);
        }

        @Override
        public <X> T5<V1, V2, V3, X, V5> with_4(X x) {
            return new Quintet<V1, V2, V3, X, V5>(this.first, this.second, this.third, x, this.fifth);
        }

        @Override
        public <X> T5<V1, V2, V3, V4, X> with_5(X x) {
            return new Quintet<V1, V2, V3, V4, X>(this.first, this.second, this.third, this.fourth, x);
        }
    }

    private static class Quartet<V1, V2, V3, V4>
    implements T4<V1, V2, V3, V4> {
        private final V1 first;
        private final V2 second;
        private final V3 third;
        private final V4 fourth;

        public Quartet(V1 first, V2 second, V3 third, V4 fourth) {
            this.first = first;
            this.second = second;
            this.third = third;
            this.fourth = fourth;
        }

        @Override
        public V4 _4() {
            return this.fourth;
        }

        @Override
        public V1 _1() {
            return this.first;
        }

        @Override
        public T4<V1, V2, V3, V4> _1(V1 v) {
            return new Quartet<V1, V2, V3, V4>(v, this.second, this.third, this.fourth);
        }

        @Override
        public V3 _3() {
            return this.third;
        }

        @Override
        public V2 _2() {
            return this.second;
        }

        @Override
        public T4<V1, V2, V3, V4> _2(V2 v) {
            return new Quartet<V1, V2, V3, V4>(this.first, v, this.third, this.fourth);
        }

        @Override
        public T4<V1, V2, V3, V4> _3(V3 v) {
            return new Quartet<V1, V2, V3, V4>(this.first, this.second, v, this.fourth);
        }

        @Override
        public T4<V1, V2, V3, V4> _4(V4 v) {
            return new Quartet<V1, V2, V3, V4>(this.first, this.second, this.third, v);
        }

        @Override
        public T3<V2, V3, V4> skip() {
            return new Triplet(this.second, this.third, this.fourth);
        }

        @Override
        public <X> T4<X, V2, V3, V4> with_1(X x) {
            return new Quartet<X, V2, V3, V4>(x, this.second, this.third, this.fourth);
        }

        @Override
        public <X> T4<V1, X, V3, V4> with_2(X x) {
            return new Quartet<V1, X, V3, V4>(this.first, x, this.third, this.fourth);
        }

        @Override
        public <X> T4<V1, V2, X, V4> with_3(X x) {
            return new Quartet<V1, V2, X, V4>(this.first, this.second, x, this.fourth);
        }

        @Override
        public <X> T4<V1, V2, V3, X> with_4(X x) {
            return new Quartet<V1, V2, V3, X>(this.first, this.second, this.third, x);
        }

        @Override
        public <X> T5<V1, V2, V3, V4, X> with_5(X x) {
            return new Quintet<V1, V2, V3, V4, X>(this.first, this.second, this.third, this.fourth, x);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second, this.third, this.fourth);
        }

        private static boolean not(boolean b) {
            return !b;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (Quartet.not(obj instanceof Quartet)) {
                return false;
            }
            Quartet other = (Quartet)obj;
            return Arrays.asList(this.first, this.second, this.third, this.fourth).equals(Arrays.asList(other.first, other.second, other.third, other.fourth));
        }

        public String toString() {
            return "[" + this.first + ", " + this.second + ", " + this.third + ", " + this.fourth + "]";
        }
    }

    private static class Triplet<F, S, T>
    implements T3<F, S, T> {
        private final F first;
        private final S second;
        private final T third;

        private Triplet(F f, S s, T t) {
            this.first = f;
            this.second = s;
            this.third = t;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second, this.third);
        }

        private static boolean not(boolean b) {
            return !b;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (Triplet.not(obj instanceof Triplet)) {
                return false;
            }
            Triplet other = (Triplet)obj;
            return Arrays.asList(this.first, this.second, this.third).equals(Arrays.asList(other.first, other.second, other.third));
        }

        public String toString() {
            return "[" + this.first + ", " + this.second + ", " + this.third + "]";
        }

        @Override
        public T _3() {
            return this.third;
        }

        @Override
        public T3<F, S, T> _2(S s) {
            return new Triplet<F, S, T>(this.first, s, this.third);
        }

        @Override
        public T3<F, S, T> _1(F f) {
            return new Triplet<F, S, T>(f, this.second, this.third);
        }

        @Override
        public T3<F, S, T> _3(T t) {
            return new Triplet<F, S, T>(this.first, this.second, t);
        }

        @Override
        public T2<S, T> skip() {
            return new Pair(this.second, this.third);
        }

        @Override
        public <X> Triplet<F, X, T> with_2(X x) {
            return new Triplet<F, X, T>(this.first, x, this.third);
        }

        @Override
        public <X> Triplet<X, S, T> with_1(X x) {
            return new Triplet<X, S, T>(x, this.second, this.third);
        }

        @Override
        public <X> Triplet<F, S, X> with_3(X x) {
            return new Triplet<F, S, X>(this.first, this.second, x);
        }

        @Override
        public S _2() {
            return this.second;
        }

        @Override
        public F _1() {
            return this.first;
        }

        @Override
        public <X> T4<F, S, T, X> with_4(X x) {
            return new Quartet<F, S, T, X>(this.first, this.second, this.third, x);
        }
    }

    private static class Pair<F, S>
    implements T2<F, S> {
        private final F first;
        private final S second;

        private Pair(F f, S s) {
            this.first = f;
            this.second = s;
        }

        private static boolean not(boolean b) {
            return !b;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (Pair.not(obj instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)obj;
            return Arrays.asList(this.first, this.second).equals(Arrays.asList(other.first, other.second));
        }

        public String toString() {
            return "[" + this.first + ", " + this.second + "]";
        }

        @Override
        public S _2() {
            return this.second;
        }

        @Override
        public T2<F, S> _2(S s) {
            return new Pair<F, S>(this.first, s);
        }

        @Override
        public T1<S> skip() {
            return new Box(this.second);
        }

        @Override
        public <X> T3<F, S, X> with_3(X x) {
            return new Triplet(this.first, this.second, x);
        }

        @Override
        public <X> Pair<F, X> with_2(X x) {
            return new Pair<F, X>(this.first, x);
        }

        @Override
        public <X> Pair<X, S> with_1(X x) {
            return new Pair<X, S>(x, this.second);
        }

        @Override
        public T2<F, S> _1(F f) {
            return new Pair<F, S>(f, this.second);
        }

        @Override
        public F _1() {
            return this.first;
        }
    }

    private static class Box<T>
    implements T1<T> {
        private final T t;

        private Box(T t) {
            this.t = t;
        }

        public String toString() {
            return "[" + this.t + "]";
        }

        public boolean equals(Object obj) {
            return obj instanceof Box && Objects.equals(this.t, ((Box)obj).t);
        }

        public int hashCode() {
            return Objects.hash(this.t);
        }

        @Override
        public T _1() {
            return this.t;
        }

        @Override
        public T1<T> _1(T t) {
            return new Box<T>(t);
        }

        @Override
        public <X> Box<X> with_1(X x) {
            return new Box<X>(x);
        }

        @Override
        public <X> T2<T, X> with_2(X x) {
            return new Pair(this.t, x);
        }
    }

    public static interface T5<V1, V2, V3, V4, V5>
    extends T4<V1, V2, V3, V4> {
        public V5 _5();

        public T5<V1, V2, V3, V4, V5> _1(V1 var1);

        public T5<V1, V2, V3, V4, V5> _2(V2 var1);

        public T5<V1, V2, V3, V4, V5> _3(V3 var1);

        public T5<V1, V2, V3, V4, V5> _4(V4 var1);

        public T5<V1, V2, V3, V4, V5> _5(V5 var1);

        @Override
        public T4<V2, V3, V4, V5> skip();

        public <X> T5<X, V2, V3, V4, V5> with_1(X var1);

        public <X> T5<V1, X, V3, V4, V5> with_2(X var1);

        public <X> T5<V1, V2, X, V4, V5> with_3(X var1);

        public <X> T5<V1, V2, V3, X, V5> with_4(X var1);

        @Override
        public <X> T5<V1, V2, V3, V4, X> with_5(X var1);
    }

    public static interface T4<V1, V2, V3, V4>
    extends T3<V1, V2, V3> {
        public V4 _4();

        public T4<V1, V2, V3, V4> _1(V1 var1);

        public T4<V1, V2, V3, V4> _2(V2 var1);

        public T4<V1, V2, V3, V4> _3(V3 var1);

        public T4<V1, V2, V3, V4> _4(V4 var1);

        @Override
        public T3<V2, V3, V4> skip();

        public <X> T4<X, V2, V3, V4> with_1(X var1);

        public <X> T4<V1, X, V3, V4> with_2(X var1);

        public <X> T4<V1, V2, X, V4> with_3(X var1);

        @Override
        public <X> T4<V1, V2, V3, X> with_4(X var1);

        public <X> T5<V1, V2, V3, V4, X> with_5(X var1);
    }

    public static interface T3<V1, V2, V3>
    extends T2<V1, V2> {
        public V3 _3();

        public T3<V1, V2, V3> _2(V2 var1);

        public T3<V1, V2, V3> _1(V1 var1);

        public T3<V1, V2, V3> _3(V3 var1);

        public T2<V2, V3> skip();

        public <X> T3<X, V2, V3> with_1(X var1);

        public <X> T3<V1, X, V3> with_2(X var1);

        @Override
        public <X> T3<V1, V2, X> with_3(X var1);

        public <X> T4<V1, V2, V3, X> with_4(X var1);
    }

    public static interface T2<V1, V2>
    extends T1<V1> {
        public V2 _2();

        public T2<V1, V2> _2(V2 var1);

        public T1<V2> skip();

        public <X> T3<V1, V2, X> with_3(X var1);

        @Override
        public <X> T2<V1, X> with_2(X var1);

        public <X> T2<X, V2> with_1(X var1);

        public T2<V1, V2> _1(V1 var1);
    }

    public static interface T1<V> {
        public V _1();

        public T1<V> _1(V var1);

        public <X> T1<X> with_1(X var1);

        public <X> T2<V, X> with_2(X var1);
    }
}

