/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefanbirkner.editors;

import com.github.stefanbirkner.editors.mapper.Mapper;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorWithMapper
implements PropertyEditor {
    private final PropertyEditor propertyEditor;
    private final Mapper<String> mapper;

    public PropertyEditorWithMapper(PropertyEditor propertyEditor, Mapper<String> mapper) {
        if (propertyEditor == null) {
            throw new IllegalArgumentException("The constructor argument 'propertyEditor' is missing.");
        }
        this.propertyEditor = propertyEditor;
        if (mapper == null) {
            throw new IllegalArgumentException("The constructor argument 'mapper' is missing.");
        }
        this.mapper = mapper;
    }

    @Override
    public void setValue(Object value) {
        this.propertyEditor.setValue(value);
    }

    @Override
    public Object getValue() {
        return this.propertyEditor.getValue();
    }

    @Override
    public boolean isPaintable() {
        return this.propertyEditor.isPaintable();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this.propertyEditor.paintValue(gfx, box);
    }

    @Override
    public String getJavaInitializationString() {
        return this.propertyEditor.getJavaInitializationString();
    }

    @Override
    public String getAsText() {
        String text = this.propertyEditor.getAsText();
        return this.mapper.getTextForValue(text);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String mappedText = this.mapper.getValueForText(text);
        this.propertyEditor.setAsText(mappedText);
    }

    @Override
    public String[] getTags() {
        return this.propertyEditor.getTags();
    }

    @Override
    public Component getCustomEditor() {
        return this.propertyEditor.getCustomEditor();
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.propertyEditor.supportsCustomEditor();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyEditor.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyEditor.removePropertyChangeListener(listener);
    }
}

