/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefanbirkner.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SfbPropertyEditorSupport<T>
implements PropertyEditor {
    private static final String PROPERTY_NAME_FOR_EVENTS = "value";
    private static final String GIBBERISH = "???";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Class<T> supportedType;
    private T value;

    public SfbPropertyEditorSupport(Class<T> supportedType) {
        this.supportedType = supportedType;
    }

    @Override
    public void setValue(Object newValue) {
        this.assertValueHasSupportedType(newValue);
        T oldValue = this.value;
        this.value = newValue;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NAME_FOR_EVENTS, oldValue, newValue);
    }

    private void assertValueHasSupportedType(Object newValue) {
        if (newValue != null && !this.supportedType.isInstance(newValue)) {
            throw new IllegalArgumentException("The value " + newValue + " is not of type " + this.supportedType.getSimpleName() + ".");
        }
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return GIBBERISH;
    }

    @Override
    public String getAsText() {
        return this.value == null ? null : this.value.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        T newValue = this.parseText(text);
        this.setValue(newValue);
    }

    protected abstract T parseText(String var1);

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(PROPERTY_NAME_FOR_EVENTS, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(PROPERTY_NAME_FOR_EVENTS, listener);
    }
}

