/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.statsig.androidsdk.APIDynamicConfig;
import com.statsig.androidsdk.APIFeatureGate;
import com.statsig.androidsdk.Cache;
import com.statsig.androidsdk.DeprecatedStickyUserExperiments;
import com.statsig.androidsdk.DynamicConfig;
import com.statsig.androidsdk.InitializeResponse;
import com.statsig.androidsdk.Layer;
import com.statsig.androidsdk.StatsigClient;
import com.statsig.androidsdk.StatsigOverrides;
import com.statsig.androidsdk.StatsigUtil;
import com.statsig.androidsdk.StickyUserExperiments;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u000bH\u0002J\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u0012\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0016\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&J,\u0010,\u001a\u0004\u0018\u00010\u00122\u0006\u0010-\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020&H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u00100\u001a\u00020\u0003H\u0002J\u001a\u00101\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u00032\b\u00102\u001a\u0004\u0018\u00010\u0012H\u0002J&\u00103\u001a\u00020\u00142\b\u00104\u001a\u0004\u0018\u00010\u00032\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005J\"\u00106\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00032\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005J\u0016\u00108\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u00107\u001a\u00020&J\u0006\u00109\u001a\u00020\u0014J\u000e\u0010:\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0003J\u0010\u0010;\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u000e\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020>R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/statsig/androidsdk/Store;", "", "userID", "", "customIDs", "", "sharedPrefs", "Landroid/content/SharedPreferences;", "(Ljava/lang/String;Ljava/util/Map;Landroid/content/SharedPreferences;)V", "cacheById", "", "Lcom/statsig/androidsdk/Cache;", "currentCache", "gson", "Lcom/google/gson/Gson;", "localOverrides", "Lcom/statsig/androidsdk/StatsigOverrides;", "stickyDeviceExperiments", "Lcom/statsig/androidsdk/APIDynamicConfig;", "attemptToMigrateDeprecatedStickyUserExperiments", "", "attemptToSaveStickyValue", "expName", "latestValue", "cacheStickyValues", "checkGate", "Lcom/statsig/androidsdk/APIFeatureGate;", "gateName", "createEmptyCache", "getAllOverrides", "getConfig", "Lcom/statsig/androidsdk/DynamicConfig;", "configName", "getConfigData", "hashedConfigName", "getExperiment", "experimentName", "keepDeviceValue", "", "getLayer", "Lcom/statsig/androidsdk/Layer;", "client", "Lcom/statsig/androidsdk/StatsigClient;", "layerName", "getPossiblyStickyValue", "name", "isLayer", "getStickyValue", "getUserStorageID", "hydrateDynamicConfig", "config", "loadAndResetForUser", "newUserID", "newCustomIDs", "overrideConfig", "value", "overrideGate", "removeAllOverrides", "removeOverride", "removeStickyValue", "save", "data", "Lcom/statsig/androidsdk/InitializeResponse;", "build_release"})
public final class Store {
    @Nullable
    private String userID;
    @Nullable
    private Map<String, String> customIDs;
    @NotNull
    private final SharedPreferences sharedPrefs;
    @NotNull
    private final Gson gson;
    @NotNull
    private Map<String, Cache> cacheById;
    @NotNull
    private Cache currentCache;
    @NotNull
    private Map<String, APIDynamicConfig> stickyDeviceExperiments;
    @NotNull
    private StatsigOverrides localOverrides;

    public Store(@Nullable String userID, @Nullable Map<String, String> customIDs, @NotNull SharedPreferences sharedPrefs) {
        Cache cache;
        Intrinsics.checkNotNullParameter((Object)sharedPrefs, (String)"sharedPrefs");
        this.userID = userID;
        this.customIDs = customIDs;
        this.sharedPrefs = sharedPrefs;
        this.gson = new Gson();
        String cachedResponse = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER");
        String cachedDeviceValues = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_DEVICE_EXPERIMENTS");
        String cachedLocalOverrides = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES");
        boolean bl = false;
        this.cacheById = new LinkedHashMap();
        if (cachedResponse != null) {
            Type type2 = new TypeToken<Map<String, Cache>>(){}.getType();
            try {
                Map<String, Cache> map = (Map<String, Cache>)this.gson.fromJson(cachedResponse, type2);
                this.cacheById = map == null ? this.cacheById : map;
            }
            catch (Exception _) {
                StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER");
            }
        }
        boolean type2 = false;
        this.stickyDeviceExperiments = new LinkedHashMap();
        if (cachedDeviceValues != null) {
            Type type3 = new TypeToken<Map<String, APIDynamicConfig>>(){}.getType();
            try {
                Map<String, APIDynamicConfig> _ = (Map<String, APIDynamicConfig>)this.gson.fromJson(cachedDeviceValues, type3);
                this.stickyDeviceExperiments = _ == null ? this.stickyDeviceExperiments : _;
            }
            catch (Exception _) {
                StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_DEVICE_EXPERIMENTS");
            }
        }
        type2 = false;
        type2 = false;
        this.localOverrides = new StatsigOverrides(new LinkedHashMap(), new LinkedHashMap());
        if (cachedLocalOverrides != null) {
            try {
                Object type3 = this.gson.fromJson(cachedLocalOverrides, StatsigOverrides.class);
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"gson.fromJson(cachedLocalOverrides, StatsigOverrides::class.java)");
                this.localOverrides = (StatsigOverrides)type3;
            }
            catch (Exception _) {
                StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES");
            }
        }
        this.currentCache = (cache = this.cacheById.get(this.getUserStorageID())) == null ? this.createEmptyCache() : cache;
        this.attemptToMigrateDeprecatedStickyUserExperiments();
    }

    public final void loadAndResetForUser(@Nullable String newUserID, @Nullable Map<String, String> newCustomIDs) {
        this.userID = newUserID;
        this.customIDs = newCustomIDs;
        Cache cache = this.cacheById.get(this.getUserStorageID());
        this.currentCache = cache == null ? this.createEmptyCache() : cache;
    }

    public final void save(@NotNull InitializeResponse data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String storageID = this.getUserStorageID();
        this.currentCache.setValues(data);
        Map<String, Cache> map = this.cacheById;
        Map<String, Cache> map2 = this.currentCache;
        boolean bl = false;
        map.put(storageID, (Cache)((Object)map2));
        String cacheString = this.gson.toJson(this.cacheById);
        if (cacheString.length() / 1024 > 1024 && this.cacheById.size() > 1) {
            boolean bl2 = false;
            this.cacheById = new LinkedHashMap();
            map2 = this.cacheById;
            Cache cache = this.currentCache;
            boolean bl3 = false;
            map2.put(storageID, cache);
            cacheString = this.gson.toJson(this.cacheById);
        }
        map2 = cacheString;
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"cacheString");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER", (String)((Object)map2));
    }

    @NotNull
    public final APIFeatureGate checkGate(@NotNull String gateName) {
        Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
        Boolean overriddenValue = this.localOverrides.getGates().get(gateName);
        if (overriddenValue != null) {
            return new APIFeatureGate(gateName, overriddenValue, "override", null, 8, null);
        }
        String hashName = StatsigUtil.INSTANCE.getHashedString(gateName);
        InitializeResponse values = this.currentCache.getValues();
        if (values.getFeatureGates() == null || !values.getFeatureGates().containsKey(hashName)) {
            return new APIFeatureGate(gateName, false, "", null, 8, null);
        }
        APIFeatureGate aPIFeatureGate = values.getFeatureGates().get(hashName);
        return aPIFeatureGate == null ? new APIFeatureGate(gateName, false, "", null, 8, null) : aPIFeatureGate;
    }

    @NotNull
    public final DynamicConfig getConfig(@NotNull String configName) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Map<String, Object> overrideValue = this.localOverrides.getConfigs().get(configName);
        if (overrideValue != null) {
            return new DynamicConfig(configName, overrideValue, "override", null, false, false, false, null, 248, null);
        }
        String hashName = StatsigUtil.INSTANCE.getHashedString(configName);
        APIDynamicConfig data = this.getConfigData(hashName);
        return this.hydrateDynamicConfig(configName, data);
    }

    private final APIDynamicConfig getConfigData(String hashedConfigName) {
        InitializeResponse values = this.currentCache.getValues();
        if (values.getConfigs() == null || !values.getConfigs().containsKey(hashedConfigName)) {
            return null;
        }
        return values.getConfigs().get(hashedConfigName);
    }

    @NotNull
    public final DynamicConfig getExperiment(@NotNull String experimentName, boolean keepDeviceValue) {
        Intrinsics.checkNotNullParameter((Object)experimentName, (String)"experimentName");
        Map<String, Object> overrideValue = this.localOverrides.getConfigs().get(experimentName);
        if (overrideValue != null) {
            return new DynamicConfig(experimentName, overrideValue, "override", null, false, false, false, null, 248, null);
        }
        String hashName = StatsigUtil.INSTANCE.getHashedString(experimentName);
        Map<String, APIDynamicConfig> map = this.currentCache.getValues().getConfigs();
        APIDynamicConfig latestValue = map == null ? null : map.get(hashName);
        return this.hydrateDynamicConfig(experimentName, this.getPossiblyStickyValue(experimentName, latestValue, keepDeviceValue, false));
    }

    @NotNull
    public final Layer getLayer(@NotNull StatsigClient client, @NotNull String layerName, boolean keepDeviceValue) {
        Object[] objectArray;
        String string;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string2;
        Map map;
        Object object;
        APIDynamicConfig config;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        String hashedLayerName = StatsigUtil.INSTANCE.getHashedString(layerName);
        Map<String, APIDynamicConfig> map2 = this.currentCache.getValues().getLayerConfigs();
        APIDynamicConfig latestValue = map2 == null ? null : map2.get(hashedLayerName);
        APIDynamicConfig aPIDynamicConfig = config = this.getPossiblyStickyValue(layerName, latestValue, keepDeviceValue, true);
        Object object2 = object = aPIDynamicConfig == null ? null : aPIDynamicConfig.getValue();
        if (object == null) {
            boolean bl4 = false;
            map = MapsKt.emptyMap();
        } else {
            map = object;
        }
        object = config;
        String string3 = object == null ? "" : ((string2 = ((APIDynamicConfig)object).getRuleID()) == null ? "" : string2);
        APIDynamicConfig aPIDynamicConfig2 = config;
        object = aPIDynamicConfig2 == null ? null : aPIDynamicConfig2.getSecondaryExposures();
        Object object3 = object == null ? new Map[]{} : object;
        aPIDynamicConfig2 = config;
        object = aPIDynamicConfig2 == null ? null : aPIDynamicConfig2.getUndelegatedSecondaryExposures();
        Object object4 = object == null ? new Map[]{} : object;
        object = config;
        boolean bl5 = object == null ? false : (bl3 = ((APIDynamicConfig)object).isUserInExperiment());
        object = config;
        boolean bl6 = object == null ? false : (bl2 = ((APIDynamicConfig)object).isExperimentActive());
        object = config;
        boolean bl7 = object == null ? false : (bl = ((APIDynamicConfig)object).isDeviceBased());
        object = config;
        String string4 = object == null ? "" : ((string = ((APIDynamicConfig)object).getAllocatedExperimentName()) == null ? "" : string);
        object = config;
        return new Layer(client, layerName, map, string3, (Map<String, String>[])object3, (Map<String, String>[])object4, bl5, bl6, bl7, string4, object == null ? null : ((objectArray = ((APIDynamicConfig)object).getExplicitParameters()) == null ? null : ArraysKt.toSet((Object[])objectArray)));
    }

    public static /* synthetic */ Layer getLayer$default(Store store, StatsigClient statsigClient, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return store.getLayer(statsigClient, string, bl);
    }

    private final APIDynamicConfig getPossiblyStickyValue(String name, APIDynamicConfig latestValue, boolean keepDeviceValue, boolean isLayer) {
        APIDynamicConfig aPIDynamicConfig;
        if (!keepDeviceValue) {
            this.removeStickyValue(name);
            return latestValue;
        }
        APIDynamicConfig stickyValue = this.getStickyValue(name);
        if (stickyValue == null) {
            this.attemptToSaveStickyValue(name, latestValue);
            return latestValue;
        }
        APIDynamicConfig latestExperimentValue = null;
        if (isLayer) {
            aPIDynamicConfig = stickyValue;
            String string = aPIDynamicConfig.getAllocatedExperimentName();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                Map<String, APIDynamicConfig> map = this.currentCache.getValues().getConfigs();
                latestExperimentValue = map == null ? null : map.get(it);
            }
        } else {
            latestExperimentValue = latestValue;
        }
        aPIDynamicConfig = latestExperimentValue;
        if (Intrinsics.areEqual((Object)(aPIDynamicConfig == null ? null : Boolean.valueOf(aPIDynamicConfig.isExperimentActive())), (Object)true)) {
            return stickyValue;
        }
        aPIDynamicConfig = latestValue;
        if (Intrinsics.areEqual((Object)(aPIDynamicConfig == null ? null : Boolean.valueOf(aPIDynamicConfig.isExperimentActive())), (Object)true)) {
            this.attemptToSaveStickyValue(name, latestValue);
        } else {
            this.removeStickyValue(name);
        }
        return latestValue;
    }

    public final void overrideGate(@NotNull String gateName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
        Object object = this.localOverrides.getGates();
        Boolean bl = value;
        boolean bl2 = false;
        object.put((String)gateName, (Boolean)bl);
        object = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", (String)object);
    }

    public final void overrideConfig(@NotNull String configName, @NotNull Map<String, ? extends Object> value) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object object = this.localOverrides.getConfigs();
        boolean bl = false;
        object.put((String)configName, value);
        object = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", (String)object);
    }

    public final void removeOverride(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.localOverrides.getConfigs().remove(name);
        this.localOverrides.getGates().remove(name);
        String string = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", string);
    }

    public final void removeAllOverrides() {
        boolean bl = false;
        bl = false;
        this.localOverrides = new StatsigOverrides(new LinkedHashMap(), new LinkedHashMap());
        String string = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", string);
    }

    @NotNull
    public final StatsigOverrides getAllOverrides() {
        return new StatsigOverrides(this.localOverrides.getGates(), this.localOverrides.getConfigs());
    }

    private final DynamicConfig hydrateDynamicConfig(String name, APIDynamicConfig config) {
        String string;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string2;
        Map map;
        Object object;
        APIDynamicConfig aPIDynamicConfig = config;
        Object object2 = object = aPIDynamicConfig == null ? null : aPIDynamicConfig.getValue();
        if (object == null) {
            boolean bl4 = false;
            map = MapsKt.emptyMap();
        } else {
            map = object;
        }
        object = config;
        String string3 = object == null ? "" : ((string2 = ((APIDynamicConfig)object).getRuleID()) == null ? "" : string2);
        APIDynamicConfig aPIDynamicConfig2 = config;
        object = aPIDynamicConfig2 == null ? null : aPIDynamicConfig2.getSecondaryExposures();
        Object object3 = object == null ? new Map[]{} : object;
        object = config;
        boolean bl5 = object == null ? false : (bl3 = ((APIDynamicConfig)object).isUserInExperiment());
        object = config;
        boolean bl6 = object == null ? false : (bl2 = ((APIDynamicConfig)object).isExperimentActive());
        object = config;
        boolean bl7 = object == null ? false : (bl = ((APIDynamicConfig)object).isDeviceBased());
        object = config;
        return new DynamicConfig(name, map, string3, (Map<String, String>[])object3, bl5, bl6, bl7, object == null ? "" : ((string = ((APIDynamicConfig)object).getAllocatedExperimentName()) == null ? "" : string));
    }

    private final Cache createEmptyCache() {
        boolean bl = false;
        bl = false;
        bl = false;
        InitializeResponse emptyInitResponse = new InitializeResponse(MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), false, 0L);
        boolean bl2 = false;
        StickyUserExperiments emptyStickyUserExperiments = new StickyUserExperiments(new LinkedHashMap());
        return new Cache(emptyInitResponse, emptyStickyUserExperiments);
    }

    private final void removeStickyValue(String expName) {
        String expNameHash = StatsigUtil.INSTANCE.getHashedString(expName);
        this.currentCache.getStickyUserExperiments().getExperiments().remove(expNameHash);
        this.stickyDeviceExperiments.remove(expNameHash);
        this.cacheStickyValues();
    }

    private final void attemptToSaveStickyValue(String expName, APIDynamicConfig latestValue) {
        if (latestValue == null) {
            return;
        }
        String expNameHash = StatsigUtil.INSTANCE.getHashedString(expName);
        if (latestValue.isExperimentActive() && latestValue.isUserInExperiment()) {
            if (latestValue.isDeviceBased()) {
                Map<String, APIDynamicConfig> map = this.stickyDeviceExperiments;
                boolean bl = false;
                map.put(expNameHash, latestValue);
            } else {
                Map<String, APIDynamicConfig> map = this.currentCache.getStickyUserExperiments().getExperiments();
                boolean bl = false;
                map.put(expNameHash, latestValue);
            }
            this.cacheStickyValues();
        }
    }

    private final APIDynamicConfig getStickyValue(String expName) {
        String hashName = StatsigUtil.INSTANCE.getHashedString(expName);
        APIDynamicConfig aPIDynamicConfig = this.currentCache.getStickyUserExperiments().getExperiments().get(hashName);
        return aPIDynamicConfig == null ? this.stickyDeviceExperiments.get(hashName) : aPIDynamicConfig;
    }

    private final void cacheStickyValues() {
        String string = this.gson.toJson(this.cacheById);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(cacheById)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER", string);
        string = this.gson.toJson(this.stickyDeviceExperiments);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(stickyDeviceExperiments)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_DEVICE_EXPERIMENTS", string);
    }

    private final void attemptToMigrateDeprecatedStickyUserExperiments() {
        String string = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_USER_EXPERIMENTS");
        if (string == null) {
            return;
        }
        String oldStickyUserExperimentValues = string;
        StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_USER_EXPERIMENTS");
        try {
            DeprecatedStickyUserExperiments stickyUserExperiments;
            block7: {
                block6: {
                    stickyUserExperiments = (DeprecatedStickyUserExperiments)this.gson.fromJson(oldStickyUserExperimentValues, DeprecatedStickyUserExperiments.class);
                    if (!Intrinsics.areEqual((Object)stickyUserExperiments.getUserID(), (Object)this.userID)) break block6;
                    Map<String, APIDynamicConfig> map = this.currentCache.getStickyUserExperiments().getExperiments();
                    boolean bl = false;
                    if (!(!map.isEmpty())) break block7;
                }
                return;
            }
            this.currentCache.setStickyUserExperiments(new StickyUserExperiments(stickyUserExperiments.getExperiments()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String getUserStorageID() {
        String string = this.userID;
        String id = string == null ? "Statsig.NULL_USER" : string;
        Map<String, String> map = this.customIDs;
        if (map == null) {
            return id;
        }
        Map<String, String> customIds = map;
        Object object = customIds;
        boolean bl = false;
        map = object.entrySet().iterator();
        while (map.hasNext()) {
            Object object2 = object = (Map.Entry)map.next();
            boolean bl2 = false;
            String k = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String v = (String)object3.getValue();
            id = id + k + ':' + v;
        }
        return id;
    }
}

