/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.app.Activity;
import android.app.Application;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.google.gson.Gson;
import com.statsig.androidsdk.APIFeatureGate;
import com.statsig.androidsdk.DynamicConfig;
import com.statsig.androidsdk.IStatsigCallback;
import com.statsig.androidsdk.InitializeResponse;
import com.statsig.androidsdk.LogEvent;
import com.statsig.androidsdk.Statsig;
import com.statsig.androidsdk.StatsigId;
import com.statsig.androidsdk.StatsigLogger;
import com.statsig.androidsdk.StatsigMetadata;
import com.statsig.androidsdk.StatsigNetwork;
import com.statsig.androidsdk.StatsigOptions;
import com.statsig.androidsdk.StatsigState;
import com.statsig.androidsdk.StatsigUser;
import com.statsig.androidsdk.StatsigUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/statsig/androidsdk/Statsig;", "", "()V", "Companion", "build_release"})
public final class Statsig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SHARED_PREFERENCES_KEY = "com.statsig.androidsdk";
    @NotNull
    private static final String INITIALIZE_RESPONSE_KEY = "Statsig.INITIALIZE_RESPONSE";
    @Nullable
    private static StatsigState state;
    @Nullable
    private static StatsigUser user;
    @Nullable
    private static Job pollingJob;
    private static Application application;
    private static String sdkKey;
    private static StatsigOptions options;
    private static Companion.StatsigActivityLifecycleListener lifecycleListener;
    private static StatsigLogger logger;
    private static StatsigMetadata statsigMetadata;

    @JvmStatic
    @JvmOverloads
    public static final void initializeAsync(@NotNull Application application, @NotNull String sdkKey, @Nullable StatsigUser user, @Nullable IStatsigCallback callback, @NotNull StatsigOptions options) {
        Companion.initializeAsync(application, sdkKey, user, callback, options);
    }

    @JvmStatic
    public static final boolean checkGate(@NotNull String gateName) {
        return Companion.checkGate(gateName);
    }

    @JvmStatic
    @NotNull
    public static final DynamicConfig getConfig(@NotNull String configName) {
        return Companion.getConfig(configName);
    }

    @JvmStatic
    @NotNull
    public static final DynamicConfig getExperiment(@NotNull String experimentName) {
        return Companion.getExperiment(experimentName);
    }

    @JvmStatic
    @JvmOverloads
    public static final void logEvent(@NotNull String eventName, @Nullable Double value, @Nullable Map<String, String> metadata) {
        Companion.logEvent(eventName, value, metadata);
    }

    @JvmStatic
    public static final void logEvent(@NotNull String eventName, @NotNull String value, @Nullable Map<String, String> metadata) {
        Companion.logEvent(eventName, value, metadata);
    }

    @JvmStatic
    public static final void logEvent(@NotNull String eventName, @NotNull Map<String, String> metadata) {
        Companion.logEvent(eventName, metadata);
    }

    @JvmStatic
    public static final void updateUserAsync(@Nullable StatsigUser user, @Nullable IStatsigCallback callback) {
        Companion.updateUserAsync(user, callback);
    }

    @JvmStatic
    public static final void shutdown() {
        Companion.shutdown();
    }

    @JvmStatic
    @JvmOverloads
    public static final void initializeAsync(@NotNull Application application, @NotNull String sdkKey, @Nullable StatsigUser user, @Nullable IStatsigCallback callback) {
        Companion.initializeAsync(application, sdkKey, user, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initializeAsync(@NotNull Application application, @NotNull String sdkKey, @Nullable StatsigUser user) {
        Companion.initializeAsync(application, sdkKey, user);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initializeAsync(@NotNull Application application, @NotNull String sdkKey) {
        Companion.initializeAsync(application, sdkKey);
    }

    @JvmStatic
    @JvmOverloads
    public static final void logEvent(@NotNull String eventName, @Nullable Double value) {
        Companion.logEvent(eventName, value);
    }

    @JvmStatic
    @JvmOverloads
    public static final void logEvent(@NotNull String eventName) {
        Companion.logEvent(eventName);
    }

    public static final /* synthetic */ void access$setApplication$cp(Application application) {
        Statsig.application = application;
    }

    public static final /* synthetic */ void access$setSdkKey$cp(String string) {
        sdkKey = string;
    }

    public static final /* synthetic */ void access$setOptions$cp(StatsigOptions statsigOptions) {
        options = statsigOptions;
    }

    public static final /* synthetic */ void access$setUser$cp(StatsigUser statsigUser) {
        user = statsigUser;
    }

    public static final /* synthetic */ void access$setStatsigMetadata$cp(StatsigMetadata statsigMetadata) {
        Statsig.statsigMetadata = statsigMetadata;
    }

    public static final /* synthetic */ void access$setLifecycleListener$cp(Companion.StatsigActivityLifecycleListener statsigActivityLifecycleListener) {
        lifecycleListener = statsigActivityLifecycleListener;
    }

    public static final /* synthetic */ void access$setLogger$cp(StatsigLogger statsigLogger) {
        logger = statsigLogger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001>B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J7\u0010%\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\f\u001a\u00020\rH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J:\u0010'\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\b\u0010*\u001a\u00020\u001bH\u0002J9\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u00042\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\u0016\b\u0002\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u000100H\u0007\u00a2\u0006\u0002\u00101J0\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0016\b\u0002\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u000100H\u0007J$\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u00042\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000400H\u0007J\u0014\u00102\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u00103\u001a\u00020\u001bH\u0002J\b\u00104\u001a\u00020\u001bH\u0002J\u0010\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u000207H\u0002J\u0012\u00108\u001a\u00020\u001b2\b\u00109\u001a\u0004\u0018\u000107H\u0002J\b\u0010:\u001a\u00020\u001bH\u0007J\u001b\u0010;\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u001e\u0010=\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"Lcom/statsig/androidsdk/Statsig$Companion;", "", "()V", "INITIALIZE_RESPONSE_KEY", "", "SHARED_PREFERENCES_KEY", "application", "Landroid/app/Application;", "lifecycleListener", "Lcom/statsig/androidsdk/Statsig$Companion$StatsigActivityLifecycleListener;", "logger", "Lcom/statsig/androidsdk/StatsigLogger;", "options", "Lcom/statsig/androidsdk/StatsigOptions;", "pollingJob", "Lkotlinx/coroutines/Job;", "sdkKey", "state", "Lcom/statsig/androidsdk/StatsigState;", "statsigMetadata", "Lcom/statsig/androidsdk/StatsigMetadata;", "user", "Lcom/statsig/androidsdk/StatsigUser;", "checkGate", "", "gateName", "clearCache", "", "enforceInitialized", "functionName", "getConfig", "Lcom/statsig/androidsdk/DynamicConfig;", "configName", "getExperiment", "experimentName", "getSharedPrefs", "Landroid/content/SharedPreferences;", "initialize", "(Landroid/app/Application;Ljava/lang/String;Lcom/statsig/androidsdk/StatsigUser;Lcom/statsig/androidsdk/StatsigOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeAsync", "callback", "Lcom/statsig/androidsdk/IStatsigCallback;", "loadFromCache", "logEvent", "eventName", "value", "", "metadata", "", "(Ljava/lang/String;Ljava/lang/Double;Ljava/util/Map;)V", "normalizeUser", "pollForUpdates", "populateStatsigMetadata", "saveToCache", "initializeData", "Lcom/statsig/androidsdk/InitializeResponse;", "setState", "result", "shutdown", "updateUser", "(Lcom/statsig/androidsdk/StatsigUser;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateUserAsync", "StatsigActivityLifecycleListener", "build_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void initializeAsync(@NotNull Application application, @NotNull String sdkKey, @Nullable StatsigUser user, @Nullable IStatsigCallback callback, @NotNull StatsigOptions options) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(callback, application, sdkKey, user, options, null){
                int label;
                final /* synthetic */ IStatsigCallback $callback;
                final /* synthetic */ Application $application;
                final /* synthetic */ String $sdkKey;
                final /* synthetic */ StatsigUser $user;
                final /* synthetic */ StatsigOptions $options;
                {
                    this.$callback = $callback;
                    this.$application = $application;
                    this.$sdkKey = $sdkKey;
                    this.$user = $user;
                    this.$options = $options;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$application, this.$sdkKey, this.$user, this.$options, null){
                                int label;
                                final /* synthetic */ Application $application;
                                final /* synthetic */ String $sdkKey;
                                final /* synthetic */ StatsigUser $user;
                                final /* synthetic */ StatsigOptions $options;
                                {
                                    this.$application = $application;
                                    this.$sdkKey = $sdkKey;
                                    this.$user = $user;
                                    this.$options = $options;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = Statsig.Companion.initialize(this.$application, this.$sdkKey, this.$user, this.$options, (Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null);
                            if (this.$callback != null) {
                                this.$callback.getStatsigHandler().post(() -> initializeAsync.1.invokeSuspend$lambda-0(this.$callback));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda-0(IStatsigCallback $callback) {
                    $callback.onStatsigInitialize();
                }
            }), (int)3, null);
        }

        public static /* synthetic */ void initializeAsync$default(Companion companion, Application application, String string, StatsigUser statsigUser, IStatsigCallback iStatsigCallback, StatsigOptions statsigOptions, int n, Object object) {
            if ((n & 4) != 0) {
                statsigUser = null;
            }
            if ((n & 8) != 0) {
                iStatsigCallback = null;
            }
            if ((n & 0x10) != 0) {
                statsigOptions = new StatsigOptions(null, false, 0L, 7, null);
            }
            companion.initializeAsync(application, string, statsigUser, iStatsigCallback, statsigOptions);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final Object initialize(@NotNull Application var1_1, @NotNull String var2_2, @Nullable StatsigUser var3_3, @NotNull StatsigOptions var4_4, @NotNull Continuation<? super Unit> var5_5) {
            if (!(var5_5 instanceof initialize.1)) ** GOTO lbl-1000
            var11_6 = var5_5;
            if ((var11_6.label & -2147483648) != 0) {
                var11_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_5){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.initialize(null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var12_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!StringsKt.startsWith$default((String)sdkKey, (String)"client-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)sdkKey, (String)"test-", (boolean)false, (int)2, null)) {
                        throw new IllegalArgumentException("Invalid SDK Key provided.  You must provide a client SDK Key from the API Key page of your Statsig console");
                    }
                    if (Statsig.access$getSdkKey$cp() != null) {
                        return Unit.INSTANCE;
                    }
                    Statsig.access$setApplication$cp((Application)application);
                    Statsig.access$setSdkKey$cp((String)sdkKey);
                    Statsig.access$setOptions$cp((StatsigOptions)options);
                    Statsig.access$setUser$cp(this.normalizeUser((StatsigUser)user));
                    Statsig.access$setStatsigMetadata$cp(new StatsigMetadata(null, null, null, null, null, null, null, null, null, null, null, 2047, null));
                    this.populateStatsigMetadata();
                    Statsig.access$setLifecycleListener$cp(new StatsigActivityLifecycleListener());
                    var6_9 /* !! */  = Statsig.access$getApplication$cp();
                    if (var6_9 /* !! */  == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                        throw null;
                    }
                    v0 = var6_9 /* !! */ ;
                    var6_9 /* !! */  = Statsig.access$getLifecycleListener$cp();
                    if (var6_9 /* !! */  == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleListener");
                        throw null;
                    }
                    v0.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)var6_9 /* !! */ );
                    sharedPrefs = this.getSharedPrefs();
                    var7_10 = Statsig.access$getOptions$cp();
                    if (var7_10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        throw null;
                    }
                    v1 = var7_10.getApi();
                    var7_10 = Statsig.access$getStatsigMetadata$cp();
                    if (var7_10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                        throw null;
                    }
                    Statsig.access$setLogger$cp(new StatsigLogger((String)sdkKey, v1, (StatsigMetadata)var7_10, sharedPrefs));
                    this.loadFromCache();
                    var8_11 = Statsig.access$getOptions$cp();
                    if (var8_11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        throw null;
                    }
                    v2 = var8_11.getApi();
                    var8_11 = Statsig.access$getStatsigMetadata$cp();
                    if (var8_11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                        throw null;
                    }
                    v3 = var8_11;
                    var8_11 = Statsig.access$getOptions$cp();
                    if (var8_11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        throw null;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = sdkKey;
                    $continuation.L$2 = sharedPrefs;
                    $continuation.label = 1;
                    v4 = StatsigNetwork.Companion.initialize(v2, (String)sdkKey, (StatsigUser)user, (StatsigMetadata)v3, var8_11.getInitTimeoutMs(), (Continuation<? super InitializeResponse>)$continuation);
                    if (v4 == var12_8) {
                        return var12_8;
                    }
                    ** GOTO lbl73
                }
                case 1: {
                    var6_9 /* !! */  = (SharedPreferences)$continuation.L$2;
                    var2_2 = (String)$continuation.L$1;
                    this = (Companion)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl73:
                    // 2 sources

                    initResponse = (InitializeResponse)v4;
                    instance = this;
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(instance, initResponse, null){
                        int label;
                        final /* synthetic */ Companion $instance;
                        final /* synthetic */ InitializeResponse $initResponse;
                        {
                            this.$instance = $instance;
                            this.$initResponse = $initResponse;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    com.statsig.androidsdk.Statsig$Companion.access$setState(this.$instance, this.$initResponse);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                    instance.pollForUpdates();
                    if (var6_9 /* !! */  != null) {
                        var9_12 = Statsig.access$getOptions$cp();
                        if (var9_12 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                            throw null;
                        }
                        StatsigNetwork.Companion.apiRetryFailedLogs(var9_12.getApi(), var2_2, var6_9 /* !! */ );
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static /* synthetic */ Object initialize$default(Companion companion, Application application, String string, StatsigUser statsigUser, StatsigOptions statsigOptions, Continuation continuation, int n, Object object) {
            if ((n & 4) != 0) {
                statsigUser = null;
            }
            if ((n & 8) != 0) {
                statsigOptions = new StatsigOptions(null, false, 0L, 7, null);
            }
            return companion.initialize(application, string, statsigUser, statsigOptions, (Continuation<? super Unit>)continuation);
        }

        @JvmStatic
        public final boolean checkGate(@NotNull String gateName) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
            this.enforceInitialized("checkGate");
            APIFeatureGate res = new APIFeatureGate(gateName, false, null, 6, null);
            if (state != null) {
                object = state;
                Intrinsics.checkNotNull((Object)object);
                res = ((StatsigState)object).checkGate(StatsigUtil.INSTANCE.getHashedString(gateName));
            }
            if ((object = logger) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                throw null;
            }
            ((StatsigLogger)object).logGateExposure(gateName, res.getValue(), res.getRuleID(), user);
            return res.getValue();
        }

        @JvmStatic
        @NotNull
        public final DynamicConfig getConfig(@NotNull String configName) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
            this.enforceInitialized("getConfig");
            DynamicConfig res = new DynamicConfig(configName, null, null, 6, null);
            if (state != null) {
                object = state;
                Intrinsics.checkNotNull((Object)object);
                res = ((StatsigState)object).getConfig(StatsigUtil.INSTANCE.getHashedString(configName));
            }
            if ((object = logger) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                throw null;
            }
            ((StatsigLogger)object).logConfigExposure(configName, res.getRuleID(), user);
            return res;
        }

        @JvmStatic
        @NotNull
        public final DynamicConfig getExperiment(@NotNull String experimentName) {
            Intrinsics.checkNotNullParameter((Object)experimentName, (String)"experimentName");
            this.enforceInitialized("getExperiment");
            return this.getConfig(experimentName);
        }

        @JvmStatic
        @JvmOverloads
        public final void logEvent(@NotNull String eventName, @Nullable Double value, @Nullable Map<String, String> metadata) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            this.enforceInitialized("logEvent");
            if (state == null) {
                return;
            }
            LogEvent event = new LogEvent(eventName);
            event.setValue(value);
            event.setMetadata(metadata);
            event.setUser(user);
            Object object = options;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                throw null;
            }
            if (!((StatsigOptions)object).getDisableCurrentActivityLogging()) {
                String className;
                Object object2 = lifecycleListener;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleListener");
                    throw null;
                }
                Activity activity = ((StatsigActivityLifecycleListener)object2).getCurrentActivity();
                String string = activity == null ? null : (className = (object2 = activity.getClass()) == null ? null : ((Class)object2).getSimpleName());
                if (className != null) {
                    event.setStatsigMetadata(MapsKt.mapOf((Pair)TuplesKt.to((Object)"currentPage", (Object)className)));
                }
            }
            if ((object = logger) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                throw null;
            }
            ((StatsigLogger)object).log(event);
        }

        public static /* synthetic */ void logEvent$default(Companion companion, String string, Double d, Map map, int n, Object object) {
            if ((n & 2) != 0) {
                d = null;
            }
            if ((n & 4) != 0) {
                map = null;
            }
            companion.logEvent(string, d, (Map<String, String>)map);
        }

        @JvmStatic
        public final void logEvent(@NotNull String eventName, @NotNull String value, @Nullable Map<String, String> metadata) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.enforceInitialized("logEvent");
            if (state == null) {
                return;
            }
            LogEvent event = new LogEvent(eventName);
            event.setValue(value);
            event.setMetadata(metadata);
            event.setUser(user);
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                throw null;
            }
            statsigLogger.log(event);
        }

        public static /* synthetic */ void logEvent$default(Companion companion, String string, String string2, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            companion.logEvent(string, string2, (Map<String, String>)map);
        }

        @JvmStatic
        public final void logEvent(@NotNull String eventName, @NotNull Map<String, String> metadata) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
            this.enforceInitialized("logEvent");
            if (state == null) {
                return;
            }
            LogEvent event = new LogEvent(eventName);
            event.setValue(null);
            event.setMetadata(metadata);
            event.setUser(user);
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                throw null;
            }
            statsigLogger.log(event);
        }

        @JvmStatic
        public final void updateUserAsync(@Nullable StatsigUser user, @Nullable IStatsigCallback callback) {
            BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(callback, user, null){
                int label;
                final /* synthetic */ IStatsigCallback $callback;
                final /* synthetic */ StatsigUser $user;
                {
                    this.$callback = $callback;
                    this.$user = $user;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$user, null){
                                int label;
                                final /* synthetic */ StatsigUser $user;
                                {
                                    this.$user = $user;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = Statsig.Companion.updateUser(this.$user, (Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null);
                            if (this.$callback != null) {
                                this.$callback.getStatsigHandler().post(() -> updateUserAsync.1.invokeSuspend$lambda-0(this.$callback));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda-0(IStatsigCallback $callback) {
                    $callback.onStatsigUpdateUser();
                }
            }), (int)3, null);
        }

        public static /* synthetic */ void updateUserAsync$default(Companion companion, StatsigUser statsigUser, IStatsigCallback iStatsigCallback, int n, Object object) {
            if ((n & 2) != 0) {
                iStatsigCallback = null;
            }
            companion.updateUserAsync(statsigUser, iStatsigCallback);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object updateUser(@Nullable StatsigUser var1_1, @NotNull Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof updateUser.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.updateUser(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this.enforceInitialized("updateUser");
                    var3_6 = Statsig.access$getPollingJob$cp();
                    if (var3_6 != null) {
                        Job.DefaultImpls.cancel$default((Job)var3_6, null, (int)1, null);
                    }
                    this.clearCache();
                    Statsig.access$setState$cp(null);
                    var3_6 = Statsig.access$getUser$cp();
                    v0 = var3_6 == null ? null : var3_6.getUserID();
                    var3_6 = user;
                    if (v0 != (var3_6 == null ? null : var3_6.getUserID())) {
                        var3_6 = Statsig.access$getStatsigMetadata$cp();
                        if (var3_6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                            throw null;
                        }
                        var3_6.setStableID(StatsigId.Companion.getNewStableID(this.getSharedPrefs()));
                        var3_6 = Statsig.access$getLogger$cp();
                        if (var3_6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                            throw null;
                        }
                        var3_6.onUpdateUser();
                    } else {
                        var3_6 = Statsig.access$getLogger$cp();
                        if (var3_6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                            throw null;
                        }
                        var3_6.flush();
                    }
                    Statsig.access$setUser$cp((StatsigUser)user);
                    var3_6 = Statsig.access$getStatsigMetadata$cp();
                    if (var3_6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                        throw null;
                    }
                    var3_6.setSessionID(StatsigId.Companion.getNewSessionID());
                    var4_7 = Statsig.access$getOptions$cp();
                    if (var4_7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        throw null;
                    }
                    v1 = var4_7.getApi();
                    var4_7 = Statsig.access$getSdkKey$cp();
                    if (var4_7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"sdkKey");
                        throw null;
                    }
                    v2 = var4_7;
                    var4_7 = Statsig.access$getStatsigMetadata$cp();
                    if (var4_7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                        throw null;
                    }
                    v3 = var4_7;
                    var4_7 = Statsig.access$getOptions$cp();
                    if (var4_7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        throw null;
                    }
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v4 = StatsigNetwork.Companion.initialize(v1, (String)v2, Statsig.access$getUser$cp(), (StatsigMetadata)v3, var4_7.getInitTimeoutMs(), (Continuation<? super InitializeResponse>)$continuation);
                    if (v4 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl73
                }
                case 1: {
                    this = (Companion)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl73:
                    // 2 sources

                    initResponse = (InitializeResponse)v4;
                    instance = this;
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(instance, initResponse, null){
                        int label;
                        final /* synthetic */ Companion $instance;
                        final /* synthetic */ InitializeResponse $initResponse;
                        {
                            this.$instance = $instance;
                            this.$initResponse = $initResponse;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    com.statsig.androidsdk.Statsig$Companion.access$setState(this.$instance, this.$initResponse);
                                    com.statsig.androidsdk.Statsig$Companion.access$pollForUpdates(this.$instance);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @JvmStatic
        public final void shutdown() {
            this.enforceInitialized("shutdown");
            Object object = pollingJob;
            if (object != null) {
                Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
            }
            object = logger;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                throw null;
            }
            ((StatsigLogger)object).flush();
        }

        private final void enforceInitialized(String functionName) {
            if (sdkKey == null) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"The SDK must be initialized prior to invoking ", (Object)functionName));
            }
        }

        private final StatsigUser normalizeUser(StatsigUser user) {
            StatsigUser normalizedUser = user;
            Object object = options;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                throw null;
            }
            if (((StatsigOptions)object).getEnvironment() != null && user == null) {
                normalizedUser = new StatsigUser("");
            }
            if ((object = normalizedUser) != null) {
                StatsigOptions statsigOptions = options;
                if (statsigOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    throw null;
                }
                ((StatsigUser)object).setStatsigEnvironment$build_release(statsigOptions.getEnvironment());
            }
            return normalizedUser;
        }

        private final void pollForUpdates() {
            Object object = options;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                throw null;
            }
            String string = ((StatsigOptions)object).getApi();
            object = sdkKey;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkKey");
                throw null;
            }
            Object object2 = object;
            object = statsigMetadata;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                throw null;
            }
            pollingJob = StatsigNetwork.Companion.pollForChanges(string, (String)object2, user, (StatsigMetadata)object, (Function1<? super InitializeResponse, Unit>)((Function1)new Function1<InitializeResponse, Unit>(this){

                public final void invoke(@Nullable InitializeResponse p0) {
                    com.statsig.androidsdk.Statsig$Companion.access$setState((Companion)this.receiver, p0);
                }
            }));
        }

        private final void populateStatsigMetadata() {
            Integer stringID;
            StatsigMetadata statsigMetadata = statsigMetadata;
            if (statsigMetadata == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                throw null;
            }
            statsigMetadata.setStableID(StatsigId.Companion.getStableID(this.getSharedPrefs()));
            Object object = application;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                throw null;
            }
            ApplicationInfo applicationInfo = object.getApplicationInfo();
            Integer n = stringID = applicationInfo == null ? null : Integer.valueOf(applicationInfo.labelRes);
            if (stringID != null) {
                boolean bl = false;
                if (stringID == 0) {
                    applicationInfo = application;
                    if (applicationInfo == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                        throw null;
                    }
                    ((Object)applicationInfo.getApplicationInfo().nonLocalizedLabel).toString();
                } else {
                    applicationInfo = application;
                    if (applicationInfo == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                        throw null;
                    }
                    applicationInfo.getString(stringID.intValue());
                }
            }
            try {
                applicationInfo = application;
                if (applicationInfo == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                    throw null;
                }
                if (applicationInfo.getPackageManager() != null) {
                    Application application = application;
                    if (application == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                        throw null;
                    }
                    PackageManager packageManager = application.getPackageManager();
                    application = application;
                    if (application == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                        throw null;
                    }
                    object = packageManager.getPackageInfo(application.getPackageName(), 0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"application.packageManager.getPackageInfo(application.packageName, 0)");
                    Application pInfo = object;
                    object = statsigMetadata;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                        throw null;
                    }
                    ((StatsigMetadata)object).setAppVersion(pInfo.versionName);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }

        private final void loadFromCache() {
            String string;
            SharedPreferences sharedPrefs = this.getSharedPrefs();
            if (sharedPrefs == null) {
                return;
            }
            String string2 = sharedPrefs.getString(Statsig.INITIALIZE_RESPONSE_KEY, null);
            if (string2 == null) {
                return;
            }
            String cachedResponse = string = string2;
            InitializeResponse json = (InitializeResponse)new Gson().fromJson(cachedResponse, InitializeResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            state = new StatsigState(json);
        }

        private final void saveToCache(InitializeResponse initializeData) {
            SharedPreferences sharedPrefs = this.getSharedPrefs();
            if (sharedPrefs == null) {
                return;
            }
            String json = new Gson().toJson((Object)initializeData);
            sharedPrefs.edit().putString(Statsig.INITIALIZE_RESPONSE_KEY, json).apply();
        }

        private final void clearCache() {
            SharedPreferences sharedPrefs = this.getSharedPrefs();
            if (sharedPrefs == null) {
                return;
            }
            sharedPrefs.edit().remove(Statsig.INITIALIZE_RESPONSE_KEY).apply();
        }

        private final void setState(InitializeResponse result) {
            if (result != null && result.getHasUpdates()) {
                state = new StatsigState(result);
                this.saveToCache(result);
            }
        }

        private final SharedPreferences getSharedPrefs() {
            Application application = application;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
                throw null;
            }
            return application.getSharedPreferences(Statsig.SHARED_PREFERENCES_KEY, 0);
        }

        @JvmStatic
        @JvmOverloads
        public final void initializeAsync(@NotNull Application application, @NotNull String sdkKey, @Nullable StatsigUser user, @Nullable IStatsigCallback callback) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
            com.statsig.androidsdk.Statsig$Companion.initializeAsync$default(this, application, sdkKey, user, callback, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void initializeAsync(@NotNull Application application, @NotNull String sdkKey, @Nullable StatsigUser user) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
            com.statsig.androidsdk.Statsig$Companion.initializeAsync$default(this, application, sdkKey, user, null, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void initializeAsync(@NotNull Application application, @NotNull String sdkKey) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
            com.statsig.androidsdk.Statsig$Companion.initializeAsync$default(this, application, sdkKey, null, null, null, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void logEvent(@NotNull String eventName, @Nullable Double value) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            com.statsig.androidsdk.Statsig$Companion.logEvent$default(this, eventName, value, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void logEvent(@NotNull String eventName) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            com.statsig.androidsdk.Statsig$Companion.logEvent$default(this, eventName, null, null, 6, null);
        }

        public static final /* synthetic */ void access$setState(Companion $this, InitializeResponse result) {
            $this.setState(result);
        }

        public static final /* synthetic */ void access$pollForUpdates(Companion $this) {
            $this.pollForUpdates();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/statsig/androidsdk/Statsig$Companion$StatsigActivityLifecycleListener;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "currentActivity", "Landroid/app/Activity;", "getCurrentActivity", "()Landroid/app/Activity;", "setCurrentActivity", "(Landroid/app/Activity;)V", "onActivityCreated", "", "activity", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "build_release"})
        private static final class StatsigActivityLifecycleListener
        implements Application.ActivityLifecycleCallbacks {
            @Nullable
            private Activity currentActivity;

            @Nullable
            public final Activity getCurrentActivity() {
                return this.currentActivity;
            }

            public final void setCurrentActivity(@Nullable Activity activity) {
                this.currentActivity = activity;
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.currentActivity = activity;
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.currentActivity = activity;
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.currentActivity = activity;
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.currentActivity = null;
                Companion.shutdown();
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.currentActivity = null;
            }
        }
    }
}

