/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk.evaluator;

import com.statsig.androidsdk.ErrorBoundary;
import com.statsig.androidsdk.Statsig;
import com.statsig.androidsdk.StatsigUser;
import com.statsig.androidsdk.evaluator.ConfigEvaluation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u000426\u0010\u0005\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\"\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\fJ\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001JR\u0010#\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010$\u001a\u0004\u0018\u00010\u000126\u0010\u0005\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\f0\u0006J\u0014\u0010%\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0017\u00a8\u0006*"}, d2={"Lcom/statsig/androidsdk/evaluator/EvaluatorUtils;", "", "()V", "compareDates", "Lcom/statsig/androidsdk/evaluator/ConfigEvaluation;", "compare", "Lkotlin/Function2;", "Ljava/util/Date;", "Lkotlin/ParameterName;", "name", "a", "b", "", "contains", "targets", "value", "ignoreCase", "getDate", "input", "getEpoch", "", "(Ljava/lang/Object;)Ljava/lang/Long;", "getFromEnvironment", "", "user", "Lcom/statsig/androidsdk/StatsigUser;", "field", "getFromUser", "getUnitID", "idType", "getUserValueForField", "getValueAsDouble", "", "(Ljava/lang/Object;)Ljava/lang/Double;", "getValueAsString", "matchStringInArray", "target", "parseISOTimestamp", "versionCompare", "", "v1", "v2", "android-sdk_release"})
public final class EvaluatorUtils {
    @NotNull
    public static final EvaluatorUtils INSTANCE = new EvaluatorUtils();

    private EvaluatorUtils() {
    }

    @Nullable
    public final String getValueAsString(@Nullable Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            return (String)input;
        }
        return input.toString();
    }

    @Nullable
    public final Double getValueAsDouble(@Nullable Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            return StringsKt.toDoubleOrNull((String)((String)input));
        }
        if (input instanceof ULong) {
            return UnsignedKt.ulongToDouble((long)((ULong)input).unbox-impl());
        }
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Number) {
            return ((Number)input).doubleValue();
        }
        return null;
    }

    public final boolean contains(@Nullable Object targets, @Nullable Object value, boolean ignoreCase) {
        Iterable iterable;
        if (targets == null || value == null) {
            return false;
        }
        Iterator iterator = targets;
        if (iterator instanceof Iterable) {
            iterable = (Iterable)((Object)targets);
        } else if (iterator instanceof Object[]) {
            iterable = ArraysKt.asIterable((Object[])((Object[])targets));
        } else {
            return false;
        }
        Iterable iterable2 = iterable;
        for (Object option : iterable2) {
            if (option instanceof String && value instanceof String && StringsKt.equals((String)((String)option), (String)((String)value), (boolean)ignoreCase)) {
                return true;
            }
            if (!Intrinsics.areEqual(option, (Object)value)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final Object getUserValueForField(@NotNull StatsigUser user, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return switch (field) {
            case "user_id", "userid" -> user.getUserID();
            case "email" -> user.getEmail();
            case "ipaddress", "ip", "ip_address" -> user.getIp();
            case "useragent", "user_agent" -> user.getUserAgent();
            case "country" -> user.getCountry();
            case "locale" -> user.getLocale();
            case "app_version", "appversion" -> user.getAppVersion();
            default -> null;
        };
    }

    @Nullable
    public final Object getFromUser(@NotNull StatsigUser user, @NotNull String field) {
        Object object;
        Object value;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Object object2 = this.getUserValueForField(user, field);
        if (object2 == null) {
            String string = field.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            object2 = this.getUserValueForField(user, string);
        }
        if (!((value = object2) != null && !Intrinsics.areEqual((Object)value, (Object)"") || user.getCustom() == null || (object = user.getCustom()) != null && (object = object.get(field)) != null)) {
            Map<String, Object> map = user.getCustom();
            if (map != null) {
                String string = field.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = map.get(string);
            } else {
                object = value = null;
            }
        }
        if ((value == null || Intrinsics.areEqual((Object)value, (Object)"")) && user.getPrivateAttributes() != null) {
            Map<String, Object> map = user.getPrivateAttributes();
            if (map == null || (map = map.get(field)) == null) {
                Map<String, Object> map2 = user.getPrivateAttributes();
                if (map2 != null) {
                    String string = field.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    map = map2.get(string);
                } else {
                    map = null;
                }
            }
            value = map;
        }
        return value;
    }

    @Nullable
    public final String getFromEnvironment(@NotNull StatsigUser user, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Map<String, String> map = user.getStatsigEnvironment$android_sdk_release();
        if (map == null || (map = map.get(field)) == null) {
            Map<String, String> map2 = user.getStatsigEnvironment$android_sdk_release();
            if (map2 != null) {
                String string = field.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                map = map2.get(string);
            } else {
                map = null;
            }
        }
        return map;
    }

    @Nullable
    public final String getUnitID(@NotNull StatsigUser user, @Nullable String idType) {
        String lowerIdType;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        String string = idType;
        if (string != null) {
            String string2 = string.toLowerCase(Locale.ROOT);
            v2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            v2 = lowerIdType = null;
        }
        if (!Intrinsics.areEqual((Object)lowerIdType, (Object)"userid")) {
            String string3 = lowerIdType;
            boolean bl = string3 != null ? !(((CharSequence)string3).length() == 0) : false;
            if (bl) {
                Map<String, String> map = user.getCustomIDs();
                if (map == null || (map = map.get(idType)) == null) {
                    Map<String, String> map2 = user.getCustomIDs();
                    map = map2 != null ? map2.get(lowerIdType) : null;
                }
                return map;
            }
        }
        return user.getUserID();
    }

    public final boolean matchStringInArray(@Nullable Object value, @Nullable Object target, @NotNull Function2<? super String, ? super String, Boolean> compare) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        String string = this.getValueAsString(value);
        if (string == null) {
            return false;
        }
        String strValue = string;
        Iterator iterator = target;
        if (iterator instanceof Iterable) {
            iterable = (Iterable)((Object)target);
        } else if (iterator instanceof Object[]) {
            iterable = ArraysKt.asIterable((Object[])((Object[])target));
        } else {
            return false;
        }
        Iterable iterable2 = iterable;
        for (Object match : iterable2) {
            String strMatch;
            if (this.getValueAsString(match) == null || !((Boolean)compare.invoke((Object)strValue, (Object)strMatch)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final ConfigEvaluation compareDates(@NotNull Function2<? super Date, ? super Date, Boolean> compare, @Nullable Object a, @Nullable Object b) {
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        if (a == null || b == null) {
            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
        }
        Date firstEpoch = this.getDate(a);
        Date secondEpoch = this.getDate(b);
        if (firstEpoch == null || secondEpoch == null) {
            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
        }
        return new ConfigEvaluation((Boolean)compare.invoke((Object)firstEpoch, (Object)secondEpoch), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
    }

    private final Long getEpoch(Object input) {
        long l;
        Object object = input;
        if (object instanceof String) {
            l = Long.parseLong((String)input);
        } else if (object instanceof Number) {
            l = ((Number)input).longValue();
        } else {
            return null;
        }
        long epoch = l;
        if (String.valueOf(epoch).length() < 11) {
            epoch *= (long)1000;
        }
        return epoch;
    }

    private final Date parseISOTimestamp(Object input) {
        if (input instanceof String) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                return format.parse((String)input);
            }
            catch (Exception e) {
                ErrorBoundary.logException$android_sdk_release$default(Statsig.INSTANCE.getClient$android_sdk_release().getErrorBoundary$android_sdk_release(), e, "parseISOTimestamp", null, 4, null);
                return null;
            }
        }
        return null;
    }

    private final Date getDate(Object input) {
        Date date;
        if (input == null) {
            return null;
        }
        try {
            Long l = this.getEpoch(input);
            if (l == null) {
                return this.parseISOTimestamp(input);
            }
            long epoch = l;
            date = new Date(epoch);
        }
        catch (Exception e) {
            date = this.parseISOTimestamp(input);
        }
        return date;
    }

    public final int versionCompare(@NotNull String v1, @NotNull String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        String[] stringArray = new String[]{"."};
        List parts1 = StringsKt.split$default((CharSequence)v1, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"."};
        List parts2 = StringsKt.split$default((CharSequence)v2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        for (int i = 0; i < RangesKt.coerceAtLeast((int)parts1.size(), (int)parts2.size()); ++i) {
            int c1 = 0;
            int c2 = 0;
            if (i < parts1.size()) {
                c1 = Integer.parseInt((String)parts1.get(i));
            }
            if (i < parts2.size()) {
                c2 = Integer.parseInt((String)parts2.get(i));
            }
            if (c1 < c2) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return 0;
    }
}

