/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk.evaluator;

import android.util.Log;
import com.statsig.androidsdk.Statsig;
import com.statsig.androidsdk.StatsigUser;
import com.statsig.androidsdk.evaluator.ConfigCondition;
import com.statsig.androidsdk.evaluator.ConfigEvaluation;
import com.statsig.androidsdk.evaluator.EvaluatorUtils;
import com.statsig.androidsdk.evaluator.ReturnableValue;
import com.statsig.androidsdk.evaluator.Spec;
import com.statsig.androidsdk.evaluator.SpecCondition;
import com.statsig.androidsdk.evaluator.SpecRule;
import com.statsig.androidsdk.evaluator.SpecStore;
import com.statsig.androidsdk.evaluator.UnsupportedEvaluationException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0017J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JJ\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2.\u0010\u001f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0!0 j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0!`\"H\u0002J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0002JT\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u00012\b\u0010)\u001a\u0004\u0018\u00010\u000126\u0010*\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b,\u0012\b\b\u0010\u0012\u0004\b\b(-\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b,\u0012\b\b\u0010\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020'0+H\u0002J \u0010/\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0017\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b2\u00103R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/statsig/androidsdk/evaluator/Evaluator;", "", "store", "Lcom/statsig/androidsdk/evaluator/SpecStore;", "<init>", "(Lcom/statsig/androidsdk/evaluator/SpecStore;)V", "calendarOne", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "calendarTwo", "hashLookupTable", "", "", "Lkotlin/ULong;", "evaluateGate", "Lcom/statsig/androidsdk/evaluator/ConfigEvaluation;", "name", "user", "Lcom/statsig/androidsdk/StatsigUser;", "evaluateGate$android_sdk_release", "evaluateConfig", "evaluateConfig$android_sdk_release", "evaluateLayer", "evaluateLayer$android_sdk_release", "evaluate", "spec", "Lcom/statsig/androidsdk/evaluator/Spec;", "evaluateRule", "rule", "Lcom/statsig/androidsdk/evaluator/SpecRule;", "evaluateDelegate", "secondaryExposures", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "evaluateCondition", "condition", "Lcom/statsig/androidsdk/evaluator/SpecCondition;", "versionCompareHelper", "", "version1", "version2", "compare", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "v1", "v2", "evaluatePassPercent", "computeUserHash", "input", "computeUserHash-I7RO_PI", "(Ljava/lang/String;)J", "android-sdk_release"})
public final class Evaluator {
    @NotNull
    private final SpecStore store;
    private final Calendar calendarOne;
    private final Calendar calendarTwo;
    @NotNull
    private Map<String, ULong> hashLookupTable;

    public Evaluator(@NotNull SpecStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
        this.calendarOne = Calendar.getInstance();
        this.calendarTwo = Calendar.getInstance();
        this.hashLookupTable = new HashMap();
    }

    @NotNull
    public final ConfigEvaluation evaluateGate$android_sdk_release(@NotNull String name, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Spec spec = this.store.getGate(name);
        if (spec == null) {
            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, true, null, 3071, null);
        }
        Spec spec2 = spec;
        return this.evaluate(user, spec2);
    }

    @NotNull
    public final ConfigEvaluation evaluateConfig$android_sdk_release(@NotNull String name, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Spec spec = this.store.getConfig(name);
        if (spec == null) {
            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, true, null, 3071, null);
        }
        Spec spec2 = spec;
        return this.evaluate(user, spec2);
    }

    @NotNull
    public final ConfigEvaluation evaluateLayer$android_sdk_release(@NotNull String name, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Spec spec = this.store.getLayer(name);
        if (spec == null) {
            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, true, null, 3071, null);
        }
        Spec spec2 = spec;
        return this.evaluate(user, spec2);
    }

    private final ConfigEvaluation evaluate(StatsigUser user, Spec spec) {
        try {
            if (!spec.getEnabled()) {
                return new ConfigEvaluation(false, spec.getDefaultValue().getValue(), spec.getDefaultValue(), "disabled", null, null, null, null, false, false, false, spec.getVersion(), 2032, null);
            }
            ArrayList<Map<String, String>> secondaryExposures = new ArrayList<Map<String, String>>();
            for (SpecRule rule : spec.getRules()) {
                ConfigEvaluation result = this.evaluateRule(user, rule);
                secondaryExposures.addAll((Collection)result.getSecondaryExposures());
                if (!result.getBooleanValue()) continue;
                ConfigEvaluation delegatedEval = this.evaluateDelegate(user, rule, secondaryExposures);
                if (delegatedEval != null) {
                    delegatedEval.setConfigVersion(spec.getVersion());
                    return delegatedEval;
                }
                boolean pass = this.evaluatePassPercent(user, spec, rule);
                Object object = pass ? result.getJsonValue() : spec.getDefaultValue().getValue();
                Boolean bl = rule.isExperimentGroup();
                return new ConfigEvaluation(pass, object, pass ? result.getReturnableValue() : spec.getDefaultValue(), result.getRuleID(), result.getGroupName(), secondaryExposures, null, null, bl != null ? bl : false, spec.isActive(), false, spec.getVersion(), 1216, null);
            }
            Object object = spec.getDefaultValue().getValue();
            ReturnableValue returnableValue = spec.getDefaultValue();
            Integer n = spec.getVersion();
            boolean bl = spec.isActive();
            return new ConfigEvaluation(false, object, returnableValue, "default", null, secondaryExposures, null, null, false, bl, false, n, 1472, null);
        }
        catch (UnsupportedEvaluationException e) {
            Statsig.INSTANCE.getClient$android_sdk_release().getErrorBoundary$android_sdk_release().logException$android_sdk_release(e, "evaluate");
            ReturnableValue returnableValue = spec.getDefaultValue();
            List list = spec.getExplicitParameters();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            Integer n = spec.getVersion();
            boolean bl = spec.isActive();
            return new ConfigEvaluation(false, returnableValue, null, "default", null, null, list2, null, false, bl, false, n, 1460, null);
        }
    }

    private final ConfigEvaluation evaluateRule(StatsigUser user, SpecRule rule) {
        ArrayList secondaryExposures = new ArrayList();
        boolean pass = true;
        for (SpecCondition condition : rule.getConditions()) {
            ConfigEvaluation result = this.evaluateCondition(user, condition);
            if (!result.getBooleanValue()) {
                pass = false;
            }
            secondaryExposures.addAll(result.getSecondaryExposures());
        }
        return new ConfigEvaluation(pass, rule.getReturnValue().getValue(), rule.getReturnValue(), rule.getId(), rule.getGroupName(), secondaryExposures, null, null, Intrinsics.areEqual((Object)rule.isExperimentGroup(), (Object)true), false, false, null, 3776, null);
    }

    private final ConfigEvaluation evaluateDelegate(StatsigUser user, SpecRule rule, ArrayList<Map<String, String>> secondaryExposures) {
        String string = rule.getConfigDelegate();
        if (string == null) {
            return null;
        }
        String configDelegate = string;
        Spec spec = this.store.getConfig(configDelegate);
        if (spec == null) {
            return null;
        }
        Spec config = spec;
        ConfigEvaluation delegatedResult = this.evaluate(user, config);
        ArrayList<Map<String, String>> undelegatedSecondaryExposures = new ArrayList<Map<String, String>>();
        undelegatedSecondaryExposures.addAll((Collection)secondaryExposures);
        secondaryExposures.addAll((Collection<Map<String, String>>)delegatedResult.getSecondaryExposures());
        boolean bl = delegatedResult.getBooleanValue();
        Object object = delegatedResult.getJsonValue();
        ReturnableValue returnableValue = delegatedResult.getReturnableValue();
        String string2 = delegatedResult.getRuleID();
        String string3 = delegatedResult.getGroupName();
        List<String> list = config.getExplicitParameters();
        boolean bl2 = delegatedResult.isExperimentGroup();
        boolean bl3 = delegatedResult.isActive();
        ConfigEvaluation evaluation = new ConfigEvaluation(bl, object, returnableValue, string2, string3, secondaryExposures, list, configDelegate, bl2, bl3, false, null, 3072, null);
        evaluation.setUndelegatedSecondaryExposures(undelegatedSecondaryExposures);
        return evaluation;
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigEvaluation evaluateCondition(StatsigUser user, SpecCondition condition) {
        try {
            block101: {
                ConfigCondition conditionEnum;
                Object object;
                Object value = null;
                String string = condition.getField();
                if (string == null) {
                    string = "";
                }
                String field = string;
                try {
                    String string2 = condition.getType().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    object = ConfigCondition.valueOf(string2);
                }
                catch (IllegalArgumentException e) {
                    throw new UnsupportedEvaluationException("Unsupported condition: " + condition.getType());
                }
                ConfigCondition configCondition = conditionEnum = object;
                switch (configCondition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[configCondition.ordinal()]) {
                    case 1: {
                        return new ConfigEvaluation(true, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 2: 
                    case 3: {
                        Object object2 = condition.getTargetValue();
                        if (object2 == null || (object2 = object2.toString()) == null) {
                            object2 = "";
                        }
                        Object name = object2;
                        ConfigEvaluation result = this.evaluateGate$android_sdk_release((String)name, user);
                        ArrayList<Map> secondaryExposures = new ArrayList<Map>();
                        secondaryExposures.addAll((Collection)result.getSecondaryExposures());
                        if (!StringsKt.startsWith$default((String)name, (String)"segment:", (boolean)false, (int)2, null)) {
                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"gate", (Object)name), TuplesKt.to((Object)"gateValue", (Object)String.valueOf(result.getBooleanValue())), TuplesKt.to((Object)"ruleID", (Object)result.getRuleID())};
                            Map newExposure = MapsKt.mapOf((Pair[])pairArray);
                            secondaryExposures.add(newExposure);
                        }
                        return new ConfigEvaluation(conditionEnum == ConfigCondition.PASS_GATE ? result.getBooleanValue() : !result.getBooleanValue(), result.getJsonValue(), result.getReturnableValue(), "", "", secondaryExposures, null, null, false, false, false, null, 4032, null);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        value = EvaluatorUtils.INSTANCE.getFromUser(user, field);
                        break;
                    }
                    case 7: {
                        value = String.valueOf(System.currentTimeMillis());
                        break;
                    }
                    case 8: {
                        value = EvaluatorUtils.INSTANCE.getFromEnvironment(user, field);
                        break;
                    }
                    case 9: {
                        Object v6;
                        EvaluatorUtils evaluatorUtils = EvaluatorUtils.INSTANCE;
                        Map<String, Object> map = condition.getAdditionalValues();
                        if (map != null) {
                            void it;
                            Map<String, Object> newExposure = map;
                            EvaluatorUtils evaluatorUtils2 = evaluatorUtils;
                            boolean bl = false;
                            v6 = it.get("salt");
                            evaluatorUtils = evaluatorUtils2;
                        } else {
                            v6 = null;
                        }
                        String salt = evaluatorUtils.getValueAsString(v6);
                        String string3 = EvaluatorUtils.INSTANCE.getUnitID(user, condition.getIdType());
                        if (string3 == null) {
                            string3 = "";
                        }
                        String unitID = string3;
                        value = ULong.box-impl((long)Long.remainderUnsigned(this.computeUserHash-I7RO_PI(salt + "." + unitID), 1000L));
                        break;
                    }
                    case 10: {
                        value = EvaluatorUtils.INSTANCE.getUnitID(user, condition.getIdType());
                        break;
                    }
                    default: {
                        Log.d((String)"STATSIG", (String)("Unsupported evaluation condition: " + conditionEnum));
                        throw new UnsupportedEvaluationException("Unsupported evaluation condition: " + conditionEnum);
                    }
                }
                object = condition.getOperator();
                if (object == null) break block101;
                int n = -1;
                switch (((String)object).hashCode()) {
                    case 689423350: {
                        if (((String)object).equals("version_lte")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1691202285: {
                        if (((String)object).equals("str_starts_with_any")) {
                            n = 2;
                        }
                        break;
                    }
                    case -745843766: {
                        if (((String)object).equals("str_contains_none")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1548092646: {
                        if (((String)object).equals("str_contains_any")) {
                            n = 4;
                        }
                        break;
                    }
                    case 689424819: {
                        if (((String)object).equals("version_neq")) {
                            n = 5;
                        }
                        break;
                    }
                    case -1392885889: {
                        if (((String)object).equals("before")) {
                            n = 6;
                        }
                        break;
                    }
                    case 689418545: {
                        if (((String)object).equals("version_gte")) {
                            n = 7;
                        }
                        break;
                    }
                    case -670497201: {
                        if (((String)object).equals("version_lt")) {
                            n = 8;
                        }
                        break;
                    }
                    case 3464: {
                        if (((String)object).equals("lt")) {
                            n = 9;
                        }
                        break;
                    }
                    case -921508102: {
                        if (((String)object).equals("any_case_sensitive")) {
                            n = 10;
                        }
                        break;
                    }
                    case 3387192: {
                        if (((String)object).equals("none")) {
                            n = 11;
                        }
                        break;
                    }
                    case 3244: {
                        if (((String)object).equals("eq")) {
                            n = 12;
                        }
                        break;
                    }
                    case 3309: {
                        if (((String)object).equals("gt")) {
                            n = 13;
                        }
                        break;
                    }
                    case 96748: {
                        if (((String)object).equals("any")) {
                            n = 14;
                        }
                        break;
                    }
                    case 1496001829: {
                        if (((String)object).equals("str_matches")) {
                            n = 15;
                        }
                        break;
                    }
                    case 1662804684: {
                        if (((String)object).equals("str_ends_with_any")) {
                            n = 16;
                        }
                        break;
                    }
                    case 1222504494: {
                        if (((String)object).equals("none_case_sensitive")) {
                            n = 17;
                        }
                        break;
                    }
                    case 102680: {
                        if (((String)object).equals("gte")) {
                            n = 18;
                        }
                        break;
                    }
                    case -670497421: {
                        if (((String)object).equals("version_eq")) {
                            n = 19;
                        }
                        break;
                    }
                    case 108954: {
                        if (((String)object).equals("neq")) {
                            n = 20;
                        }
                        break;
                    }
                    case 92734940: {
                        if (((String)object).equals("after")) {
                            n = 21;
                        }
                        break;
                    }
                    case 107485: {
                        if (((String)object).equals("lte")) {
                            n = 22;
                        }
                        break;
                    }
                    case -670497356: {
                        if (((String)object).equals("version_gt")) {
                            n = 23;
                        }
                        break;
                    }
                    case 3551: {
                        if (((String)object).equals("on")) {
                            n = 24;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 13: {
                        Double doubleValue = EvaluatorUtils.INSTANCE.getValueAsDouble(value);
                        Double doubleTargetValue = EvaluatorUtils.INSTANCE.getValueAsDouble(condition.getTargetValue());
                        if (doubleValue == null || doubleTargetValue == null) {
                            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                        }
                        return new ConfigEvaluation(doubleValue > doubleTargetValue, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 18: {
                        Double doubleValue = EvaluatorUtils.INSTANCE.getValueAsDouble(value);
                        Double doubleTargetValue = EvaluatorUtils.INSTANCE.getValueAsDouble(condition.getTargetValue());
                        if (doubleValue == null || doubleTargetValue == null) {
                            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                        }
                        return new ConfigEvaluation(doubleValue >= doubleTargetValue, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 9: {
                        Double doubleValue = EvaluatorUtils.INSTANCE.getValueAsDouble(value);
                        Double doubleTargetValue = EvaluatorUtils.INSTANCE.getValueAsDouble(condition.getTargetValue());
                        if (doubleValue == null || doubleTargetValue == null) {
                            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                        }
                        return new ConfigEvaluation(doubleValue < doubleTargetValue, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 22: {
                        Double doubleValue = EvaluatorUtils.INSTANCE.getValueAsDouble(value);
                        Double doubleTargetValue = EvaluatorUtils.INSTANCE.getValueAsDouble(condition.getTargetValue());
                        if (doubleValue == null || doubleTargetValue == null) {
                            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                        }
                        return new ConfigEvaluation(doubleValue <= doubleTargetValue, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 23: {
                        return new ConfigEvaluation(this.versionCompareHelper(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$1)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 7: {
                        return new ConfigEvaluation(this.versionCompareHelper(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$2)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 8: {
                        return new ConfigEvaluation(this.versionCompareHelper(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$3)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 1: {
                        return new ConfigEvaluation(this.versionCompareHelper(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$4)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 19: {
                        return new ConfigEvaluation(this.versionCompareHelper(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$5)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 5: {
                        return new ConfigEvaluation(this.versionCompareHelper(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$6)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 14: {
                        return new ConfigEvaluation(EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$7)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 11: {
                        return new ConfigEvaluation(!EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$8)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 10: {
                        return new ConfigEvaluation(EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$9)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 17: {
                        return new ConfigEvaluation(!EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$10)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 2: {
                        return new ConfigEvaluation(EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$11)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 16: {
                        return new ConfigEvaluation(EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$12)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 4: {
                        return new ConfigEvaluation(EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$13)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 3: {
                        return new ConfigEvaluation(!EvaluatorUtils.INSTANCE.matchStringInArray(value, condition.getTargetValue(), (Function2<? super String, ? super String, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$14)), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 15: {
                        String string4 = EvaluatorUtils.INSTANCE.getValueAsString(condition.getTargetValue());
                        if (string4 == null) {
                            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                        }
                        String targetValue = string4;
                        String string5 = EvaluatorUtils.INSTANCE.getValueAsString(value);
                        if (string5 == null) {
                            return new ConfigEvaluation(false, null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                        }
                        String strValue = string5;
                        return new ConfigEvaluation(new Regex(targetValue).containsMatchIn((CharSequence)strValue), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 12: {
                        return new ConfigEvaluation(Intrinsics.areEqual((Object)value, (Object)condition.getTargetValue()), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 20: {
                        return new ConfigEvaluation(!Intrinsics.areEqual((Object)value, (Object)condition.getTargetValue()), null, null, null, null, null, null, null, false, false, false, null, 4094, null);
                    }
                    case 6: {
                        return EvaluatorUtils.INSTANCE.compareDates((Function2<? super Date, ? super Date, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$15), value, condition.getTargetValue());
                    }
                    case 21: {
                        return EvaluatorUtils.INSTANCE.compareDates((Function2<? super Date, ? super Date, Boolean>)((Function2)Evaluator::evaluateCondition$lambda$16), value, condition.getTargetValue());
                    }
                    case 24: {
                        return EvaluatorUtils.INSTANCE.compareDates((Function2<? super Date, ? super Date, Boolean>)((Function2)(arg_0, arg_1) -> Evaluator.evaluateCondition$lambda$17(this, arg_0, arg_1)), value, condition.getTargetValue());
                    }
                }
            }
            throw new UnsupportedEvaluationException("Unsupported evaluation conditon operator: " + condition.getOperator());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedEvaluationException("IllegalArgumentException when evaluate conditions");
        }
    }

    private final boolean versionCompareHelper(Object version1, Object version2, Function2<? super String, ? super String, Boolean> compare) {
        boolean bl;
        int dashIndex2;
        String version1Str = EvaluatorUtils.INSTANCE.getValueAsString(version1);
        String version2Str = EvaluatorUtils.INSTANCE.getValueAsString(version2);
        if (version1Str == null || version2Str == null) {
            return false;
        }
        int dashIndex1 = StringsKt.indexOf$default((CharSequence)version1Str, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (dashIndex1 > 0) {
            String string = version1Str.substring(0, dashIndex1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            version1Str = string;
        }
        if ((dashIndex2 = StringsKt.indexOf$default((CharSequence)version2Str, (char)'-', (int)0, (boolean)false, (int)6, null)) > 0) {
            String string = version2Str.substring(0, dashIndex2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            version2Str = string;
        }
        try {
            bl = (Boolean)compare.invoke((Object)version1Str, (Object)version2Str);
        }
        catch (NumberFormatException e) {
            bl = false;
        }
        catch (Exception e) {
            Statsig.INSTANCE.getClient$android_sdk_release().getErrorBoundary$android_sdk_release().logException$android_sdk_release(e, "versionCompareHelper");
            bl = false;
        }
        return bl;
    }

    private final boolean evaluatePassPercent(StatsigUser user, Spec spec, SpecRule rule) {
        long l;
        long l2;
        String string;
        String string2 = spec.getSalt();
        String string3 = rule.getSalt();
        if (string3 == null) {
            string3 = rule.getId();
        }
        if ((string = EvaluatorUtils.INSTANCE.getUnitID(user, rule.getIdType())) == null) {
            string = "";
        }
        return Long.compareUnsigned(Long.remainderUnsigned(l2 = this.computeUserHash-I7RO_PI(string2 + "." + string3 + "." + string), l = 10000L), UnsignedKt.doubleToULong((double)(rule.getPassPercentage() * 100.0))) < 0;
    }

    private final long computeUserHash-I7RO_PI(String input) {
        ULong uLong = this.hashLookupTable.get(input);
        if (uLong != null) {
            long it = uLong.unbox-impl();
            boolean bl = false;
            return it;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        String it = input;
        byte[] byArray = it.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] inputBytes = byArray;
        byte[] bytes = md.digest(inputBytes);
        long hash = ULong.constructor-impl((long)ByteBuffer.wrap(bytes).getLong());
        if (this.hashLookupTable.size() > 1000) {
            this.hashLookupTable.clear();
        }
        this.hashLookupTable.put(input, ULong.box-impl((long)hash));
        return hash;
    }

    private static final boolean evaluateCondition$lambda$1(String v1, String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return EvaluatorUtils.INSTANCE.versionCompare(v1, v2) > 0;
    }

    private static final boolean evaluateCondition$lambda$2(String v1, String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return EvaluatorUtils.INSTANCE.versionCompare(v1, v2) >= 0;
    }

    private static final boolean evaluateCondition$lambda$3(String v1, String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return EvaluatorUtils.INSTANCE.versionCompare(v1, v2) < 0;
    }

    private static final boolean evaluateCondition$lambda$4(String v1, String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return EvaluatorUtils.INSTANCE.versionCompare(v1, v2) <= 0;
    }

    private static final boolean evaluateCondition$lambda$5(String v1, String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return EvaluatorUtils.INSTANCE.versionCompare(v1, v2) == 0;
    }

    private static final boolean evaluateCondition$lambda$6(String v1, String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return EvaluatorUtils.INSTANCE.versionCompare(v1, v2) != 0;
    }

    private static final boolean evaluateCondition$lambda$7(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.equals((String)a, (String)b, (boolean)true);
    }

    private static final boolean evaluateCondition$lambda$8(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.equals((String)a, (String)b, (boolean)true);
    }

    private static final boolean evaluateCondition$lambda$9(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.equals((String)a, (String)b, (boolean)false);
    }

    private static final boolean evaluateCondition$lambda$10(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.equals((String)a, (String)b, (boolean)false);
    }

    private static final boolean evaluateCondition$lambda$11(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.startsWith((String)a, (String)b, (boolean)true);
    }

    private static final boolean evaluateCondition$lambda$12(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.endsWith((String)a, (String)b, (boolean)true);
    }

    private static final boolean evaluateCondition$lambda$13(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.contains((CharSequence)a, (CharSequence)b, (boolean)true);
    }

    private static final boolean evaluateCondition$lambda$14(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return StringsKt.contains((CharSequence)a, (CharSequence)b, (boolean)true);
    }

    private static final boolean evaluateCondition$lambda$15(Date a, Date b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.before(b);
    }

    private static final boolean evaluateCondition$lambda$16(Date a, Date b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.after(b);
    }

    private static final boolean evaluateCondition$lambda$17(Evaluator this$0, Date a, Date b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this$0.calendarOne.setTime(a);
        this$0.calendarTwo.setTime(b);
        return this$0.calendarOne.get(1) == this$0.calendarTwo.get(1) && this$0.calendarOne.get(6) == this$0.calendarTwo.get(6);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigCondition.values().length];
            try {
                nArray[ConfigCondition.PUBLIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.FAIL_GATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.PASS_GATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.USER_FIELD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.IP_BASED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.UA_BASED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.CURRENT_TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.ENVIRONMENT_FIELD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.USER_BUCKET.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigCondition.UNIT_ID.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

