/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00042\u00020\u0001:\u0003\u0004\u0005\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/statsig/androidsdk/DebugView;", "", "<init>", "()V", "Companion", "DebugWebViewClient", "DebugWebChromeClient", "android-sdk_release"})
public final class DebugView {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u001a\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0005\u0018\u00010\rj\u0004\u0018\u0001`\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/statsig/androidsdk/DebugView$Companion;", "", "<init>", "()V", "show", "", "context", "Landroid/content/Context;", "sdkKey", "", "state", "", "callback", "Lkotlin/Function1;", "", "Lcom/statsig/androidsdk/DebugViewCallback;", "getConfiguredWebView", "Landroid/webkit/WebView;", "client", "Lcom/statsig/androidsdk/DebugView$DebugWebViewClient;", "chromeClient", "Lcom/statsig/androidsdk/DebugView$DebugWebChromeClient;", "android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void show(@NotNull Context context, @NotNull String sdkKey, @NotNull Map<String, ? extends Object> state, @Nullable Function1<? super Boolean, Unit> callback) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
                Intrinsics.checkNotNullParameter(state, (String)"state");
                Dialog dialog = new Dialog(context, 16973834);
                String string = new Gson().toJson(state);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                DebugWebViewClient client = new DebugWebViewClient(string);
                DebugWebChromeClient chromeClient = new DebugWebChromeClient(dialog, callback);
                WebView webView = this.getConfiguredWebView(context, client, chromeClient);
                dialog.requestWindowFeature(1);
                dialog.setOnKeyListener((arg_0, arg_1, arg_2) -> Companion.show$lambda$0(webView, dialog, arg_0, arg_1, arg_2));
                webView.loadUrl("https://console.statsig.com/client_sdk_debugger_redirect?sdkKey=" + sdkKey);
                dialog.setContentView((View)webView);
                dialog.show();
                Window window = dialog.getWindow();
                if (window == null) break block0;
                window.setLayout(-1, -1);
            }
        }

        private final WebView getConfiguredWebView(Context context, DebugWebViewClient client, DebugWebChromeClient chromeClient) {
            WebView webView = new WebView(context);
            webView.setWebViewClient((WebViewClient)client);
            webView.setWebChromeClient((WebChromeClient)chromeClient);
            webView.setSystemUiVisibility(2);
            WebSettings it = webView.getSettings();
            boolean bl = false;
            it.setJavaScriptCanOpenWindowsAutomatically(true);
            it.setJavaScriptEnabled(true);
            it.setDatabaseEnabled(true);
            it.setDomStorageEnabled(true);
            webView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            if (Build.VERSION.SDK_INT >= 21) {
                CookieManager.getInstance().setAcceptThirdPartyCookies(webView, true);
            }
            return webView;
        }

        private static final boolean show$lambda$0(WebView $webView, Dialog $dialog, DialogInterface dialogInterface, int keyCode, KeyEvent event) {
            if (keyCode == 4 && event.getAction() == 1 && $webView.canGoBack()) {
                String[] stringArray;
                $webView.goBack();
                Object object = $webView.getUrl();
                boolean bl = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null && (object = (String)CollectionsKt.last((List)object)) != null ? StringsKt.startsWith$default((String)object, (String)"client_sdk_debugger", (boolean)false, (int)2, null) : false;
                if (bl) {
                    $dialog.dismiss();
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005j\u0004\u0018\u0001`\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005j\u0004\u0018\u0001`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/statsig/androidsdk/DebugView$DebugWebChromeClient;", "Landroid/webkit/WebChromeClient;", "dialog", "Landroid/app/Dialog;", "callback", "Lkotlin/Function1;", "", "", "Lcom/statsig/androidsdk/DebugViewCallback;", "<init>", "(Landroid/app/Dialog;Lkotlin/jvm/functions/Function1;)V", "closeAction", "", "reloadRequired", "onConsoleMessage", "consoleMessage", "Landroid/webkit/ConsoleMessage;", "android-sdk_release"})
    private static final class DebugWebChromeClient
    extends WebChromeClient {
        @NotNull
        private final Dialog dialog;
        @Nullable
        private final Function1<Boolean, Unit> callback;
        @NotNull
        private final String closeAction;
        @NotNull
        private final String reloadRequired;

        public DebugWebChromeClient(@NotNull Dialog dialog, @Nullable Function1<? super Boolean, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            this.dialog = dialog;
            this.callback = callback;
            this.closeAction = "STATSIG_ANDROID_DEBUG_CLOSE_DIALOG";
            this.reloadRequired = "STATSIG_ANDROID_DEBUG_RELOAD_REQUIRED";
        }

        public boolean onConsoleMessage(@Nullable ConsoleMessage consoleMessage) {
            block3: {
                Object object = consoleMessage;
                if (object == null || (object = object.message()) == null) break block3;
                Object it = object;
                boolean bl = false;
                if (StringsKt.contentEquals((CharSequence)((CharSequence)it), (CharSequence)this.closeAction, (boolean)true)) {
                    this.dialog.dismiss();
                }
                if (StringsKt.contentEquals((CharSequence)((CharSequence)it), (CharSequence)this.reloadRequired, (boolean)true)) {
                    Function1<Boolean, Unit> function1 = this.callback;
                    if (function1 != null) {
                        function1.invoke((Object)true);
                    }
                }
            }
            return super.onConsoleMessage(consoleMessage);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/statsig/androidsdk/DebugView$DebugWebViewClient;", "Landroid/webkit/WebViewClient;", "json", "", "<init>", "(Ljava/lang/String;)V", "onPageFinished", "", "view", "Landroid/webkit/WebView;", "url", "android-sdk_release"})
    private static final class DebugWebViewClient
    extends WebViewClient {
        @NotNull
        private final String json;

        public DebugWebViewClient(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            this.json = json;
        }

        public void onPageFinished(@Nullable WebView view, @Nullable String url) {
            block1: {
                super.onPageFinished(view, url);
                WebView webView = view;
                if (webView != null) {
                    webView.evaluateJavascript("window.__StatsigAndroidDebug=true;", null);
                }
                String js = "window.__StatsigClientState = " + this.json + ";";
                WebView webView2 = view;
                if (webView2 == null) break block1;
                webView2.evaluateJavascript(js, null);
            }
        }
    }
}

