/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import com.statsig.androidsdk.DnsTxtFetchError;
import com.statsig.androidsdk.DnsTxtParseError;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0013\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"DNS_QUERY_ENDPOINT", "", "DOMAIN_CHARS", "", "", "getDOMAIN_CHARS", "()Ljava/util/List;", "FEATURE_ASSETS_DNS_QUERY", "", "getFEATURE_ASSETS_DNS_QUERY", "()[B", "MAX_START_LOOKUP", "", "createHttpConnection", "Ljava/net/HttpURLConnection;", "url", "fetchTxtRecords", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseDnsResponse", "input", "build_release"})
public final class DnsTxtQueryKt {
    @NotNull
    private static final byte[] FEATURE_ASSETS_DNS_QUERY;
    @NotNull
    public static final String DNS_QUERY_ENDPOINT = "https://cloudflare-dns.com/dns-query";
    @NotNull
    private static final List<Character> DOMAIN_CHARS;
    public static final int MAX_START_LOOKUP = 200;

    @NotNull
    public static final byte[] getFEATURE_ASSETS_DNS_QUERY() {
        return FEATURE_ASSETS_DNS_QUERY;
    }

    @NotNull
    public static final List<Character> getDOMAIN_CHARS() {
        return DOMAIN_CHARS;
    }

    @Nullable
    public static final Object fetchTxtRecords(@NotNull Continuation<? super List<String>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(null){
            int label;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HttpURLConnection connection = DnsTxtQueryKt.access$createHttpConnection("https://cloudflare-dns.com/dns-query");
                        try {
                            Closeable closeable = connection.getOutputStream();
                            boolean bl = false;
                            boolean bl2 = false;
                            Object object3 = null;
                            try {
                                OutputStream outputStream = (OutputStream)closeable;
                                boolean bl3 = false;
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                boolean bl4 = false;
                                boolean bl5 = false;
                                ByteArrayOutputStream $this$invokeSuspend_u24lambda_u2d1_u24lambda_u2d0 = byteArrayOutputStream;
                                boolean bl6 = false;
                                $this$invokeSuspend_u24lambda_u2d1_u24lambda_u2d0.write(DnsTxtQueryKt.getFEATURE_ASSETS_DNS_QUERY());
                                byte[] byteArray = byteArrayOutputStream.toByteArray();
                                outputStream.write(byteArray);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                object3 = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                            }
                            if (connection.getResponseCode() != 200) {
                                throw new DnsTxtFetchError("Failed to fetch TXT records from DNS");
                            }
                            InputStream inputStream = connection.getInputStream();
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                            byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
                            object3 = DnsTxtQueryKt.parseDnsResponse(bytes);
                            return object3;
                        }
                        catch (Exception exception) {
                            throw new DnsTxtFetchError("Request timed out while fetching TXT records");
                        }
                        finally {
                            connection.disconnect();
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final HttpURLConnection createHttpConnection(String url) {
        URLConnection uRLConnection = new URL(url).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        uRLConnection = connection;
        boolean bl = false;
        boolean bl2 = false;
        URLConnection $this$createHttpConnection_u24lambda_u2d0 = uRLConnection;
        boolean bl3 = false;
        ((HttpURLConnection)$this$createHttpConnection_u24lambda_u2d0).setRequestMethod("POST");
        $this$createHttpConnection_u24lambda_u2d0.setRequestProperty("Content-Type", "application/dns-message");
        $this$createHttpConnection_u24lambda_u2d0.setRequestProperty("Accept", "application/dns-message");
        $this$createHttpConnection_u24lambda_u2d0.setDoOutput(true);
        return connection;
    }

    @NotNull
    public static final List<String> parseDnsResponse(@NotNull byte[] input) {
        int startIndex;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Iterable $this$indexOfFirst$iv = ArraysKt.withIndex((byte[])input);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                boolean bl = false;
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IndexedValue $dstr$index$byte = (IndexedValue)item$iv;
                boolean bl2 = false;
                int index = $dstr$index$byte.component1();
                byte by = ((Number)$dstr$index$byte.component2()).byteValue();
                boolean bl3 = index < 200 && (char)by == '=' && index > 0 && DnsTxtQueryKt.getDOMAIN_CHARS().contains(Character.valueOf((char)input[index - 1]));
                if (bl3) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (startIndex == -1) {
            throw new DnsTxtParseError("Failed to parse TXT records from DNS");
        }
        Object[] objectArray = input;
        int n = startIndex - 1;
        int n2 = input.length;
        boolean bl = false;
        objectArray = ArraysKt.copyOfRange((byte[])objectArray, (int)n, (int)n2);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        n2 = 0;
        String result = new String((byte[])objectArray, charset);
        objectArray = new String[1];
        objectArray[0] = (byte)",";
        return StringsKt.split$default((CharSequence)result, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
    }

    public static final /* synthetic */ HttpURLConnection access$createHttpConnection(String url) {
        return DnsTxtQueryKt.createHttpConnection(url);
    }

    static {
        Object[] objectArray = new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 13, 102, 101, 97, 116, 117, 114, 101, 97, 115, 115, 101, 116, 115, 3, 111, 114, 103, 0, 0, 16, 0, 1};
        FEATURE_ASSETS_DNS_QUERY = objectArray;
        objectArray = new Character[3];
        objectArray[0] = (byte)Character.valueOf('i');
        objectArray[1] = (byte)Character.valueOf('e');
        objectArray[2] = (byte)Character.valueOf('d');
        DOMAIN_CHARS = CollectionsKt.listOf((Object[])objectArray);
    }
}

