/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.viewinguserdialog;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.viewinguserdialog.ViewingUserDto;
import br.com.stant.libraries.uilibrary.components.viewinguserdialog.ViewingUsersDialogViewContract;
import br.com.stant.libraries.uilibrary.databinding.ViewingUsersDialogItemBinding;
import com.squareup.picasso.Picasso;
import java.util.List;

public class ViewingUsersDialogAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    private ItemViewHolder mViewHolder;
    private List<ViewingUserDto> mTeamMembers;
    private Context mContext;
    private ViewingUsersDialogViewContract mServiceInspectionFormFilledContract;

    public void replaceData(List<ViewingUserDto> viewingUsersDto) {
        this.setList(viewingUsersDto);
        this.notifyDataSetChanged();
    }

    private void setList(List<ViewingUserDto> list) {
        this.mTeamMembers = list;
    }

    public ViewingUsersDialogAdapter(Context context, List<ViewingUserDto> teamMembers, ViewingUsersDialogViewContract viewingUsersDialogViewContract) {
        this.mTeamMembers = teamMembers;
        this.mContext = context;
        this.mServiceInspectionFormFilledContract = viewingUsersDialogViewContract;
    }

    public ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewingUsersDialogItemBinding viewingUsersDialogItemBinding = (ViewingUsersDialogItemBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)parent.getContext()), (int)R.layout.viewing_users_days_worked_dialog_item, (ViewGroup)parent, (boolean)false);
        return new ItemViewHolder(viewingUsersDialogItemBinding);
    }

    public void onBindViewHolder(ItemViewHolder holder, int position) {
        this.mViewHolder = holder;
        ViewingUserDto teamMember = this.mTeamMembers.get(position);
        ((ItemViewHolder)this.mViewHolder).mViewingUsersDialogItemBinding.viewingUsersDialogItemUserNameTextView.setText((CharSequence)teamMember.getUserName());
        ((ItemViewHolder)this.mViewHolder).mViewingUsersDialogItemBinding.viewingUsersDialogItemUserFunctionTextView.setText((CharSequence)teamMember.getUserFunction());
        if (teamMember.hasUserPhoto()) {
            Picasso.with((Context)this.mContext).load(teamMember.getUserPhoto()).resize(180, 180).centerCrop().placeholder(R.drawable.ic_user_holder).error(R.drawable.ic_user_holder).into((ImageView)((ItemViewHolder)this.mViewHolder).mViewingUsersDialogItemBinding.viewingUsersDialogItemUserPhotoCircularImageView);
        }
    }

    public int getItemCount() {
        return this.mTeamMembers.size();
    }

    public class ItemViewHolder
    extends RecyclerView.ViewHolder {
        private ViewingUsersDialogItemBinding mViewingUsersDialogItemBinding;

        public ItemViewHolder(ViewingUsersDialogItemBinding mServiceInspectionFormFilledDetailTeamDialogItemBinding) {
            super(mServiceInspectionFormFilledDetailTeamDialogItemBinding.getRoot());
            this.mViewingUsersDialogItemBinding = mServiceInspectionFormFilledDetailTeamDialogItemBinding;
        }
    }
}

